/************************************************************************************************/
/* Stata User File for H89 Data                                                                 */
/*                                                                                              */
/* This file contains information and a sample Stata program to create a permanent              */
/* Stata dataset for users who want to use Stata in processing the MEPS data provided           */
/* in this PUF release.  Stata (StataCorp) has the capability to produce                        */
/* appropriate standard errors for estimates from a survey with a complex sample                */
/* design such as the Medical Expenditure Panel Survey (MEPS).                                  */
/* The input file for creating a permanent Stata dataset is the ASCII data file                 */
/* (H89.DAT) supplied in this PUF release, which in turn can be extracted from the              */
/* .EXE file. After entering the Stata interactive environment access the Stata DO-File         */
/* editor by clicking on the appropriate icon in the command line at the top of the             */
/* screen.  Copy and paste the following Stata commands into the editor and save as a           */
/* DO file.  A DO file is a Stata program which may then be executed using the DO command.      */
/* For example, if the DO file is named H89.DO and is located in the directory                  */
/* C:\MEPS\PROG, then the file may be executed by typing the following command into             */
/* the Stata command line:                                                                      */
/*                         do C:\MEPS\PROG\H89.DO                                               */
/* The program below will output the Stata dataset H89.DTA                                      */
/************************************************************************************************/


#delimit ;
cd $datadir/MEPS/dat/fullyearconsolidated;
clear;

* INPUT ALL VARIABLES;
infix
  long   DUID 1-5
  int    PID 6-8
  str    DUPERSID 9-16
  byte   PANEL04 17-17
  str    FAMID31 18-19
  str    FAMID42 20-21
  str    FAMID53 22-23
  str    FAMID04 24-25
  str    FAMIDYR 26-27
  str    CPSFAMID 28-29
  str    HIEUIDX 30-36
  byte   FCSZ1231 37-38
  byte   FCRP1231 39-40
  str    RULETR31 41-42
  str    RULETR42 43-44
  str    RULETR53 45-46
  str    RULETR04 47-48
  byte   RUSIZE31 49-50
  byte   RUSIZE42 51-52
  byte   RUSIZE53 53-54
  byte   RUSIZE04 55-56
  byte   RUCLAS31 57-58
  byte   RUCLAS42 59-60
  byte   RUCLAS53 61-62
  byte   RUCLAS04 63-63
  byte   FAMSZE31 64-65
  byte   FAMSZE42 66-67
  byte   FAMSZE53 68-69
  byte   FAMSZE04 70-71
  byte   FMRS1231 72-73
  byte   FAMS1231 74-75
  byte   FAMSZEYR 76-77
  byte   FAMRFPYR 78-79
  byte   REGION31 80-81
  byte   REGION42 82-83
  byte   REGION53 84-85
  byte   REGION04 86-87
  byte   MSA31 88-89
  byte   MSA42 90-91
  byte   MSA53 92-93
  byte   MSA04 94-95
  int    REFPRS31 96-98
  int    REFPRS42 99-101
  int    REFPRS53 102-104
  int    REFPRS04 105-107
  byte   RESP31 108-108
  byte   RESP42 109-109
  byte   RESP53 110-110
  byte   RESP04 111-111
  byte   PROXY31 112-113
  byte   PROXY42 114-115
  byte   PROXY53 116-117
  byte   PROXY04 118-118
  byte   INTVLANG 119-120
  byte   BEGRFD31 121-122
  byte   BEGRFM31 123-124
  int    BEGRFY31 125-128
  byte   ENDRFD31 129-130
  byte   ENDRFM31 131-132
  int    ENDRFY31 133-136
  byte   BEGRFD42 137-138
  byte   BEGRFM42 139-140
  int    BEGRFY42 141-144
  byte   ENDRFD42 145-146
  byte   ENDRFM42 147-148
  int    ENDRFY42 149-152
  byte   BEGRFD53 153-154
  byte   BEGRFM53 155-156
  int    BEGRFY53 157-160
  byte   ENDRFD53 161-162
  byte   ENDRFM53 163-164
  int    ENDRFY53 165-168
  byte   ENDRFD04 169-170
  byte   ENDRFM04 171-172
  int    ENDRFY04 173-176
  byte   KEYNESS 177-177
  byte   INSCOP31 178-178
  byte   INSCOP42 179-179
  byte   INSCOP53 180-180
  byte   INSCOP04 181-181
  byte   INSC1231 182-182
  byte   INSCOPE 183-183
  byte   ELGRND31 184-184
  byte   ELGRND42 185-185
  byte   ELGRND53 186-186
  byte   ELGRND04 187-187
  byte   PSTATS31 188-189
  byte   PSTATS42 190-191
  byte   PSTATS53 192-193
  str    RURSLT31 194-195
  str    RURSLT42 196-197
  str    RURSLT53 198-199
  byte   AGE31X 200-201
  byte   AGE42X 202-203
  byte   AGE53X 204-205
  byte   AGE04X 206-207
  byte   DOBMM 208-209
  int    DOBYY 210-213
  byte   SEX 214-214
  byte   RACEX 215-215
  byte   RACEAX 216-216
  byte   RACEBX 217-217
  byte   RACEWX 218-218
  byte   RACETHNX 219-219
  byte   HISPANX 220-220
  byte   HISPCAT 221-222
  byte   MARRY31X 223-224
  byte   MARRY42X 225-226
  byte   MARRY53X 227-228
  byte   MARRY04X 229-230
  int    SPOUID31 231-233
  int    SPOUID42 234-236
  int    SPOUID53 237-239
  int    SPOUID04 240-242
  byte   SPOUIN31 243-244
  byte   SPOUIN42 245-246
  byte   SPOUIN53 247-248
  byte   SPOUIN04 249-250
  byte   EDUCYEAR 251-252
  byte   HIDEGYR 253-254
  byte   FTSTU31X 255-256
  byte   FTSTU42X 257-258
  byte   FTSTU53X 259-260
  byte   FTSTU04X 261-262
  byte   ACTDTY31 263-264
  byte   ACTDTY42 265-266
  byte   ACTDTY53 267-268
  byte   DIDSERVE 269-270
  byte   VETVIET 271-272
  byte   VETKOR 273-274
  byte   VETWW 275-276
  byte   VETGULF 277-278
  byte   VETOTH 279-280
  byte   RFREL31X 281-282
  byte   RFREL42X 283-284
  byte   RFREL53X 285-286
  byte   RFREL04X 287-288
  int    MOPID31X 289-291
  int    MOPID42X 292-294
  int    MOPID53X 295-297
  int    DAPID31X 298-300
  int    DAPID42X 301-303
  int    DAPID53X 304-306
  byte   SSIDIS04 307-308
  byte   AFDC04 309-310
  byte   FILEDR04 311-312
  byte   WILFIL04 313-314
  byte   FLSTAT04 315-316
  byte   FILER04 317-318
  byte   JTINRU04 319-320
  int    JNTPID04 321-323
  byte   CLMDEP04 324-325
  byte   DEPDNT04 326-327
  byte   DPINRU04 328-329
  byte   DPOTSD04 330-331
  byte   TAXFRM04 332-333
  byte   DEDUCT04 334-335
  double TOTDED04 336-344
  byte   CLMHIP04 345-346
  byte   EICRDT04 347-348
  byte   FOODST04 349-350
  byte   FOODMN04 351-352
  double FOODCT04 353-358
  double FOODVL04 359-365
  long   TTLP04X 366-371
  byte   POVCAT04 372-372
  long   WAGEP04X 373-378
  byte   WAGIMP04 379-379
  long   BUSNP04X 380-386
  byte   BUSIMP04 387-387
  long   UNEMP04X 388-392
  byte   UNEIMP04 393-393
  long   WCMPP04X 394-398
  byte   WCPIMP04 399-399
  long   INTRP04X 400-404
  byte   INTIMP04 405-405
  long   DIVDP04X 406-410
  byte   DIVIMP04 411-411
  long   SALEP04X 412-417
  byte   SALIMP04 418-418
  long   PENSP04X 419-424
  byte   PENIMP04 425-425
  long   SSECP04X 426-430
  byte   SSCIMP04 431-431
  long   TRSTP04X 432-437
  byte   TRTIMP04 438-438
  long   VETSP04X 439-443
  byte   VETIMP04 444-444
  long   IRASP04X 445-449
  byte   IRAIMP04 450-450
  long   REFDP04X 451-455
  byte   REFIMP04 456-456
  long   ALIMP04X 457-461
  byte   ALIIMP04 462-462
  long   CHLDP04X 463-467
  byte   CHLIMP04 468-468
  long   CASHP04X 469-473
  byte   CSHIMP04 474-474
  long   SSIP04X 475-479
  byte   SSIIMP04 480-480
  int    PUBP04X 481-484
  byte   PUBIMP04 485-485
  long   OTHRP04X 486-490
  byte   OTHIMP04 491-491
  byte   RTHLTH31 492-493
  byte   RTHLTH42 494-495
  byte   RTHLTH53 496-497
  byte   MNHLTH31 498-499
  byte   MNHLTH42 500-501
  byte   MNHLTH53 502-503
  byte   IADLHP31 504-505
  byte   IADLHP42 506-507
  byte   IADLHP53 508-509
  byte   IADL3M31 510-511
  byte   IADL3M42 512-513
  byte   IADL3M53 514-515
  byte   ADLHLP31 516-517
  byte   ADLHLP42 518-519
  byte   ADLHLP53 520-521
  byte   ADL3MO31 522-523
  byte   ADL3MO42 524-525
  byte   ADL3MO53 526-527
  byte   AIDHLP31 528-529
  byte   AIDHLP53 530-531
  byte   WLKLIM31 532-533
  byte   WLKLIM53 534-535
  byte   LFTDIF31 536-537
  byte   LFTDIF53 538-539
  byte   STPDIF31 540-541
  byte   STPDIF53 542-543
  byte   WLKDIF31 544-545
  byte   WLKDIF53 546-547
  byte   MILDIF31 548-549
  byte   MILDIF53 550-551
  byte   STNDIF31 552-553
  byte   STNDIF53 554-555
  byte   BENDIF31 556-557
  byte   BENDIF53 558-559
  byte   RCHDIF31 560-561
  byte   RCHDIF53 562-563
  byte   FNGRDF31 564-565
  byte   FNGRDF53 566-567
  byte   WLK3MO31 568-569
  byte   WLK3MO53 570-571
  byte   ACTLIM31 572-573
  byte   ACTLIM53 574-575
  byte   WRKLIM31 576-577
  byte   WRKLIM53 578-579
  byte   HSELIM31 580-581
  byte   HSELIM53 582-583
  byte   SCHLIM31 584-585
  byte   SCHLIM53 586-587
  byte   UNABLE31 588-589
  byte   UNABLE53 590-591
  byte   SOCLIM31 592-593
  byte   SOCLIM53 594-595
  byte   COGLIM31 596-597
  byte   COGLIM53 598-599
  byte   WRGLAS42 600-601
  byte   SEEDIF42 602-603
  byte   BLIND42 604-605
  byte   READNW42 606-607
  byte   RECPEP42 608-609
  byte   VISION42 610-611
  byte   HEARAD42 612-613
  byte   HEARDI42 614-615
  byte   DEAF42 616-617
  byte   HEARMO42 618-619
  byte   HEARSM42 620-621
  byte   HEARNG42 622-623
  byte   ANYLIM04 624-625
  byte   LSHLTH42 626-627
  byte   NEVILL42 628-629
  byte   SICEAS42 630-631
  byte   HLTHLF42 632-633
  byte   WRHLTH42 634-635
  byte   CHPMED42 636-637
  byte   CHPMHB42 638-639
  byte   CHPMCN42 640-641
  byte   CHSERV42 642-643
  byte   CHSRHB42 644-645
  byte   CHSRCN42 646-647
  byte   CHLIMI42 648-649
  byte   CHLIHB42 650-651
  byte   CHLICO42 652-653
  byte   CHTHER42 654-655
  byte   CHTHHB42 656-657
  byte   CHTHCO42 658-659
  byte   CHCOUN42 660-661
  byte   CHEMPB42 662-663
  byte   CSHCN42 664-665
  byte   MOMPRO42 666-667
  byte   DADPRO42 668-669
  byte   UNHAP42 670-671
  byte   SCHLBH42 672-673
  byte   HAVFUN42 674-675
  byte   ADUPRO42 676-677
  byte   NERVAF42 678-679
  byte   SIBPRO42 680-681
  byte   KIDPRO42 682-683
  byte   SPRPRO42 684-685
  byte   SCHPRO42 686-687
  byte   HOMEBH42 688-689
  byte   TRBLE42 690-691
  byte   CHILCR42 692-693
  byte   CHILWW42 694-695
  byte   CHRTCR42 696-697
  byte   CHRTWW42 698-699
  byte   CHAPPT42 700-701
  byte   CHNDCR42 702-703
  byte   CHNECP42 704-705
  byte   CHLIST42 706-707
  byte   CHEXPL42 708-709
  byte   CHRESP42 710-711
  byte   CHPRTM42 712-713
  byte   CHHECR42 714-715
  byte   CHSPEC42 716-717
  byte   CHPRRE42 718-719
  byte   MESHGT42 720-721
  byte   WHNHGT42 722-723
  byte   MESWGT42 724-725
  byte   WHNWGT42 726-727
  double CHBMIX42 728-732
  byte   MESVIS42 733-734
  byte   MESBPR42 735-736
  byte   WHNBPR42 737-738
  byte   DENTAL42 739-740
  byte   WHNDEN42 741-742
  byte   EATHLT42 743-744
  byte   WHNEAT42 745-746
  byte   PHYSCL42 747-748
  byte   WHNPHY42 749-750
  byte   SAFEST42 751-752
  byte   WHNSAF42 753-754
  byte   BOOST42 755-756
  byte   WHNBST42 757-758
  byte   LAPBLT42 759-760
  byte   WHNLAP42 761-762
  byte   HELMET42 763-764
  byte   WHNHEL42 765-766
  byte   NOSMOK42 767-768
  byte   WHNSMK42 769-770
  byte   TIMALN42 771-772
  byte   DENTCK53 773-774
  byte   CHOLCK53 775-776
  byte   CHECK53 777-778
  byte   FLUSHT53 779-780
  byte   LSTETH53 781-782
  byte   PSA53 783-784
  byte   HYSTER53 785-786
  byte   PAPSMR53 787-788
  byte   BRSTEX53 789-790
  byte   MAMOGR53 791-792
  byte   STOOL53 793-794
  byte   WHENST53 795-796
  byte   BOWEL53 797-798
  byte   WHNBWL53 799-800
  byte   PHYACT53 801-802
  double BMINDX53 803-807
  byte   SEATBE53 808-809
  byte   SRTHRT53 810-811
  byte   THSYMP53 812-813
  byte   DRTHRT53 814-815
  byte   THANTB53 816-817
  byte   THSWAB53 818-819
  byte   THSYMF53 820-821
  byte   THSWBF53 822-823
  byte   THANTF53 824-825
  byte   DIABDX53 826-827
  byte   ASTHDX53 828-829
  byte   ASSTIL53 830-831
  byte   ASATAK53 832-833
  byte   ASACUT53 834-835
  byte   ASMRCN53 836-837
  byte   ASPREV53 838-839
  byte   ASDALY53 840-841
  byte   ASPKFL53 842-843
  byte   ASEVFL53 844-845
  byte   ASWNFL53 846-847
  byte   HIBPDX53 848-849
  byte   BPMLDX53 850-851
  byte   BPCHEK53 852-853
  byte   BPMONT53 854-855
  byte   CHDDX53 856-857
  byte   ANGIDX53 858-859
  byte   MIDX53 860-861
  byte   OHRTDX53 862-863
  byte   STRKDX53 864-865
  byte   EMPHDX53 866-867
  byte   NOFAT53 868-869
  byte   EXRCIS53 870-871
  byte   ASPRIN53 872-873
  byte   NOASPR53 874-875
  byte   STOMCH53 876-877
  byte   JTPAIN53 878-879
  byte   ARTHDX53 880-881
  byte   ARTHTX53 882-883
  byte   SAQELIG 884-884
  int    ADPRX42 885-887
  byte   ADILCR42 888-889
  byte   ADILWW42 890-891
  byte   ADRTCR42 892-893
  byte   ADRTWW42 894-895
  byte   ADAPPT42 896-897
  byte   ADNDCR42 898-899
  byte   ADNECP42 900-901
  byte   ADLIST42 902-903
  byte   ADEXPL42 904-905
  byte   ADRESP42 906-907
  byte   ADPRTM42 908-909
  byte   ADHECR42 910-911
  byte   ADSMOK42 912-913
  byte   ADNSMK42 914-915
  byte   ADDRBP42 916-917
  byte   ADSPEC42 918-919
  byte   ADPRRE42 920-921
  byte   ADGENH42 922-923
  byte   ADDAYA42 924-925
  byte   ADCLIM42 926-927
  byte   ADPALS42 928-929
  byte   ADPWLM42 930-931
  byte   ADMALS42 932-933
  byte   ADMWLM42 934-935
  byte   ADPAIN42 936-937
  byte   ADCAPE42 938-939
  byte   ADNRGY42 940-941
  byte   ADDOWN42 942-943
  byte   ADSOCA42 944-945
  double PCS42 946-950
  double MCS42 951-955
  byte   SFFLAG42 956-957
  byte   ADNERV42 958-959
  byte   ADHOPE42 960-961
  byte   ADREST42 962-963
  byte   ADSAD42 964-965
  byte   ADEFRT42 966-967
  byte   ADWRTH42 968-969
  byte   K6SUM42 970-971
  byte   ADINTR42 972-973
  byte   ADDPRS42 974-975
  double PHQ242 976-980
  byte   ADINSA42 981-982
  byte   ADINSB42 983-984
  byte   ADRISK42 985-986
  byte   ADOVER42 987-988
  byte   ADCMPM42 989-990
  byte   ADCMPD42 991-992
  int    ADCMPY42 993-996
  byte   ADLANG42 997-998
  byte   DSDIA53 999-1000
  byte   DSA1C53 1001-1002
  byte   DSCKFT53 1003-1004
  byte   DSEY0553 1005-1006
  byte   DSEY0453 1007-1008
  byte   DSEY0353 1009-1010
  byte   DSEB0353 1011-1012
  byte   DSEYNV53 1013-1014
  byte   DSKIDN53 1015-1016
  byte   DSEYPR53 1017-1018
  byte   DSDIET53 1019-1020
  byte   DSMED53 1021-1022
  byte   DSINSU53 1023-1024
  byte   DSPRX53 1025-1026
  int    DDNWRK31 1027-1029
  int    DDNWRK42 1030-1032
  int    DDNWRK53 1033-1035
  byte   WKINBD31 1036-1037
  int    WKINBD42 1038-1040
  int    WKINBD53 1041-1043
  int    DDNSCL31 1044-1046
  byte   DDNSCL42 1047-1048
  byte   DDNSCL53 1049-1050
  byte   SCLNBD31 1051-1052
  byte   SCLNBD42 1053-1054
  byte   SCLNBD53 1055-1056
  int    DDBDYS31 1057-1059
  int    DDBDYS42 1060-1062
  int    DDBDYS53 1063-1065
  byte   OTHDYS31 1066-1067
  byte   OTHDYS42 1068-1069
  byte   OTHDYS53 1070-1071
  byte   OTHNDD31 1072-1073
  int    OTHNDD42 1074-1076
  int    OTHNDD53 1077-1079
  byte   ACCELI42 1080-1081
  byte   LANGHM42 1082-1083
  byte   ENGHME42 1084-1085
  byte   ENGSPK42 1086-1087
  byte   HAVEUS42 1088-1089
  byte   YNOUSC42 1090-1091
  byte   NOREAS42 1092-1093
  byte   SELDSI42 1094-1095
  byte   NEWARE42 1096-1097
  byte   DKWHRU42 1098-1099
  byte   USCNOT42 1100-1101
  byte   PERSLA42 1102-1103
  byte   DIFFPL42 1104-1105
  byte   INSRPL42 1106-1107
  byte   MYSELF42 1108-1109
  byte   CARECO42 1110-1111
  byte   OTHINS42 1112-1113
  byte   KNOWDR42 1114-1115
  byte   TRANS42 1116-1117
  byte   CLINIC42 1118-1119
  byte   OTHREA42 1120-1121
  byte   PROVTY42 1122-1123
  byte   FACLPR42 1124-1125
  byte   PLCTYP42 1126-1127
  byte   GOTOUS42 1128-1129
  byte   TMTKUS42 1130-1131
  byte   DFTOUS42 1132-1133
  byte   TYPEPE42 1134-1135
  byte   LOCATN42 1136-1137
  byte   HSPLAP42 1138-1139
  byte   WHITPR42 1140-1141
  byte   BLCKPR42 1142-1143
  byte   ASIANP42 1144-1145
  byte   NATAMP42 1146-1147
  byte   PACISP42 1148-1149
  byte   OTHRCP42 1150-1151
  byte   GENDRP42 1152-1153
  byte   MINORP42 1154-1155
  byte   PREVEN42 1156-1157
  byte   REFFRL42 1158-1159
  byte   ONGONG42 1160-1161
  byte   PHNREG42 1162-1163
  byte   OFFHOU42 1164-1165
  byte   AFTHOU42 1166-1167
  byte   TREATM42 1168-1169
  byte   RESPCT42 1170-1171
  byte   DECIDE42 1172-1173
  byte   EXPLOP42 1174-1175
  byte   LANGPR42 1176-1177
  byte   MDUNAB42 1178-1179
  byte   MDUNRS42 1180-1181
  byte   MDUNPR42 1182-1183
  byte   MDDLAY42 1184-1185
  byte   MDDLRS42 1186-1187
  byte   MDDLPR42 1188-1189
  byte   DNUNAB42 1190-1191
  byte   DNUNRS42 1192-1193
  byte   DNUNPR42 1194-1195
  byte   DNDLAY42 1196-1197
  byte   DNDLRS42 1198-1199
  byte   DNDLPR42 1200-1201
  byte   PMUNAB42 1202-1203
  byte   PMUNRS42 1204-1205
  byte   PMUNPR42 1206-1207
  byte   PMDLAY42 1208-1209
  byte   PMDLRS42 1210-1211
  byte   PMDLPR42 1212-1213
  byte   EMPST31 1214-1215
  byte   EMPST42 1216-1217
  byte   EMPST53 1218-1219
  byte   RNDFLG31 1220-1221
  byte   MORJOB31 1222-1223
  byte   MORJOB42 1224-1225
  byte   MORJOB53 1226-1227
  byte   EVRWRK 1228-1229
  double HRWG31X 1230-1235
  double HRWG42X 1236-1241
  double HRWG53X 1242-1247
  byte   HRWGIM31 1248-1248
  byte   HRWGIM42 1249-1249
  byte   HRWGIM53 1250-1250
  byte   HRHOW31 1251-1252
  byte   HRHOW42 1253-1254
  byte   HRHOW53 1255-1256
  byte   DIFFWG31 1257-1258
  byte   DIFFWG42 1259-1260
  byte   DIFFWG53 1261-1262
  double NHRWG31 1263-1268
  double NHRWG42 1269-1274
  double NHRWG53 1275-1280
  int    HOUR31 1281-1283
  int    HOUR42 1284-1286
  byte   HOUR53 1287-1288
  byte   TEMPJB31 1289-1290
  byte   TEMPJB42 1291-1292
  byte   TEMPJB53 1293-1294
  byte   SSNLJB31 1295-1296
  byte   SSNLJB42 1297-1298
  byte   SSNLJB53 1299-1300
  byte   SELFCM31 1301-1302
  byte   SELFCM42 1303-1304
  byte   SELFCM53 1305-1306
  byte   DISVW31X 1307-1308
  byte   DISVW42X 1309-1310
  byte   DISVW53X 1311-1312
  byte   CHOIC31 1313-1314
  byte   CHOIC42 1315-1316
  byte   CHOIC53 1317-1318
  byte   INDCAT31 1319-1320
  byte   INDCAT42 1321-1322
  byte   INDCAT53 1323-1324
  int    NUMEMP31 1325-1327
  int    NUMEMP42 1328-1330
  int    NUMEMP53 1331-1333
  byte   MORE31 1334-1335
  byte   MORE42 1336-1337
  byte   MORE53 1338-1339
  byte   UNION31 1340-1341
  byte   UNION42 1342-1343
  byte   UNION53 1344-1345
  byte   NWK31 1346-1347
  byte   NWK42 1348-1349
  byte   NWK53 1350-1351
  byte   CHGJ3142 1352-1353
  byte   CHGJ4253 1354-1355
  byte   YCHJ3142 1356-1357
  byte   YCHJ4253 1358-1359
  byte   STJBMM31 1360-1361
  byte   STJBDD31 1362-1363
  int    STJBYY31 1364-1367
  byte   STJBMM42 1368-1369
  byte   STJBDD42 1370-1371
  int    STJBYY42 1372-1375
  byte   STJBMM53 1376-1377
  byte   STJBDD53 1378-1379
  int    STJBYY53 1380-1383
  byte   EVRETIRE 1384-1385
  byte   OCCCAT31 1386-1387
  byte   OCCCAT42 1388-1389
  byte   OCCCAT53 1390-1391
  byte   PAYVAC31 1392-1393
  byte   PAYVAC42 1394-1395
  byte   PAYVAC53 1396-1397
  byte   SICPAY31 1398-1399
  byte   SICPAY42 1400-1401
  byte   SICPAY53 1402-1403
  byte   PAYDR31 1404-1405
  byte   PAYDR42 1406-1407
  byte   PAYDR53 1408-1409
  byte   RETPLN31 1410-1411
  byte   RETPLN42 1412-1413
  byte   RETPLN53 1414-1415
  byte   BSNTY31 1416-1417
  byte   BSNTY42 1418-1419
  byte   BSNTY53 1420-1421
  byte   JOBORG31 1422-1423
  byte   JOBORG42 1424-1425
  byte   JOBORG53 1426-1427
  byte   HELD31X 1428-1429
  byte   HELD42X 1430-1431
  byte   HELD53X 1432-1433
  byte   OFFER31X 1434-1435
  byte   OFFER42X 1436-1437
  byte   OFFER53X 1438-1439
  byte   OFREMP31 1440-1441
  byte   OFREMP42 1442-1443
  byte   OFREMP53 1444-1445
  byte   YNOINS31 1446-1447
  byte   YNOINS42 1448-1449
  byte   YNOINS53 1450-1451
  byte   TRIJA04X 1452-1453
  byte   TRIFE04X 1454-1455
  byte   TRIMA04X 1456-1457
  byte   TRIAP04X 1458-1459
  byte   TRIMY04X 1460-1461
  byte   TRIJU04X 1462-1463
  byte   TRIJL04X 1464-1465
  byte   TRIAU04X 1466-1467
  byte   TRISE04X 1468-1469
  byte   TRIOC04X 1470-1471
  byte   TRINO04X 1472-1473
  byte   TRIDE04X 1474-1475
  byte   MCRJA04 1476-1477
  byte   MCRFE04 1478-1479
  byte   MCRMA04 1480-1481
  byte   MCRAP04 1482-1483
  byte   MCRMY04 1484-1485
  byte   MCRJU04 1486-1487
  byte   MCRJL04 1488-1489
  byte   MCRAU04 1490-1491
  byte   MCRSE04 1492-1493
  byte   MCROC04 1494-1495
  byte   MCRNO04 1496-1497
  byte   MCRDE04 1498-1499
  byte   MCRJA04X 1500-1501
  byte   MCRFE04X 1502-1503
  byte   MCRMA04X 1504-1505
  byte   MCRAP04X 1506-1507
  byte   MCRMY04X 1508-1509
  byte   MCRJU04X 1510-1511
  byte   MCRJL04X 1512-1513
  byte   MCRAU04X 1514-1515
  byte   MCRSE04X 1516-1517
  byte   MCROC04X 1518-1519
  byte   MCRNO04X 1520-1521
  byte   MCRDE04X 1522-1523
  byte   MCDJA04 1524-1525
  byte   MCDFE04 1526-1527
  byte   MCDMA04 1528-1529
  byte   MCDAP04 1530-1531
  byte   MCDMY04 1532-1533
  byte   MCDJU04 1534-1535
  byte   MCDJL04 1536-1537
  byte   MCDAU04 1538-1539
  byte   MCDSE04 1540-1541
  byte   MCDOC04 1542-1543
  byte   MCDNO04 1544-1545
  byte   MCDDE04 1546-1547
  byte   MCDJA04X 1548-1549
  byte   MCDFE04X 1550-1551
  byte   MCDMA04X 1552-1553
  byte   MCDAP04X 1554-1555
  byte   MCDMY04X 1556-1557
  byte   MCDJU04X 1558-1559
  byte   MCDJL04X 1560-1561
  byte   MCDAU04X 1562-1563
  byte   MCDSE04X 1564-1565
  byte   MCDOC04X 1566-1567
  byte   MCDNO04X 1568-1569
  byte   MCDDE04X 1570-1571
  byte   OPAJA04 1572-1573
  byte   OPAFE04 1574-1575
  byte   OPAMA04 1576-1577
  byte   OPAAP04 1578-1579
  byte   OPAMY04 1580-1581
  byte   OPAJU04 1582-1583
  byte   OPAJL04 1584-1585
  byte   OPAAU04 1586-1587
  byte   OPASE04 1588-1589
  byte   OPAOC04 1590-1591
  byte   OPANO04 1592-1593
  byte   OPADE04 1594-1595
  byte   OPBJA04 1596-1597
  byte   OPBFE04 1598-1599
  byte   OPBMA04 1600-1601
  byte   OPBAP04 1602-1603
  byte   OPBMY04 1604-1605
  byte   OPBJU04 1606-1607
  byte   OPBJL04 1608-1609
  byte   OPBAU04 1610-1611
  byte   OPBSE04 1612-1613
  byte   OPBOC04 1614-1615
  byte   OPBNO04 1616-1617
  byte   OPBDE04 1618-1619
  byte   STAJA04 1620-1621
  byte   STAFE04 1622-1623
  byte   STAMA04 1624-1625
  byte   STAAP04 1626-1627
  byte   STAMY04 1628-1629
  byte   STAJU04 1630-1631
  byte   STAJL04 1632-1633
  byte   STAAU04 1634-1635
  byte   STASE04 1636-1637
  byte   STAOC04 1638-1639
  byte   STANO04 1640-1641
  byte   STADE04 1642-1643
  byte   PUBJA04X 1644-1645
  byte   PUBFE04X 1646-1647
  byte   PUBMA04X 1648-1649
  byte   PUBAP04X 1650-1651
  byte   PUBMY04X 1652-1653
  byte   PUBJU04X 1654-1655
  byte   PUBJL04X 1656-1657
  byte   PUBAU04X 1658-1659
  byte   PUBSE04X 1660-1661
  byte   PUBOC04X 1662-1663
  byte   PUBNO04X 1664-1665
  byte   PUBDE04X 1666-1667
  byte   PEGJA04 1668-1669
  byte   PEGFE04 1670-1671
  byte   PEGMA04 1672-1673
  byte   PEGAP04 1674-1675
  byte   PEGMY04 1676-1677
  byte   PEGJU04 1678-1679
  byte   PEGJL04 1680-1681
  byte   PEGAU04 1682-1683
  byte   PEGSE04 1684-1685
  byte   PEGOC04 1686-1687
  byte   PEGNO04 1688-1689
  byte   PEGDE04 1690-1691
  byte   PDKJA04 1692-1693
  byte   PDKFE04 1694-1695
  byte   PDKMA04 1696-1697
  byte   PDKAP04 1698-1699
  byte   PDKMY04 1700-1701
  byte   PDKJU04 1702-1703
  byte   PDKJL04 1704-1705
  byte   PDKAU04 1706-1707
  byte   PDKSE04 1708-1709
  byte   PDKOC04 1710-1711
  byte   PDKNO04 1712-1713
  byte   PDKDE04 1714-1715
  byte   PNGJA04 1716-1717
  byte   PNGFE04 1718-1719
  byte   PNGMA04 1720-1721
  byte   PNGAP04 1722-1723
  byte   PNGMY04 1724-1725
  byte   PNGJU04 1726-1727
  byte   PNGJL04 1728-1729
  byte   PNGAU04 1730-1731
  byte   PNGSE04 1732-1733
  byte   PNGOC04 1734-1735
  byte   PNGNO04 1736-1737
  byte   PNGDE04 1738-1739
  byte   POGJA04 1740-1741
  byte   POGFE04 1742-1743
  byte   POGMA04 1744-1745
  byte   POGAP04 1746-1747
  byte   POGMY04 1748-1749
  byte   POGJU04 1750-1751
  byte   POGJL04 1752-1753
  byte   POGAU04 1754-1755
  byte   POGSE04 1756-1757
  byte   POGOC04 1758-1759
  byte   POGNO04 1760-1761
  byte   POGDE04 1762-1763
  byte   PRSJA04 1764-1765
  byte   PRSFE04 1766-1767
  byte   PRSMA04 1768-1769
  byte   PRSAP04 1770-1771
  byte   PRSMY04 1772-1773
  byte   PRSJU04 1774-1775
  byte   PRSJL04 1776-1777
  byte   PRSAU04 1778-1779
  byte   PRSSE04 1780-1781
  byte   PRSOC04 1782-1783
  byte   PRSNO04 1784-1785
  byte   PRSDE04 1786-1787
  byte   POUJA04 1788-1789
  byte   POUFE04 1790-1791
  byte   POUMA04 1792-1793
  byte   POUAP04 1794-1795
  byte   POUMY04 1796-1797
  byte   POUJU04 1798-1799
  byte   POUJL04 1800-1801
  byte   POUAU04 1802-1803
  byte   POUSE04 1804-1805
  byte   POUOC04 1806-1807
  byte   POUNO04 1808-1809
  byte   POUDE04 1810-1811
  byte   PRIJA04 1812-1813
  byte   PRIFE04 1814-1815
  byte   PRIMA04 1816-1817
  byte   PRIAP04 1818-1819
  byte   PRIMY04 1820-1821
  byte   PRIJU04 1822-1823
  byte   PRIJL04 1824-1825
  byte   PRIAU04 1826-1827
  byte   PRISE04 1828-1829
  byte   PRIOC04 1830-1831
  byte   PRINO04 1832-1833
  byte   PRIDE04 1834-1835
  byte   HPEJA04 1836-1837
  byte   HPEFE04 1838-1839
  byte   HPEMA04 1840-1841
  byte   HPEAP04 1842-1843
  byte   HPEMY04 1844-1845
  byte   HPEJU04 1846-1847
  byte   HPEJL04 1848-1849
  byte   HPEAU04 1850-1851
  byte   HPESE04 1852-1853
  byte   HPEOC04 1854-1855
  byte   HPENO04 1856-1857
  byte   HPEDE04 1858-1859
  byte   HPDJA04 1860-1861
  byte   HPDFE04 1862-1863
  byte   HPDMA04 1864-1865
  byte   HPDAP04 1866-1867
  byte   HPDMY04 1868-1869
  byte   HPDJU04 1870-1871
  byte   HPDJL04 1872-1873
  byte   HPDAU04 1874-1875
  byte   HPDSE04 1876-1877
  byte   HPDOC04 1878-1879
  byte   HPDNO04 1880-1881
  byte   HPDDE04 1882-1883
  byte   HPNJA04 1884-1885
  byte   HPNFE04 1886-1887
  byte   HPNMA04 1888-1889
  byte   HPNAP04 1890-1891
  byte   HPNMY04 1892-1893
  byte   HPNJU04 1894-1895
  byte   HPNJL04 1896-1897
  byte   HPNAU04 1898-1899
  byte   HPNSE04 1900-1901
  byte   HPNOC04 1902-1903
  byte   HPNNO04 1904-1905
  byte   HPNDE04 1906-1907
  byte   HPOJA04 1908-1909
  byte   HPOFE04 1910-1911
  byte   HPOMA04 1912-1913
  byte   HPOAP04 1914-1915
  byte   HPOMY04 1916-1917
  byte   HPOJU04 1918-1919
  byte   HPOJL04 1920-1921
  byte   HPOAU04 1922-1923
  byte   HPOSE04 1924-1925
  byte   HPOOC04 1926-1927
  byte   HPONO04 1928-1929
  byte   HPODE04 1930-1931
  byte   HPSJA04 1932-1933
  byte   HPSFE04 1934-1935
  byte   HPSMA04 1936-1937
  byte   HPSAP04 1938-1939
  byte   HPSMY04 1940-1941
  byte   HPSJU04 1942-1943
  byte   HPSJL04 1944-1945
  byte   HPSAU04 1946-1947
  byte   HPSSE04 1948-1949
  byte   HPSOC04 1950-1951
  byte   HPSNO04 1952-1953
  byte   HPSDE04 1954-1955
  byte   HPRJA04 1956-1957
  byte   HPRFE04 1958-1959
  byte   HPRMA04 1960-1961
  byte   HPRAP04 1962-1963
  byte   HPRMY04 1964-1965
  byte   HPRJU04 1966-1967
  byte   HPRJL04 1968-1969
  byte   HPRAU04 1970-1971
  byte   HPRSE04 1972-1973
  byte   HPROC04 1974-1975
  byte   HPRNO04 1976-1977
  byte   HPRDE04 1978-1979
  byte   INSJA04X 1980-1981
  byte   INSFE04X 1982-1983
  byte   INSMA04X 1984-1985
  byte   INSAP04X 1986-1987
  byte   INSMY04X 1988-1989
  byte   INSJU04X 1990-1991
  byte   INSJL04X 1992-1993
  byte   INSAU04X 1994-1995
  byte   INSSE04X 1996-1997
  byte   INSOC04X 1998-1999
  byte   INSNO04X 2000-2001
  byte   INSDE04X 2002-2003
  byte   PRVEV04 2004-2004
  byte   TRIEV04 2005-2005
  byte   MCREV04 2006-2006
  byte   MCDEV04 2007-2007
  byte   OPAEV04 2008-2008
  byte   OPBEV04 2009-2009
  byte   UNINS04 2010-2010
  byte   INSCOV04 2011-2011
  byte   TRIST31X 2012-2013
  byte   TRIST42X 2014-2015
  byte   TRIST04X 2016-2017
  byte   TRIPR31X 2018-2019
  byte   TRIPR42X 2020-2021
  byte   TRIPR04X 2022-2023
  byte   TRIEX31X 2024-2025
  byte   TRIEX42X 2026-2027
  byte   TRIEX04X 2028-2029
  byte   TRILI31X 2030-2031
  byte   TRILI42X 2032-2033
  byte   TRILI04X 2034-2035
  byte   MCDHMO31 2036-2037
  byte   MCDHMO42 2038-2039
  byte   MCDHMO04 2040-2041
  byte   MCDMC31 2042-2043
  byte   MCDMC42 2044-2045
  byte   MCDMC04 2046-2047
  byte   PRVHMO31 2048-2049
  byte   PRVHMO42 2050-2051
  byte   PRVHMO04 2052-2053
  byte   PRVMNC31 2054-2055
  byte   PRVMNC42 2056-2057
  byte   PRVMNC04 2058-2059
  byte   PRVDRL31 2060-2061
  byte   PRVDRL42 2062-2063
  byte   PRVDRL04 2064-2065
  byte   PHMONP31 2066-2067
  byte   PHMONP42 2068-2069
  byte   PHMONP04 2070-2071
  byte   PMNCNP31 2072-2073
  byte   PMNCNP42 2074-2075
  byte   PMNCNP04 2076-2077
  byte   PRDRNP31 2078-2079
  byte   PRDRNP42 2080-2081
  byte   PRDRNP04 2082-2083
  byte   PREVCOVR 2084-2085
  byte   COVRMM 2086-2087
  int    COVRYY 2088-2091
  byte   WASESTB 2092-2093
  byte   WASMCARE 2094-2095
  byte   WASMCAID 2096-2097
  byte   WASCHAMP 2098-2099
  byte   WASVA 2100-2101
  byte   WASPRIV 2102-2103
  byte   WASOTGOV 2104-2105
  byte   WASAFDC 2106-2107
  byte   WASSSI 2108-2109
  byte   WASSTAT1 2110-2111
  byte   WASSTAT2 2112-2113
  byte   WASSTAT3 2114-2115
  byte   WASSTAT4 2116-2117
  byte   WASOTHER 2118-2119
  byte   NOINSBEF 2120-2121
  byte   NOINSTM 2122-2123
  byte   NOINUNIT 2124-2125
  byte   MORECOVR 2126-2127
  byte   INSENDMM 2128-2129
  int    INSENDYY 2130-2133
  byte   TRICR31X 2134-2135
  byte   TRICR42X 2136-2137
  byte   TRICR53X 2138-2139
  byte   TRICR04X 2140-2141
  byte   TRIAT31X 2142-2143
  byte   TRIAT42X 2144-2145
  byte   TRIAT53X 2146-2147
  byte   TRIAT04X 2148-2149
  byte   MCAID31 2150-2151
  byte   MCAID42 2152-2153
  byte   MCAID53 2154-2155
  byte   MCAID04 2156-2157
  byte   MCAID31X 2158-2159
  byte   MCAID42X 2160-2161
  byte   MCAID53X 2162-2163
  byte   MCAID04X 2164-2165
  byte   MCARE31 2166-2167
  byte   MCARE42 2168-2169
  byte   MCARE53 2170-2171
  byte   MCARE04 2172-2173
  byte   MCARE31X 2174-2175
  byte   MCARE42X 2176-2177
  byte   MCARE53X 2178-2179
  byte   MCARE04X 2180-2181
  byte   MCDAT31X 2182-2183
  byte   MCDAT42X 2184-2185
  byte   MCDAT53X 2186-2187
  byte   MCDAT04X 2188-2189
  byte   OTPAAT31 2190-2191
  byte   OTPAAT42 2192-2193
  byte   OTPAAT53 2194-2195
  byte   OTPAAT04 2196-2197
  byte   OTPBAT31 2198-2199
  byte   OTPBAT42 2200-2201
  byte   OTPBAT53 2202-2203
  byte   OTPBAT04 2204-2205
  byte   OTPUBA31 2206-2207
  byte   OTPUBA42 2208-2209
  byte   OTPUBA53 2210-2211
  byte   OTPUBA04 2212-2213
  byte   OTPUBB31 2214-2215
  byte   OTPUBB42 2216-2217
  byte   OTPUBB53 2218-2219
  byte   OTPUBB04 2220-2221
  byte   PRIDK31 2222-2223
  byte   PRIDK42 2224-2225
  byte   PRIDK53 2226-2227
  byte   PRIDK04 2228-2229
  byte   PRIEU31 2230-2231
  byte   PRIEU42 2232-2233
  byte   PRIEU53 2234-2235
  byte   PRIEU04 2236-2237
  byte   PRING31 2238-2239
  byte   PRING42 2240-2241
  byte   PRING53 2242-2243
  byte   PRING04 2244-2245
  byte   PRIOG31 2246-2247
  byte   PRIOG42 2248-2249
  byte   PRIOG53 2250-2251
  byte   PRIOG04 2252-2253
  byte   PRIS31 2254-2255
  byte   PRIS42 2256-2257
  byte   PRIS53 2258-2259
  byte   PRIS04 2260-2261
  byte   PRIV31 2262-2263
  byte   PRIV42 2264-2265
  byte   PRIV53 2266-2267
  byte   PRIV04 2268-2269
  byte   PRIVAT31 2270-2271
  byte   PRIVAT42 2272-2273
  byte   PRIVAT53 2274-2275
  byte   PRIVAT04 2276-2277
  byte   PROUT31 2278-2279
  byte   PROUT42 2280-2281
  byte   PROUT53 2282-2283
  byte   PROUT04 2284-2285
  byte   PUB31X 2286-2287
  byte   PUB42X 2288-2289
  byte   PUB53X 2290-2291
  byte   PUB04X 2292-2293
  byte   PUBAT31X 2294-2295
  byte   PUBAT42X 2296-2297
  byte   PUBAT53X 2298-2299
  byte   PUBAT04X 2300-2301
  byte   INS31X 2302-2303
  byte   INS42X 2304-2305
  byte   INS53X 2306-2307
  byte   INS04X 2308-2309
  byte   INSAT31X 2310-2311
  byte   INSAT42X 2312-2313
  byte   INSAT53X 2314-2315
  byte   INSAT04X 2316-2317
  byte   STAPR31 2318-2319
  byte   STAPR42 2320-2321
  byte   STAPR53 2322-2323
  byte   STAPR04 2324-2325
  byte   STPRAT31 2326-2327
  byte   STPRAT42 2328-2329
  byte   STPRAT53 2330-2331
  byte   STPRAT04 2332-2333
  byte   EVRUNINS 2334-2334
  byte   EVRUNAT 2335-2335
  byte   DENTIN31 2336-2337
  byte   DENTIN42 2338-2339
  byte   DENTIN53 2340-2341
  byte   PMEDIN31 2342-2343
  byte   PMEDIN42 2344-2345
  byte   PMEDIN53 2346-2347
  byte   GDCPBM42 2348-2349
  byte   APRTRM42 2350-2351
  byte   APRDLM42 2352-2353
  byte   LKINFM42 2354-2355
  byte   PBINFM42 2356-2357
  byte   CSTSVM42 2358-2359
  byte   PBSVCM42 2360-2361
  byte   PPRWKM42 2362-2363
  byte   PBPWKM42 2364-2365
  byte   RTPLNM42 2366-2367
  byte   GDCPBT42 2368-2369
  byte   APRTRT42 2370-2371
  byte   APRDLT42 2372-2373
  byte   LKINFT42 2374-2375
  byte   PBINFT42 2376-2377
  byte   CSTSVT42 2378-2379
  byte   PBSVCT42 2380-2381
  byte   PPRWKT42 2382-2383
  byte   PBPWKT42 2384-2385
  byte   RTPLNT42 2386-2387
  long   TOTTCH04 2388-2394
  long   TOTEXP04 2395-2400
  long   TOTSLF04 2401-2405
  long   TOTMCR04 2406-2411
  long   TOTMCD04 2412-2417
  long   TOTPRV04 2418-2423
  long   TOTVA04 2424-2428
  long   TOTTRI04 2429-2433
  long   TOTOFD04 2434-2438
  long   TOTSTL04 2439-2443
  long   TOTWCP04 2444-2448
  long   TOTOPR04 2449-2453
  long   TOTOPU04 2454-2458
  long   TOTOSR04 2459-2463
  int    OBTOTV04 2464-2466
  long   OBVTCH04 2467-2472
  long   OBVEXP04 2473-2478
  long   OBVSLF04 2479-2483
  long   OBVMCR04 2484-2488
  long   OBVMCD04 2489-2493
  long   OBVPRV04 2494-2498
  long   OBVVA04 2499-2503
  long   OBVTRI04 2504-2508
  int    OBVOFD04 2509-2512
  long   OBVSTL04 2513-2517
  long   OBVWCP04 2518-2522
  long   OBVOPR04 2523-2527
  int    OBVOPU04 2528-2531
  long   OBVOSR04 2532-2536
  int    OBDRV04 2537-2539
  long   OBDTCH04 2540-2545
  long   OBDEXP04 2546-2550
  long   OBDSLF04 2551-2555
  long   OBDMCR04 2556-2560
  long   OBDMCD04 2561-2565
  long   OBDPRV04 2566-2570
  long   OBDVA04 2571-2575
  int    OBDTRI04 2576-2579
  int    OBDOFD04 2580-2583
  long   OBDSTL04 2584-2588
  long   OBDWCP04 2589-2593
  long   OBDOPR04 2594-2598
  int    OBDOPU04 2599-2602
  long   OBDOSR04 2603-2607
  int    OBOTHV04 2608-2610
  long   OBOTCH04 2611-2616
  long   OBOEXP04 2617-2622
  long   OBOSLF04 2623-2627
  long   OBOMCR04 2628-2632
  long   OBOMCD04 2633-2637
  long   OBOPRV04 2638-2642
  long   OBOVA04 2643-2647
  int    OBOTRI04 2648-2651
  int    OBOOFD04 2652-2655
  long   OBOSTL04 2656-2660
  long   OBOWCP04 2661-2665
  long   OBOOPR04 2666-2670
  int    OBOOPU04 2671-2674
  long   OBOOSR04 2675-2679
  int    OBCHIR04 2680-2682
  long   OBCTCH04 2683-2687
  int    OBCEXP04 2688-2691
  int    OBCSLF04 2692-2695
  int    OBCMCR04 2696-2699
  int    OBCMCD04 2700-2703
  int    OBCPRV04 2704-2707
  int    OBCVA04 2708-2710
  byte   OBCTRI04 2711-2712
  int    OBCOFD04 2713-2715
  int    OBCSTL04 2716-2718
  int    OBCWCP04 2719-2722
  int    OBCOPR04 2723-2726
  byte   OBCOPU04 2727-2727
  int    OBCOSR04 2728-2731
  int    OBNURS04 2732-2734
  long   OBNTCH04 2735-2740
  long   OBNEXP04 2741-2745
  int    OBNSLF04 2746-2749
  long   OBNMCR04 2750-2754
  long   OBNMCD04 2755-2759
  long   OBNPRV04 2760-2764
  int    OBNVA04 2765-2768
  int    OBNTRI04 2769-2772
  int    OBNOFD04 2773-2776
  int    OBNSTL04 2777-2779
  int    OBNWCP04 2780-2783
  long   OBNOPR04 2784-2788
  int    OBNOPU04 2789-2791
  int    OBNOSR04 2792-2795
  byte   OBOPTO04 2796-2797
  int    OBETCH04 2798-2801
  int    OBEEXP04 2802-2805
  int    OBESLF04 2806-2809
  int    OBEMCR04 2810-2813
  int    OBEMCD04 2814-2816
  int    OBEPRV04 2817-2820
  int    OBEVA04 2821-2823
  int    OBETRI04 2824-2826
  int    OBEOFD04 2827-2829
  int    OBESTL04 2830-2832
  int    OBEWCP04 2833-2835
  int    OBEOPR04 2836-2838
  int    OBEOPU04 2839-2841
  int    OBEOSR04 2842-2844
  byte   OBASST04 2845-2846
  long   OBATCH04 2847-2851
  int    OBAEXP04 2852-2855
  int    OBASLF04 2856-2859
  int    OBAMCR04 2860-2863
  int    OBAMCD04 2864-2867
  int    OBAPRV04 2868-2871
  int    OBAVA04 2872-2875
  int    OBATRI04 2876-2879
  int    OBAOFD04 2880-2883
  int    OBASTL04 2884-2886
  int    OBAWCP04 2887-2890
  int    OBAOPR04 2891-2893
  int    OBAOPU04 2894-2897
  int    OBAOSR04 2898-2900
  int    OBTHER04 2901-2903
  long   OBTTCH04 2904-2908
  long   OBTEXP04 2909-2913
  int    OBTSLF04 2914-2917
  int    OBTMCR04 2918-2921
  int    OBTMCD04 2922-2925
  long   OBTPRV04 2926-2930
  int    OBTVA04 2931-2934
  int    OBTTRI04 2935-2938
  int    OBTOFD04 2939-2941
  int    OBTSTL04 2942-2945
  int    OBTWCP04 2946-2949
  int    OBTOPR04 2950-2953
  int    OBTOPU04 2954-2956
  int    OBTOSR04 2957-2960
  int    OPTOTV04 2961-2963
  long   OPFTCH04 2964-2969
  long   OPFEXP04 2970-2974
  long   OPFSLF04 2975-2979
  long   OPFMCR04 2980-2984
  long   OPFMCD04 2985-2989
  long   OPFPRV04 2990-2994
  long   OPFVA04 2995-2999
  int    OPFTRI04 3000-3003
  long   OPFOFD04 3004-3008
  int    OPFSTL04 3009-3012
  long   OPFWCP04 3013-3017
  long   OPFOPR04 3018-3022
  int    OPFOPU04 3023-3025
  int    OPFOSR04 3026-3029
  long   OPDEXP04 3030-3034
  long   OPDTCH04 3035-3039
  int    OPDSLF04 3040-3043
  int    OPDMCR04 3044-3047
  int    OPDMCD04 3048-3051
  long   OPDPRV04 3052-3056
  int    OPDVA04 3057-3059
  int    OPDTRI04 3060-3063
  int    OPDOFD04 3064-3067
  int    OPDSTL04 3068-3070
  int    OPDWCP04 3071-3074
  int    OPDOPR04 3075-3078
  int    OPDOPU04 3079-3081
  int    OPDOSR04 3082-3084
  int    OPDRV04 3085-3087
  long   OPVTCH04 3088-3093
  long   OPVEXP04 3094-3098
  long   OPVSLF04 3099-3103
  long   OPVMCR04 3104-3108
  long   OPVMCD04 3109-3113
  long   OPVPRV04 3114-3118
  long   OPVVA04 3119-3123
  int    OPVTRI04 3124-3127
  long   OPVOFD04 3128-3132
  int    OPVSTL04 3133-3136
  int    OPVWCP04 3137-3140
  long   OPVOPR04 3141-3145
  int    OPVOPU04 3146-3148
  int    OPVOSR04 3149-3152
  long   OPSEXP04 3153-3157
  long   OPSTCH04 3158-3162
  int    OPSSLF04 3163-3166
  int    OPSMCR04 3167-3170
  int    OPSMCD04 3171-3174
  long   OPSPRV04 3175-3179
  int    OPSVA04 3180-3182
  int    OPSTRI04 3183-3186
  int    OPSOFD04 3187-3190
  int    OPSSTL04 3191-3193
  int    OPSWCP04 3194-3197
  int    OPSOPR04 3198-3201
  int    OPSOPU04 3202-3204
  int    OPSOSR04 3205-3207
  int    OPOTHV04 3208-3210
  long   OPOTCH04 3211-3216
  long   OPOEXP04 3217-3221
  int    OPOSLF04 3222-3225
  long   OPOMCR04 3226-3230
  long   OPOMCD04 3231-3235
  long   OPOPRV04 3236-3240
  long   OPOVA04 3241-3245
  int    OPOTRI04 3246-3249
  int    OPOOFD04 3250-3253
  int    OPOSTL04 3254-3257
  long   OPOWCP04 3258-3262
  long   OPOOPR04 3263-3267
  int    OPOOPU04 3268-3270
  int    OPOOSR04 3271-3274
  long   OPPEXP04 3275-3279
  long   OPPTCH04 3280-3284
  int    OPPSLF04 3285-3287
  int    OPPMCR04 3288-3291
  int    OPPMCD04 3292-3295
  long   OPPPRV04 3296-3300
  int    OPPVA04 3301-3303
  byte   OPPTRI04 3304-3305
  int    OPPOFD04 3306-3308
  byte   OPPSTL04 3309-3310
  int    OPPWCP04 3311-3314
  int    OPPOPR04 3315-3317
  int    OPPOPU04 3318-3320
  byte   OPPOSR04 3321-3322
  int    AMCHIR04 3323-3325
  long   AMCTCH04 3326-3330
  int    AMCEXP04 3331-3334
  int    AMCSLF04 3335-3338
  int    AMCMCR04 3339-3342
  int    AMCMCD04 3343-3346
  int    AMCPRV04 3347-3350
  int    AMCVA04 3351-3353
  byte   AMCTRI04 3354-3355
  int    AMCOFD04 3356-3358
  int    AMCSTL04 3359-3361
  int    AMCWCP04 3362-3365
  int    AMCOPR04 3366-3369
  byte   AMCOPU04 3370-3370
  int    AMCOSR04 3371-3374
  int    AMNURS04 3375-3377
  long   AMNTCH04 3378-3383
  long   AMNEXP04 3384-3388
  int    AMNSLF04 3389-3392
  long   AMNMCR04 3393-3397
  long   AMNMCD04 3398-3402
  long   AMNPRV04 3403-3407
  int    AMNVA04 3408-3411
  int    AMNTRI04 3412-3415
  int    AMNOFD04 3416-3419
  int    AMNSTL04 3420-3422
  int    AMNWCP04 3423-3426
  long   AMNOPR04 3427-3431
  int    AMNOPU04 3432-3434
  int    AMNOSR04 3435-3438
  byte   AMOPTO04 3439-3440
  int    AMETCH04 3441-3444
  int    AMEEXP04 3445-3448
  int    AMESLF04 3449-3452
  int    AMEMCR04 3453-3456
  int    AMEMCD04 3457-3459
  int    AMEPRV04 3460-3463
  int    AMEVA04 3464-3466
  int    AMETRI04 3467-3469
  int    AMEOFD04 3470-3472
  int    AMESTL04 3473-3475
  int    AMEWCP04 3476-3478
  int    AMEOPR04 3479-3481
  int    AMEOPU04 3482-3484
  int    AMEOSR04 3485-3487
  byte   AMASST04 3488-3489
  long   AMATCH04 3490-3494
  int    AMAEXP04 3495-3498
  int    AMASLF04 3499-3502
  int    AMAMCR04 3503-3506
  int    AMAMCD04 3507-3510
  int    AMAPRV04 3511-3514
  int    AMAVA04 3515-3518
  int    AMATRI04 3519-3522
  int    AMAOFD04 3523-3526
  int    AMASTL04 3527-3529
  int    AMAWCP04 3530-3533
  int    AMAOPR04 3534-3537
  int    AMAOPU04 3538-3541
  int    AMAOSR04 3542-3544
  int    AMTHER04 3545-3547
  long   AMTTCH04 3548-3552
  long   AMTEXP04 3553-3557
  int    AMTSLF04 3558-3561
  int    AMTMCR04 3562-3565
  int    AMTMCD04 3566-3569
  long   AMTPRV04 3570-3574
  long   AMTVA04 3575-3579
  int    AMTTRI04 3580-3583
  int    AMTOFD04 3584-3586
  int    AMTSTL04 3587-3590
  long   AMTWCP04 3591-3595
  int    AMTOPR04 3596-3599
  int    AMTOPU04 3600-3602
  int    AMTOSR04 3603-3606
  byte   AMTOTC04 3607-3608
  byte   AMDRC04 3609-3610
  byte   ERTOT04 3611-3612
  long   ERFTCH04 3613-3617
  long   ERFEXP04 3618-3622
  long   ERFSLF04 3623-3627
  long   ERFMCR04 3628-3632
  long   ERFMCD04 3633-3637
  long   ERFPRV04 3638-3642
  int    ERFVA04 3643-3646
  int    ERFTRI04 3647-3650
  int    ERFOFD04 3651-3654
  int    ERFSTL04 3655-3658
  long   ERFWCP04 3659-3663
  long   ERFOPR04 3664-3668
  long   ERFOPU04 3669-3673
  long   ERFOSR04 3674-3678
  int    ERDEXP04 3679-3682
  int    ERDTCH04 3683-3686
  int    ERDSLF04 3687-3690
  int    ERDMCR04 3691-3694
  int    ERDMCD04 3695-3698
  int    ERDPRV04 3699-3702
  int    ERDVA04 3703-3705
  int    ERDTRI04 3706-3708
  byte   ERDOFD04 3709-3709
  int    ERDSTL04 3710-3712
  int    ERDWCP04 3713-3716
  int    ERDOPR04 3717-3720
  int    ERDOPU04 3721-3723
  int    ERDOSR04 3724-3726
  byte   IPZERO04 3727-3727
  long   ZIFTCH04 3728-3732
  long   ZIFEXP04 3733-3737
  int    ZIFSLF04 3738-3741
  long   ZIFMCR04 3742-3746
  int    ZIFMCD04 3747-3750
  long   ZIFPRV04 3751-3755
  int    ZIFVA04 3756-3758
  long   ZIFTRI04 3759-3763
  byte   ZIFOFD04 3764-3764
  byte   ZIFSTL04 3765-3765
  int    ZIFWCP04 3766-3769
  int    ZIFOPR04 3770-3773
  byte   ZIFOPU04 3774-3774
  int    ZIFOSR04 3775-3777
  int    ZIDEXP04 3778-3781
  long   ZIDTCH04 3782-3786
  int    ZIDSLF04 3787-3789
  int    ZIDMCR04 3790-3793
  int    ZIDMCD04 3794-3797
  int    ZIDPRV04 3798-3801
  byte   ZIDVA04 3802-3802
  int    ZIDTRI04 3803-3805
  byte   ZIDOFD04 3806-3806
  byte   ZIDSTL04 3807-3807
  byte   ZIDWCP04 3808-3808
  int    ZIDOPR04 3809-3812
  byte   ZIDOPU04 3813-3813
  byte   ZIDOSR04 3814-3814
  byte   IPDIS04 3815-3815
  long   IPFEXP04 3816-3821
  long   IPFTCH04 3822-3828
  long   IPFSLF04 3829-3833
  long   IPFMCR04 3834-3839
  long   IPFMCD04 3840-3845
  long   IPFPRV04 3846-3851
  long   IPFVA04 3852-3856
  long   IPFTRI04 3857-3861
  long   IPFOFD04 3862-3866
  long   IPFSTL04 3867-3871
  long   IPFWCP04 3872-3876
  long   IPFOPR04 3877-3881
  long   IPFOPU04 3882-3886
  long   IPFOSR04 3887-3891
  long   IPDEXP04 3892-3896
  long   IPDTCH04 3897-3901
  long   IPDSLF04 3902-3906
  long   IPDMCR04 3907-3911
  long   IPDMCD04 3912-3916
  long   IPDPRV04 3917-3921
  long   IPDVA04 3922-3926
  int    IPDTRI04 3927-3930
  int    IPDOFD04 3931-3933
  int    IPDSTL04 3934-3937
  int    IPDWCP04 3938-3941
  int    IPDOPR04 3942-3945
  int    IPDOPU04 3946-3949
  int    IPDOSR04 3950-3952
  int    IPNGTD04 3953-3955
  byte   DVTOT04 3956-3957
  long   DVTTCH04 3958-3962
  long   DVTEXP04 3963-3967
  long   DVTSLF04 3968-3972
  int    DVTMCR04 3973-3976
  long   DVTMCD04 3977-3981
  long   DVTPRV04 3982-3986
  int    DVTVA04 3987-3990
  int    DVTTRI04 3991-3994
  int    DVTOFD04 3995-3998
  int    DVTSTL04 3999-4002
  int    DVTWCP04 4003-4006
  int    DVTOPR04 4007-4010
  int    DVTOPU04 4011-4014
  int    DVTOSR04 4015-4018
  byte   DVGEN04 4019-4020
  long   DVGTCH04 4021-4025
  long   DVGEXP04 4026-4030
  int    DVGSLF04 4031-4034
  int    DVGMCR04 4035-4038
  int    DVGMCD04 4039-4042
  long   DVGPRV04 4043-4047
  int    DVGVA04 4048-4051
  int    DVGTRI04 4052-4055
  int    DVGOFD04 4056-4058
  int    DVGSTL04 4059-4062
  int    DVGWCP04 4063-4065
  int    DVGOPR04 4066-4069
  int    DVGOPU04 4070-4072
  int    DVGOSR04 4073-4076
  byte   DVORTH04 4077-4078
  long   DVOTCH04 4079-4083
  long   DVOEXP04 4084-4088
  long   DVOSLF04 4089-4093
  byte   DVOMCR04 4094-4094
  long   DVOMCD04 4095-4099
  long   DVOPRV04 4100-4104
  byte   DVOVA04 4105-4105
  int    DVOTRI04 4106-4108
  byte   DVOOFD04 4109-4109
  int    DVOSTL04 4110-4113
  int    DVOWCP04 4114-4117
  int    DVOOPR04 4118-4121
  int    DVOOPU04 4122-4124
  int    DVOOSR04 4125-4128
  int    HHTOTD04 4129-4131
  int    HHAGD04 4132-4134
  long   HHATCH04 4135-4140
  long   HHAEXP04 4141-4146
  int    HHASLF04 4147-4150
  long   HHAMCR04 4151-4155
  long   HHAMCD04 4156-4161
  long   HHAPRV04 4162-4166
  long   HHAVA04 4167-4171
  int    HHATRI04 4172-4174
  int    HHAOFD04 4175-4178
  long   HHASTL04 4179-4183
  byte   HHAWCP04 4184-4184
  int    HHAOPR04 4185-4188
  int    HHAOPU04 4189-4192
  byte   HHAOSR04 4193-4193
  int    HHINDD04 4194-4196
  long   HHNTCH04 4197-4201
  long   HHNEXP04 4202-4206
  long   HHNSLF04 4207-4211
  int    HHNMCR04 4212-4214
  long   HHNMCD04 4215-4219
  int    HHNPRV04 4220-4223
  byte   HHNVA04 4224-4225
  byte   HHNTRI04 4226-4226
  byte   HHNOFD04 4227-4227
  int    HHNSTL04 4228-4231
  byte   HHNWCP04 4232-4232
  byte   HHNOPR04 4233-4233
  byte   HHNOPU04 4234-4234
  int    HHNOSR04 4235-4238
  int    HHINFD04 4239-4241
  int    VISEXP04 4242-4245
  int    VISTCH04 4246-4249
  int    VISSLF04 4250-4253
  int    VISMCR04 4254-4256
  int    VISMCD04 4257-4260
  int    VISPRV04 4261-4264
  int    VISVA04 4265-4267
  int    VISTRI04 4268-4270
  int    VISOFD04 4271-4273
  int    VISSTL04 4274-4276
  int    VISWCP04 4277-4279
  int    VISOPR04 4280-4282
  int    VISOPU04 4283-4285
  int    VISOSR04 4286-4288
  long   OTHTCH04 4289-4293
  long   OTHEXP04 4294-4298
  long   OTHSLF04 4299-4303
  int    OTHMCR04 4304-4307
  long   OTHMCD04 4308-4312
  int    OTHPRV04 4313-4316
  int    OTHVA04 4317-4320
  int    OTHTRI04 4321-4324
  int    OTHOFD04 4325-4327
  int    OTHSTL04 4328-4331
  int    OTHWCP04 4332-4335
  int    OTHOPR04 4336-4339
  int    OTHOPU04 4340-4342
  int    OTHOSR04 4343-4346
  int    RXTOT04 4347-4349
  long   RXEXP04 4350-4354
  long   RXSLF04 4355-4359
  long   RXMCR04 4360-4364
  long   RXMCD04 4365-4369
  long   RXPRV04 4370-4374
  long   RXVA04 4375-4379
  long   RXTRI04 4380-4384
  int    RXOFD04 4385-4388
  long   RXSTL04 4389-4393
  int    RXWCP04 4394-4397
  long   RXOPR04 4398-4402
  int    RXOPU04 4403-4406
  int    RXOSR04 4407-4410
  double PERWT04F 4411-4422
  double FAMWT04F 4423-4434
  double FAMWT04C 4435-4446
  double SAQWT04F 4447-4458
  double DIABW04F 4459-4470
  int    VARSTR 4471-4473
  byte   VARPSU 4474-4474
using H89.dat;

*DEFINE VARIABLE LABELS;
label variable DUID "DWELLING UNIT ID";
label variable PID "PERSON NUMBER";
label variable DUPERSID "PERSID (DUID + PID)";
label variable PANEL04 "PANEL NUMBER";
label variable FAMID31 "FAMILY ID (STUDENT MERGED IN) - R3/1";
label variable FAMID42 "FAMILY ID (STUDENT MERGED IN) - R4/2";
label variable FAMID53 "FAMILY ID (STUDENT MERGED IN) - R5/3";
label variable FAMID04 "FAMILY ID (STUDENT MERGED IN) - 12/31/04";
label variable FAMIDYR "ANNUAL FAMILY IDENTIFIER";
label variable CPSFAMID "CPSFAMID";
label variable HIEUIDX "HIEU IDENTIFIER";
label variable FCSZ1231 "FAM SIZE RESPONDING 12/31 CPS FAMILY-04";
label variable FCRP1231 "REF PERSON OF 12/31 CPS FAMILY-04";
label variable RULETR31 "RU LETTER - R3/1";
label variable RULETR42 "RU LETTER - R4/2";
label variable RULETR53 "RU LETTER - R5/3";
label variable RULETR04 "RU LETTER AS OF 12/31/04";
label variable RUSIZE31 "RU SIZE - R3/1";
label variable RUSIZE42 "RU SIZE - R4/2";
label variable RUSIZE53 "RU SIZE - R5/3";
label variable RUSIZE04 "RU SIZE AS OF 12/31/04";
label variable RUCLAS31 "RU FIELDED AS:STANDARD/NEW/STUDENT-R3/1";
label variable RUCLAS42 "RU FIELDED AS:STANDARD/NEW/STUDENT-R4/2";
label variable RUCLAS53 "RU FIELDED AS:STANDARD/NEW/STUDENT-R5/3";
label variable RUCLAS04 "RU FIELDED AS:STANDARD/NEW/STUD-12/31/04";
label variable FAMSZE31 "RU SIZE INCLUDING STUDENTS - R3/1";
label variable FAMSZE42 "RU SIZE INCLUDING STUDENTS - R4/2";
label variable FAMSZE53 "RU SIZE INCLUDING STUDENTS - R5/3";
label variable FAMSZE04 "RU SIZE INCLUDING STUDENT AS OF 12/31/04";
label variable FMRS1231 "MEMBER OF RESPONDING 12/31 FAMILY";
label variable FAMS1231 "FAMILY SIZE OF RESPONDING 12/31 FAMILY";
label variable FAMSZEYR "SIZE OF RESPONDING ANNUALIZED FAMILY";
label variable FAMRFPYR "REFERENCE PERSON OF ANNUALIZED FAMILY";
label variable REGION31 "CENSUS REGION - R3/1";
label variable REGION42 "CENSUS REGION - R4/2";
label variable REGION53 "CENSUS REGION - R5/3";
label variable REGION04 "CENSUS REGION AS OF 12/31/04";
label variable MSA31 "MSA STATUS - R3/1";
label variable MSA42 "MSA STATUS - R4/2";
label variable MSA53 "MSA STATUS - R5/3";
label variable MSA04 "MSA AS OF 12/31/04";
label variable REFPRS31 "REFERENCE PERSON AT - R3/1";
label variable REFPRS42 "REFERENCE PERSON AT - R4/2";
label variable REFPRS53 "REFERENCE PERSON AT - R5/3";
label variable REFPRS04 "REFERENCE PERSON AS OF 12/31/04";
label variable RESP31 "1ST RESPONDENT INDICATOR FOR R3/1";
label variable RESP42 "1ST RESPONDENT INDICATOR FOR R4/2";
label variable RESP53 "1ST RESPONDENT INDICATOR FOR R5/3";
label variable RESP04 "1ST RESPONDENT INDICATOR AS OF 12/31/04";
label variable PROXY31 "WAS RESPONDENT A PROXY IN R3/1";
label variable PROXY42 "WAS RESPONDENT A PROXY IN R4/2";
label variable PROXY53 "WAS RESPONDENT A PROXY IN R5/3";
label variable PROXY04 "WAS RESPONDENT A PROXY AS OF 12/31/04";
label variable INTVLANG "LANGUAGE INTERVIEW WAS COMPLETED";
label variable BEGRFD31 "R3/1 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM31 "R3/1 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY31 "R3/1 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD31 "R3/1 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM31 "R3/1 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY31 "R3/1 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFD42 "R4/2 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM42 "R4/2 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY42 "R4/2 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD42 "R4/2 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM42 "R4/2 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY42 "R4/2 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFD53 "R5/3 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM53 "R5/3 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY53 "R5/3 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD53 "R5/3 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM53 "R5/3 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY53 "R5/3 REFERENCE PERIOD END DATE: YEAR";
label variable ENDRFD04 "2004 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM04 "2004 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY04 "2004 REFERENCE PERIOD END DATE: YEAR";
label variable KEYNESS "PERSON KEY STATUS";
label variable INSCOP31 "INSCOPE - R3/1";
label variable INSCOP42 "INSCOPE - R4/2";
label variable INSCOP53 "INSCOPE - R5/3";
label variable INSCOP04 "INSCOPE - R5/3 START THROUGH 12/31/04";
label variable INSC1231 "INSCOPE STATUS ON 12/31/04";
label variable INSCOPE "WAS PERSON EVER INSCOPE IN 2004";
label variable ELGRND31 "ELIGIBILITY - R3/1";
label variable ELGRND42 "ELIGIBILITY - R4/2";
label variable ELGRND53 "ELIGIBILITY - R5/3";
label variable ELGRND04 "ELIGIBILITY STATUS AS OF 12/31/04";
label variable PSTATS31 "PERSON DISPOSITION STATUS - R3/1";
label variable PSTATS42 "PERSON DISPOSITION STATUS - R4/2";
label variable PSTATS53 "PERSON DISPOSITION STATUS - R5/3";
label variable RURSLT31 "RU RESULT - R3/1";
label variable RURSLT42 "RU RESULT - R4/2";
label variable RURSLT53 "RU RESULT - R5/3";
label variable AGE31X "AGE - R3/1 (EDITED/IMPUTED)";
label variable AGE42X "AGE - R4/2 (EDITED/IMPUTED)";
label variable AGE53X "AGE - R5/3 (EDITED/IMPUTED)";
label variable AGE04X "AGE AS OF 12/31/04 (EDITED/IMPUTED)";
label variable DOBMM "DATE OF BIRTH: MONTH";
label variable DOBYY "DATE OF BIRTH: YEAR";
label variable SEX "SEX";
label variable RACEX "RACE (EDITED/IMPUTED)";
label variable RACEAX "ASIAN AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEBX "BLACK AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEWX "WHITE AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACETHNX "RACE/ETHNICITY (EDITED/IMPUTED)";
label variable HISPANX "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable HISPCAT "SPECIFIC HISPANIC ETHNICITY GROUP";
label variable MARRY31X "MARITAL STATUS - R3/1 (EDITED/IMPUTED)";
label variable MARRY42X "MARITAL STATUS - R4/2 (EDITED/IMPUTED)";
label variable MARRY53X "MARITAL STATUS - R5/3 (EDITED/IMPUTED)";
label variable MARRY04X "MARITAL STATUS-12/31/04 (EDITED/IMPUTED)";
label variable SPOUID31 "SPOUSE ID - R3/1";
label variable SPOUID42 "SPOUSE ID - R4/2";
label variable SPOUID53 "SPOUSE ID - R5/3";
label variable SPOUID04 "SPOUSE ID - 12/31/04";
label variable SPOUIN31 "MARITAL STATUS W/SPOUSE PRESENT-R3/1";
label variable SPOUIN42 "MARITAL STATUS W/SPOUSE PRESENT-R4/2";
label variable SPOUIN53 "MARITAL STATUS W/SPOUSE PRESENT-R5/3";
label variable SPOUIN04 "MARITAL STATUS W/SPOUSE PRESENT-12/31/04";
label variable EDUCYEAR "YEARS OF EDUC WHEN FIRST ENTERED MEPS";
label variable HIDEGYR "HIGHEST DEGREE WHEN FIRST ENTERED MEPS";
label variable FTSTU31X "STUDENT STATUS IF AGES 17-23 - R3/1";
label variable FTSTU42X "STUDENT STATUS IF AGES 17-23 - R4/2";
label variable FTSTU53X "STUDENT STATUS IF AGES 17-23 - R5/3";
label variable FTSTU04X "STUDENT STATUS IF AGES 17-23 - 12/31/04";
label variable ACTDTY31 "MILITARY FULL-TIME ACTIVE DUTY - R3/1";
label variable ACTDTY42 "MILITARY FULL-TIME ACTIVE DUTY - R4/2";
label variable ACTDTY53 "MILITARY FULL-TIME ACTIVE DUTY - R5/3";
label variable DIDSERVE "EVER SERVED IN ARMED FORCES";
label variable VETVIET "SERVED IN VIETNAM WAR ERA";
label variable VETKOR "SERVED IN KOREAN WAR ERA";
label variable VETWW "SERVED IN WWI OR WW2 ERA";
label variable VETGULF "SERVED IN PERSIAN GULF/DESERT STORM";
label variable VETOTH "SERVED IN OTHER PERIOD";
label variable RFREL31X "RELATION TO REF PERS-R3/1 (EDIT/IMP)";
label variable RFREL42X "RELATION TO REF PERS-R4/2 (EDIT/IMP)";
label variable RFREL53X "RELATION TO REF PERS-R5/3 (EDIT/IMP)";
label variable RFREL04X "RELATION TO REF PERS-12/31/04 (EDIT/IMP)";
label variable MOPID31X "PID OF PERSON S MOM - RD 3/1";
label variable MOPID42X "PID OF PERSON S MOM - RD 4/2";
label variable MOPID53X "PID OF PERSON S MOM - RD 5/3";
label variable DAPID31X "PID OF PERSON S DAD - RD 3/1";
label variable DAPID42X "PID OF PERSON S DAD - RD 4/2";
label variable DAPID53X "PID OF PERSON S DAD - RD 5/3";
label variable SSIDIS04 "SSI RECEIPT DUE TO DISABILITY";
label variable AFDC04 "DID PERSON S CHECK INCLUDE TANF";
label variable FILEDR04 "HAS PERSON FILED A FED INCOME TAX RETURN";
label variable WILFIL04 "WILL PERSON FILE FED INCOME TAX RETURN";
label variable FLSTAT04 "PERSON S FILING STATUS";
label variable FILER04 "PRIMARY OR SECONDARY FILER";
label variable JTINRU04 "JOINT FILER S MEMBERSHIP IN RU";
label variable JNTPID04 "PID OF SECONDARY FILER";
label variable CLMDEP04 "DID/WILL PERS CLAIM DEPENDENTS ON RETURN";
label variable DEPDNT04 "PERSON IS FLAGGED A DEPENDENT";
label variable DPINRU04 "DEPENDENTS IN/OUT OF RU";
label variable DPOTSD04 "HOW MANY DEPENDENTS LIVE OUTSIDE RU";
label variable TAXFRM04 "TAX FORM PERSON WILL FILE";
label variable DEDUCT04 "ITEMIZE OR STANDARD DEDUCTION";
label variable TOTDED04 "TOTAL OF ALL ITEMIZED DEDUCTIONS";
label variable CLMHIP04 "DID/WILL PERS DEDUCT HEALTH INSUR. PREM.";
label variable EICRDT04 "DID/WILL PERS RECEIVE EARNED INC CREDIT";
label variable FOODST04 "DID ANYONE PURCHASE FOOD STAMPS";
label variable FOODMN04 "NUMBER OF MONTHS FOOD STAMPS PURCHASED";
label variable FOODCT04 "MONTHLY AMT FAMILY PAID FOR FOOD STAMPS";
label variable FOODVL04 "MONTHLY VALUE OF FOOD STAMPS";
label variable TTLP04X "PERSON S TOTAL INCOME";
label variable POVCAT04 "FAMILY INCOME AS PERCENT OF POVERTY LINE";
label variable WAGEP04X "PERSON S WAGE INCOME";
label variable WAGIMP04 "WAGE IMPUTATION FLAG";
label variable BUSNP04X "PERSON S BUSINESS INCOME";
label variable BUSIMP04 "BUSINESS INCOME IMPUTATION FLAG";
label variable UNEMP04X "PERSON S UNEMPLOYMENT COMP INCOME";
label variable UNEIMP04 "UNEMPLOYMENT IMPUTATION FLAG";
label variable WCMPP04X "PERSON S WORKERS  COMPENSATION";
label variable WCPIMP04 "WORKER S COMP IMPUTATION FLAG";
label variable INTRP04X "PERSON S INTEREST INCOME";
label variable INTIMP04 "INTEREST INCOME IMPUTATION FLAG";
label variable DIVDP04X "PERSON S DIVIDEND INCOME";
label variable DIVIMP04 "DIVIDEND INCOME IMPUTATION FLAG";
label variable SALEP04X "PERSON S SALES INCOME";
label variable SALIMP04 "SALES INCOME IMPUTATION FLAG";
label variable PENSP04X "PERSON S PENSION INCOME";
label variable PENIMP04 "PENSION INCOME IMPUTATION FLAG";
label variable SSECP04X "PERSON S SOCIAL SECURITY INCOME";
label variable SSCIMP04 "SOCIAL SECURITY INCOME IMPUTATION FLAG";
label variable TRSTP04X "PERSON S TRUST/RENT INCOME";
label variable TRTIMP04 "TRUST INCOME IMPUTATION FLAG";
label variable VETSP04X "PERSON S VETERANS INCOME";
label variable VETIMP04 "VETERAN S INCOME IMPUTATION FLAG";
label variable IRASP04X "PERSON S IRA INCOME";
label variable IRAIMP04 "IRA INCOME IMPUTATION FLAG";
label variable REFDP04X "PERSON S REFUND INCOME";
label variable REFIMP04 "REFUND INCOME IMPUTATION FLAG";
label variable ALIMP04X "PERSON S ALIMONY INCOME";
label variable ALIIMP04 "ALIMONY INCOME IMPUTATION FLAG";
label variable CHLDP04X "PERSON S CHILD SUPPORT";
label variable CHLIMP04 "CHILD SUPPORT IMPUTATION FLAG";
label variable CASHP04X "PERSON S OTHER REGULAR CASH CONTRIBUTION";
label variable CSHIMP04 "CASH CONTRIBUTION IMPUTATION FLAG";
label variable SSIP04X "PERSON S SSI";
label variable SSIIMP04 "SSI IMPUTATION FLAG";
label variable PUBP04X "PERSON S PUBLIC ASSISTANCE";
label variable PUBIMP04 "PUBLIC ASSISTANCE IMPUTATION FLAG";
label variable OTHRP04X "PERSON S OTHER INCOME";
label variable OTHIMP04 "OTHER INCOME IMPUTATION FLAG";
label variable RTHLTH31 "PERCEIVED HEALTH STATUS - RD 3/1";
label variable RTHLTH42 "PERCEIVED HEALTH STATUS - RD 4/2";
label variable RTHLTH53 "PERCEIVED HEALTH STATUS - RD 5/3";
label variable MNHLTH31 "PERCEIVED MENTAL HEALTH STATUS - RD 3/1";
label variable MNHLTH42 "PERCEIVED MENTAL HEALTH STATUS - RD 4/2";
label variable MNHLTH53 "PERCEIVED MENTAL HEALTH STATUS - RD 5/3";
label variable IADLHP31 "IADL SCREENER - RD 3/1";
label variable IADLHP42 "IADL SCREENER - RD 4/2";
label variable IADLHP53 "IADL SCREENER - RD 5/3";
label variable IADL3M31 "IADL HELP 3+ MONTHS - RD 3/1";
label variable IADL3M42 "IADL HELP 3+ MONTHS - RD 4/2";
label variable IADL3M53 "IADL HELP 3+ MONTHS - RD 5/3";
label variable ADLHLP31 "ADL SCREENER - RD 3/1";
label variable ADLHLP42 "ADL SCREENER - RD 4/2";
label variable ADLHLP53 "ADL SCREENER - RD 5/3";
label variable ADL3MO31 "ADL HELP 3+ MONTHS - RD 3/1";
label variable ADL3MO42 "ADL HELP 3+ MONTHS - RD 4/2";
label variable ADL3MO53 "ADL HELP 3+ MONTHS - RD 5/3";
label variable AIDHLP31 "USED ASSISTIVE DEVICES - RD 3/1";
label variable AIDHLP53 "USED ASSISTIVE DEVICES - RD 5/3";
label variable WLKLIM31 "LIMITATION IN PHYSICAL FUNCTIONING-RD3/1";
label variable WLKLIM53 "LIMITATION IN PHYSICAL FUNCTIONING-RD5/3";
label variable LFTDIF31 "DIFFICULTY LIFTING 10 POUNDS - RD 3/1";
label variable LFTDIF53 "DIFFICULTY LIFTING 10 POUNDS - RD 5/3";
label variable STPDIF31 "DIFFICULTY WALKING UP 10 STEPS - RD 3/1";
label variable STPDIF53 "DIFFICULTY WALKING UP 10 STEPS - RD 5/3";
label variable WLKDIF31 "DIFFICULTY WALKING 3 BLOCKS - RD 3/1";
label variable WLKDIF53 "DIFFICULTY WALKING 3 BLOCKS - RD 5/3";
label variable MILDIF31 "DIFFICULTY WALKING A MILE - RD 3/1";
label variable MILDIF53 "DIFFICULTY WALKING A MILE - RD 5/3";
label variable STNDIF31 "DIFFICULTY STANDING 20 MINUTES - RD 3/1";
label variable STNDIF53 "DIFFICULTY STANDING 20 MINUTES - RD 5/3";
label variable BENDIF31 "DIFFICULTY BENDING/STOOPING - RD 3/1";
label variable BENDIF53 "DIFFICULTY BENDING/STOOPING - RD 5/3";
label variable RCHDIF31 "DIFFICULTY REACHING OVERHEAD - RD 3/1";
label variable RCHDIF53 "DIFFICULTY REACHING OVERHEAD - RD 5/3";
label variable FNGRDF31 "DIFFICULTY USING FINGERS TO GRASP-RD 3/1";
label variable FNGRDF53 "DIFFICULTY USING FINGERS TO GRASP-RD 5/3";
label variable WLK3MO31 "PHYS FUNCTIONING HELP 3+ MONTHS - RD 3/1";
label variable WLK3MO53 "PHYS FUNCTIONING HELP 3+ MONTHS - RD 5/3";
label variable ACTLIM31 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 3/1";
label variable ACTLIM53 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 5/3";
label variable WRKLIM31 "WORK LIMITATION - RD 3/1";
label variable WRKLIM53 "WORK LIMITATION - RD 5/3";
label variable HSELIM31 "HOUSEWORK LIMITATION - RD 3/1";
label variable HSELIM53 "HOUSEWORK LIMITATION - RD 5/3";
label variable SCHLIM31 "SCHOOL LIMITATION - RD 3/1";
label variable SCHLIM53 "SCHOOL LIMITATION - RD 5/3";
label variable UNABLE31 "COMPLETELY UNABLE TO DO ACTIVITY-RD 3/1";
label variable UNABLE53 "COMPLETELY UNABLE TO DO ACTIVITY-RD 5/3";
label variable SOCLIM31 "SOCIAL LIMITATIONS - RD 3/1";
label variable SOCLIM53 "SOCIAL LIMITATIONS - RD 5/3";
label variable COGLIM31 "COGNITIVE LIMITATIONS - RD 3/1";
label variable COGLIM53 "COGNITIVE LIMITATIONS - RD 5/3";
label variable WRGLAS42 "WEARS EYEGLASSES OR CONTACTS - RD 4/2";
label variable SEEDIF42 "DIFFCLTY SEEING W/GLASSES/CNTCTS-RD 4/2";
label variable BLIND42 "PERSON IS BLIND - RD 4/2";
label variable READNW42 "CAN READ NEWSPRNT W/GLASSES/CNTCTS-RD4/2";
label variable RECPEP42 "CAN RECGNZE PEOPLE W/GLASSES/CNTCTS-R4/2";
label variable VISION42 "VISION IMPAIRMENT (SUMMARY) - RD 4/2";
label variable HEARAD42 "PERSON WEARS HEARING AID - RD 4/2";
label variable HEARDI42 "ANY DIFFCLTY HEARING W/HEARING AID-RD4/2";
label variable DEAF42 "PERSON IS DEAF - RD 4/2";
label variable HEARMO42 "CAN HEAR MOST CONVERSATION - RD 4/2";
label variable HEARSM42 "CAN HEAR SOME CONVERSATION - RD 4/2";
label variable HEARNG42 "HEARING IMPAIRMENT (SUMMARY) - RD 4/2";
label variable ANYLIM04 "ANY LIMITATION IN P8R3,4,5/P9R1,2,3";
label variable LSHLTH42 "LESS HEALTHY THAN OTHR CHILD (0-17)-R4/2";
label variable NEVILL42 "NEVER BEEN SERIOUSLY ILL (0-17)-R4/2";
label variable SICEAS42 "CHILD GETS SICK EASILY (0-17)-R4/2";
label variable HLTHLF42 "CHILD WILL HAVE HEALTHY LIFE (0-17)-R4/2";
label variable WRHLTH42 "WORRY MORE ABOUT HEALTH (0-17)-R4/2";
label variable CHPMED42 "CSHCN:CHILD NEEDS PRESCRB MED(0-17)-R4/2";
label variable CHPMHB42 "CSHCN:PMED FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHPMCN42 "CSHCN:PMED COND LAST 12+ MOS (0-17)-R4/2";
label variable CHSERV42 "CSHCN:CHLD NEEDS MED&OTH SERV(0-17)-R4/2";
label variable CHSRHB42 "CSHCN:SERV FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHSRCN42 "CSHCN:SERV COND LAST 12+ MOS (0-17)-R4/2";
label variable CHLIMI42 "CSHCN:LIMITED IN ANY WAY (0-17)-R4/2";
label variable CHLIHB42 "CSHCN:LIMT FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHLICO42 "CSHCN:LIMIT COND LAST 12+MOS (0-17)-R4/2";
label variable CHTHER42 "CSHCN:CHLD NEEDS SPEC THERAPY(0-17)-R4/2";
label variable CHTHHB42 "CSHCN:SPEC THER FOR HLTH+COND(0-17)-R4/2";
label variable CHTHCO42 "CSHCN:THER COND LAST 12+ MOS (0-17)-R4/2";
label variable CHCOUN42 "CSHCN:CHILD NEEDS COUNSELING (0-17)-R4/2";
label variable CHEMPB42 "CSHCN:COUNS PROB LAST 12+MOS (0-17)-R4/2";
label variable CSHCN42 "CSHCN:CHILD W/SPEC HC NEEDS (0-17)-R4/2";
label variable MOMPRO42 "PROBLEM GETTING ALONG W/MOM (5-17)-R4/2";
label variable DADPRO42 "PROBLEM GETTING ALONG W/DAD (5-17)-R4/2";
label variable UNHAP42 "PROBLEM FEELING UNHAPPY/SAD (5-17)-R4/2";
label variable SCHLBH42 "PROBLEM BEHAVIOR AT SCHOOL (5-17)-R4/2";
label variable HAVFUN42 "PROBLEM HAVING FUN (5-17) - R4/2";
label variable ADUPRO42 "PRBLM GETTING ALONG W/ADULTS (5-17)-R4/2";
label variable NERVAF42 "PRBLM FEELING NERVOUS/AFRAID (5-17)-R4/2";
label variable SIBPRO42 "PRBLM GETTING ALONG W/SIBS (5-17)-R4/2";
label variable KIDPRO42 "PRBLM GETTING ALONG W/KIDS (5-17)-R4/2";
label variable SPRPRO42 "PROBLEM W/SPORTS/HOBBIES (5-17)-R4/2";
label variable SCHPRO42 "PROBLEM WITH SCHOOLWORK (5-17)-R4/2";
label variable HOMEBH42 "PROBLEM W/BEHAVIOR AT HOME (5-17)-R4/2";
label variable TRBLE42 "PRBLM STAY OUT OF TROUBLE (5-17)-R4/2";
label variable CHILCR42 "CAHPS:12MOS:ILL/INJ NEED CARE(0-17)-R4/2";
label variable CHILWW42 "CAHPS:12MOS:ILL CARE WHN WNTD(0-17)-R4/2";
label variable CHRTCR42 "CAHPS:12MOS:MAKE ROUT CARE APT(0-17)R4/2";
label variable CHRTWW42 "CAHPS:12MOS:ROUT APT WHN WNTD(0-17)-R4/2";
label variable CHAPPT42 "CAHPS:12MOS:# OF OFF/CLIN APTS(0-17)R4/2";
label variable CHNDCR42 "CAHPS:12MOS:NEED ANY CARE/TRT(0-17)-R4/2";
label variable CHNECP42 "CAHPS:12MOS:PROB GET NEC CARE(0-17)R4/2";
label variable CHLIST42 "CAHPS:12MOS:CHLD DR LSN TO YOU(0-17)R4/2";
label variable CHEXPL42 "CAHPS:12MOS:CHLD DR EXPL THNG(0-17)R4/2";
label variable CHRESP42 "CAHPS:12MOS:CHLD S DR SHW RESP(0-17)R4/2";
label variable CHPRTM42 "CAHPS:12MOS:CHILD DR ENGH TIME(0-17)R4/2";
label variable CHHECR42 "CAHPS:12MOS:RATE CHLD HLT CARE(0-17)R4/2";
label variable CHSPEC42 "CAHPS:12MOS:CHLD NEEDED SPEC(0-17)R4/2";
label variable CHPRRE42 "CAHPS:12MOS:PRB W/RFR TO SPEC(0-17)R4/2";
label variable MESHGT42 "DOCTOR EVER MEASURED HEIGHT (0-17)-R4/2";
label variable WHNHGT42 "WHEN DOCTOR MEASURED HEIGHT (0-17)-R4/2";
label variable MESWGT42 "DOCTOR EVER MEASURED WEIGHT (0-17)-R4/2";
label variable WHNWGT42 "WHEN DOCTOR MEASURED WEIGHT (0-17)-R4/2";
label variable CHBMIX42 "CHILD S BODY MASS INDEX (6-17)-R4/2";
label variable MESVIS42 "DOCTOR CHECKED CHILD S VISION (3-6)-R4/2";
label variable MESBPR42 "DR CHECKED BLOOD PRESSURE (2-17)-R4/2";
label variable WHNBPR42 "WHEN DR CHECKED BLOOD PRESS (2-17)-R4/2";
label variable DENTAL42 "DR ADVISE REG DENTAL CHECKUP (2-17)-R4/2";
label variable WHNDEN42 "WHEN DR ADVISE DENT CHECKUP (2-17)-R4/2";
label variable EATHLT42 "DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable WHNEAT42 "WHEN DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable PHYSCL42 "DR ADVISE EXERCISE (2-17)-R4/2";
label variable WHNPHY42 "WHEN DR ADVISE EXERCISE (2-17)-R4/2";
label variable SAFEST42 "DR ADVISE CHLD SAFETY SEAT (WT<=40)-R4/2";
label variable WHNSAF42 "WHEN DR ADVISE SAFETY SEAT (WT<=40)-R4/2";
label variable BOOST42 "DR ADVISE BOOSTER SEAT (40<WT<=80)-R4/2";
label variable WHNBST42 "WHN DR ADVISE BOOST SEAT(40<WT<=80)-R4/2";
label variable LAPBLT42 "DR ADVISE LAP/SHOULDER BELT (80<WT)-R4/2";
label variable WHNLAP42 "WHN DR ADVISE LAP/SHLDR BLT (80<WT)-R4/2";
label variable HELMET42 "DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable WHNHEL42 "WHEN DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable NOSMOK42 "DR ADVISE SMKG IN HOME IS BAD(0-17)-R4/2";
label variable WHNSMK42 "WHN DR ADVIS SMKG IN HOME BAD(0-17)-R4/2";
label variable TIMALN42 "DOCTOR SPEND ANY TIME ALONE (12-17)-R4/2";
label variable DENTCK53 "HOW OFTEN DENTAL CHECK-UP - RD 5/3";
label variable CHOLCK53 "HOW LNG CHOLEST LST CHCK (>17) - RD 5/3";
label variable CHECK53 "HOW LNG LST ROUTNE CHECKUP (>17)-RD 5/3";
label variable FLUSHT53 "HOW LNG LAST FLU SHT (>17) - RD 5/3";
label variable LSTETH53 "LOST ALL UPPR AND LOWR TEETH (>17)-RD5/3";
label variable PSA53 "HOW LONG SINCE LAST PSA (>39) - RD 5/3";
label variable HYSTER53 "HAD A HYSTERECTOMY (>17) - RD 5/3";
label variable PAPSMR53 "HOW LNG LST PAP SMEAR TST (>17) - RD 5/3";
label variable BRSTEX53 "HOW LNG SNCE LST BREAST EXAM (>17)-RD5/3";
label variable MAMOGR53 "HOW LNG SNCE LST MAMMOGRAM (>29) - RD5/3";
label variable STOOL53 "BLD STOOL TST KIT/CRDS HOME (>17)-RD5/3";
label variable WHENST53 "WHN LST BLD STOOL TST HME KIT (>17)-R5/3";
label variable BOWEL53 "SIGMOIDOSCOPY/COLONOSCOPY (>17) - RD 5/3";
label variable WHNBWL53 "LST SIGMOIDOSCOP/COLONOSCOP (>17)-RD 5/3";
label variable PHYACT53 "MOD/VIG PHYS ACTIV 3X WK (>17) - RD 5/3";
label variable BMINDX53 "ADULT BODY MASS INDEX (>17) - RD 5/3";
label variable SEATBE53 "WEARS SEAT BELT (>15) - RD 5/3";
label variable SRTHRT53 "12MO: SERIOUS SORE THROAT(0-17)-RD 5/3";
label variable THSYMP53 "12MO:SORE THRT/OTH SYMPTMS(0-17)-RD 5/3";
label variable DRTHRT53 "12MO: SEE DR FOR SORE THRT(0-17)-RD 5/3";
label variable THANTB53 "12MO: DR PRES ANTBTC SRE THRT(0-17)RD5/3";
label variable THSWAB53 "12MO: DR GAVE THROAT SWAB(0-17)-RD 5/3";
label variable THSYMF53 "12MO:FAM SAME SRE THRT SYMP (0-17)RD5/3";
label variable THSWBF53 "12MO:DR GAVE FAM THRT SWAB(0-17)-RD5/3";
label variable THANTF53 "12MO:DR PRES FAM ATBTC SR THT(0-17)RD5/3";
label variable DIABDX53 "DIABETES DIAGNOSIS - RD 5/3";
label variable ASTHDX53 "ASTHMA DIAGNOSIS - RD 5/3";
label variable ASSTIL53 "DOES PERSON STILL HAVE ASTHMA - RD 5/3";
label variable ASATAK53 "ASTHMA ATTACK LAST 12 MOS - RD 5/3";
label variable ASACUT53 "USED ACUTE PRES INHALER LAST 3 MOS-RD5/3";
label variable ASMRCN53 "USED>3ACUTE CN PRES INH LAST 3 MOS-RD5/3";
label variable ASPREV53 "EVER USED PREV DAILY ASTHMA MEDS -RD 5/3";
label variable ASDALY53 "NOW TAKE PREV DAILY ASTHMA MEDS - RD 5/3";
label variable ASPKFL53 "HAVE PEAK FLOW METER AT HOME - RD 5/3";
label variable ASEVFL53 "EVER USED PEAK FLOW METER - RD 5/3";
label variable ASWNFL53 "WHEN LAST USED PEAK FLOW METER - RD 5/3";
label variable HIBPDX53 "HIGH BLOOD PRESSURE DIAG (>17) - RD 5/3";
label variable BPMLDX53 "MULT DIAG HIGH BLOOD PRESS (>17) - RD5/3";
label variable BPCHEK53 "TIME SNCE LST BLOOD PRES CHK (>17)-RD5/3";
label variable BPMONT53 "# MOS SNCE LST BLOOD PRES CHK (>17)-R5/3";
label variable CHDDX53 "CORONARY HRT DISEASE DIAG (>17) - RD 5/3";
label variable ANGIDX53 "ANGINA DIAGNOSIS (>17) - RD 5/3";
label variable MIDX53 "HEART ATTACK (MI) DIAG (>17) - RD 5/3";
label variable OHRTDX53 "OTHER HEART DISEASE DIAG (>17) - RD 5/3";
label variable STRKDX53 "STROKE DIAGNOSIS (>17) - RD 5/3";
label variable EMPHDX53 "EMPHYSEMA DIAGNOSIS (>17) - RD 5/3";
label variable NOFAT53 "RESTRICT HGH FAT/CHOLES FOOD (>17)-RD5/3";
label variable EXRCIS53 "ADVISED TO EXERCISE MORE (>17) - RD 5/3";
label variable ASPRIN53 "TKE ASPIRN EVERY (OTHR) DAY (>17)-RD 5/3";
label variable NOASPR53 "TAKING ASPIRIN UNSAFE (>17) - RD 5/3";
label variable STOMCH53 "TKE ASPRN UNSAFE B/C STOMCH (>17)-RD 5/3";
label variable JTPAIN53 "JOINT PAIN LAST 12 MONTHS (>17) - RD 5/3";
label variable ARTHDX53 "ARTHRITIS DIAGNOSIS (>17) - RD 5/3";
label variable ARTHTX53 "ARTHRITIS TREATMNT CURRENTLY (>17)RD5/3";
label variable SAQELIG "ELIGIBILITY STATUS FOR SAQ";
label variable ADPRX42 "SAQ: RELATIONSHIP OF PROXY TO ADULT";
label variable ADILCR42 "SAQ 12MOS: ILL/INJURY NEEDING IMMED CARE";
label variable ADILWW42 "SAQ 12 MOS: GOT CARE WHEN NEEDED ILL/INJ";
label variable ADRTCR42 "SAQ 12 MOS: MADE APPT ROUTINE MED CARE";
label variable ADRTWW42 "SAQ 12 MOS: GOT MED APPT WHEN WANTED";
label variable ADAPPT42 "SAQ 12 MOS: # VISITS TO MED OFF FOR CARE";
label variable ADNDCR42 "SAQ 12MOS: NEED ANY CARE, TEST, TREATMNT";
label variable ADNECP42 "SAQ 12MOS: PROBS GETTING NEEDED MED CARE";
label variable ADLIST42 "SAQ 12 MOS: DOCTOR LISTENED TO YOU";
label variable ADEXPL42 "SAQ 12 MOS: DOC EXPLAINED SO UNDERSTOOD";
label variable ADRESP42 "SAQ 12 MOS: DR SHOWED RESPECT";
label variable ADPRTM42 "SAQ 12 MOS: DR SPENT ENUF TIME WITH YOU";
label variable ADHECR42 "SAQ 12 MOS: RATING OF HEALTH CARE";
label variable ADSMOK42 "SAQ: CURRENTLY SMOKE";
label variable ADNSMK42 "SAQ 12MOS: DR ADVISED TO QUIT SMOKING";
label variable ADDRBP42 "SAQ 2 YRS: DR CHECKED BLOOD PRESSURE";
label variable ADSPEC42 "SAQ 12 MOS: NEEDED TO SEE SPECIALIST";
label variable ADPRRE42 "SAQ 12MOS: PROBLEM GETTING SPEC REFERRAL";
label variable ADGENH42 "SAQ: HEALTH IN GENERAL SF-12V2";
label variable ADDAYA42 "SAQ: HLTH LIMITS MOD ACTIVITIES SF-12V2";
label variable ADCLIM42 "SAQ: HLTH LIMITS CLIMBING STAIRS SF-12V2";
label variable ADPALS42 "SAQ 4WKS:ACCMP LESS B/C PHY PRBS SF-12V2";
label variable ADPWLM42 "SAQ 4WKS:WORK LIMT B/C PHY PROBS SF-12V2";
label variable ADMALS42 "SAQ 4WKS:ACCMP LESS B/C MNT PRBS SF-12V2";
label variable ADMWLM42 "SAQ 4WKS:WORK LIMT B/C MNT PROBS SF-12V2";
label variable ADPAIN42 "SAQ 4WKS:PAIN LIMITS NORMAL WORK SF-12V2";
label variable ADCAPE42 "SAQ 4WKS: FELT CALM/PEACEFUL SF-12V2";
label variable ADNRGY42 "SAQ 4WKS: HAD A LOT OF ENERGY SF-12V2";
label variable ADDOWN42 "SAQ 4WKS: FELT DOWNHEARTED/DEPR SF-12V2";
label variable ADSOCA42 "SAQ 4WKS: HLTH STOPPED SOC ACTIV SF-12V2";
label variable PCS42 "SAQ:PHY COMPONENT SUMMRY SF-12V2 IMPUTED";
label variable MCS42 "SAQ:MNT COMPONENT SUMMRY SF-12V2 IMPUTED";
label variable SFFLAG42 "SAQ: PCS/MCS IMPUTATION FLAG SF-12V2";
label variable ADNERV42 "SAQ 30 DAYS: HOW OFTEN FELT NERVOUS";
label variable ADHOPE42 "SAQ 30 DAYS: HOW OFTEN FELT HOPELESS";
label variable ADREST42 "SAQ 30 DAYS: HOW OFTEN FELT RESTLESS";
label variable ADSAD42 "SAQ 30 DAYS: HOW OFTEN FELT SAD";
label variable ADEFRT42 "SAQ 30 DAYS: HOW OFTN EVRYTHNG AN EFFORT";
label variable ADWRTH42 "SAQ 30 DAYS: HOW OFTEN FELT WORTHLESS";
label variable K6SUM42 "SAQ 30 DAYS: OVERALL RATING OF FEELINGS";
label variable ADINTR42 "SAQ 2 WKS: LITTLE INTEREST IN THINGS";
label variable ADDPRS42 "SAQ 2 WKS: FELT DOWN/DEPRESSED/HOPELESS";
label variable PHQ242 "SAQ 2 WKS: OVERALL RATING OF FEELINGS";
label variable ADINSA42 "SAQ: DO NOT NEED HEALTH INSURANCE";
label variable ADINSB42 "SAQ: HEALTH INSURANCE NOT WORTH COST";
label variable ADRISK42 "SAQ: MORE LIKELY TO TAKE RISKS";
label variable ADOVER42 "SAQ: CAN OVERCOME ILLS WITHOUT MED HELP";
label variable ADCMPM42 "SAQ: DATE COMPLETED - MONTH";
label variable ADCMPD42 "SAQ: DATE COMPLETED - DAY";
label variable ADCMPY42 "SAQ: DATE COMPLETED - YEAR";
label variable ADLANG42 "SAQ: LANGUAGE OF SAQ INTERVIEW";
label variable DSDIA53 "DCS: DIABETES DIAGNOSIS BY HEALTH PROF";
label variable DSA1C53 "DCS: TIMES TESTED FOR A-ONE-C - 2004";
label variable DSCKFT53 "DCS: TIMES FEET CHECKED FOR SORES - 2004";
label variable DSEY0553 "DCS: DILATED EYE EXAM IN 2005";
label variable DSEY0453 "DCS: DILATED EYE EXAM IN 2004";
label variable DSEY0353 "DCS: DILATED EYE EXAM IN 2003";
label variable DSEB0353 "DCS: DILATED EYE EXAM BEFORE 2003";
label variable DSEYNV53 "DCS: NEVER HAD DILATED EYE EXAM";
label variable DSKIDN53 "DCS: HAS DIABETES CAUSED KIDNEY PROBLEMS";
label variable DSEYPR53 "DCS: HAS DIABETES CAUSED EYE PROBS";
label variable DSDIET53 "DCS: TREAT DIABETES W/DIET MODIFICATION";
label variable DSMED53 "DCS: TREAT DIABETES W/MEDS BY MOUTH";
label variable DSINSU53 "DCS: TREAT DIABETES W/INSULIN INJECTIONS";
label variable DSPRX53 "DCS: WAS RESPONDENT A PROXY";
label variable DDNWRK31 "# DAYS MISSED WORK DUE TO ILL/INJ (RD31)";
label variable DDNWRK42 "# DAYS MISSED WORK DUE TO ILL/INJ (RD42)";
label variable DDNWRK53 "# DAYS MISSED WORK DUE TO ILL/INJ (RD53)";
label variable WKINBD31 "# DAYS MISSED WORK STAYED IN BED (RD31)";
label variable WKINBD42 "# DAYS MISSED WORK STAYED IN BED (RD42)";
label variable WKINBD53 "# DAYS MISSED WORK STAYED IN BED (RD53)";
label variable DDNSCL31 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD31)";
label variable DDNSCL42 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD42)";
label variable DDNSCL53 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD53)";
label variable SCLNBD31 "# DAYS MISSED SCHOOL STAYD IN BED (RD31)";
label variable SCLNBD42 "# DAYS MISSED SCHOOL STAYD IN BED (RD42)";
label variable SCLNBD53 "# DAYS MISSED SCHOOL STAYD IN BED (RD53)";
label variable DDBDYS31 "# OTH DAY SPENT IN BED SINCE START(RD31)";
label variable DDBDYS42 "# OTH DAY SPENT IN BED SINCE START(RD42)";
label variable DDBDYS53 "# OTH DAY SPENT IN BED SINCE START(RD53)";
label variable OTHDYS31 "MISS ANY WORK DAY TO CARE FOR OTH (RD31)";
label variable OTHDYS42 "MISS ANY WORK DAY TO CARE FOR OTH (RD42)";
label variable OTHDYS53 "MISS ANY WORK DAY TO CARE FOR OTH (RD53)";
label variable OTHNDD31 "# DAY MISSED WORK TO CARE FOR OTH (RD31)";
label variable OTHNDD42 "# DAY MISSED WORK TO CARE FOR OTH (RD42)";
label variable OTHNDD53 "# DAY MISSED WORK TO CARE FOR OTH (RD53)";
label variable ACCELI42 "PERS ELIGIBLE FOR ACCESS SUPPLEMENT-R4/2";
label variable LANGHM42 "AC01 LANGUAGE SPOKEN MOST IN HOME-R4/2";
label variable ENGHME42 "AC02 HH COMFORTABLE SPEAKNG ENGLISH-R4/2";
label variable ENGSPK42 "AC02A NOT COMFRTBLE SPEAKNG ENGLISH-R4/2";
label variable HAVEUS42 "AC05 DOES PERSON HAVE USC PROVIDER-R4/2";
label variable YNOUSC42 "AC07 MAIN REAS PERS DOESNT HAVE USC-R4/2";
label variable NOREAS42 "AC08 OTH REAS NO USC:NO OTH REASONS-R4/2";
label variable SELDSI42 "AC08 OTH REAS NO USC:SELDM/NEV SICK-R4/2";
label variable NEWARE42 "AC08 OTH REAS NO USC:RECENTLY MOVED-R4/2";
label variable DKWHRU42 "AC08 OTH REAS NO USC:DK WHERE TO GO-R4/2";
label variable USCNOT42 "AC08 OTH REAS NO USC: USC NOT AVAIL-R4/2";
label variable PERSLA42 "AC08 OTH REAS NO USC: LANGUAGE-R4/2";
label variable DIFFPL42 "AC08 OTH REAS NO USC:DIFFRNT PLACES-R4/2";
label variable INSRPL42 "AC08 OTH REAS NO USC:JUST CHNGD INS-R4/2";
label variable MYSELF42 "AC08 OTH REAS NO USC:NO DOC/TRT SLF-R4/2";
label variable CARECO42 "AC08 OTH REAS NO USC:COST OF MED CR-R4/2";
label variable OTHINS42 "AC08 OTH REAS NO USC: INS RELATED-R4/2";
label variable KNOWDR42 "AC08 OTH REAS NO USC: KNOWS/IS A DR-R4/2";
label variable TRANS42 "AC08 OTH REAS NO USC: TRANSPRT/TIME-R4/2";
label variable CLINIC42 "AC08 OTH REAS NO USC: HOSP/ER/CLNIC-R4/2";
label variable OTHREA42 "AC08 OTH REAS NO USC: OTHER REASON-R4/2";
label variable PROVTY42 "PROVIDER TYPE-R4/2";
label variable FACLPR42 "AC10 DOES PERS SEE PARTICULAR PROV-R4/2";
label variable PLCTYP42 "USC TYPE OF PLACE-R4/2";
label variable GOTOUS42 "AC12 HOW DOES PERS GET TO USC PROV-R4/2";
label variable TMTKUS42 "AC13 HOW LONG IT TAKES GET TO USC-R4/2";
label variable DFTOUS42 "AC14 HOW DIFFICULT IS IT GET TO USC-R4/2";
label variable TYPEPE42 "USC TYPE OF PROVIDER-R4/2";
label variable LOCATN42 "USC LOCATION-R4/2";
label variable HSPLAP42 "AC18 IS PROVIDER HISPANIC OR LATINO-R4/2";
label variable WHITPR42 "AC19 IS PROVIDER WHITE-R4/2";
label variable BLCKPR42 "AC19 IS PROVIDER BLACK/AFRICAN AMER-R4/2";
label variable ASIANP42 "AC19 IS PROVIDER ASIAN-R4/2";
label variable NATAMP42 "AC19 IS PROVIDER NATIVE AMERICAN-R4/2";
label variable PACISP42 "AC19 IS PROVIDER OTH PACIFIC ISLNDR-R4/2";
label variable OTHRCP42 "AC19 IS PROVIDER SOME OTHER RACE-R4/2";
label variable GENDRP42 "AC20 IS PROVIDER MALE OR FEMALE-R4/2";
label variable MINORP42 "AC22 GO TO USC FOR NEW HEALTH PROB-R4/2";
label variable PREVEN42 "AC22 GO TO USC FOR PRVNTVE HLT CARE-R4/2";
label variable REFFRL42 "AC22 GO TO USC FOR REFERRALS-R4/2";
label variable ONGONG42 "AC22 GO TO USC FOR ONGOING HLTH PRB-R4/2";
label variable PHNREG42 "AC23 HOW DIFF CONTACT USC BY PHONE-R4/2";
label variable OFFHOU42 "AC24 USC HAS OFFCE HRS NGHTS/WKENDS-R4/2";
label variable AFTHOU42 "AC25 HOW DIFF CONTACT USC AFT HOURS-R4/2";
label variable TREATM42 "AC26 PROV ASK ABOUT OTH TREATMENTS-R4/2";
label variable RESPCT42 "AC27 PROV SHOWS RESPECT FOR TRTMNTS-R4/2";
label variable DECIDE42 "AC28 PROV ASKS PERS TO HELP DECIDE-R4/2";
label variable EXPLOP42 "AC30 PROV EXPLNS OPTIONS TO PERS-R4/2";
label variable LANGPR42 "AC31 PROV SPEAKS PERSON S LANGUAGE-R4/2";
label variable MDUNAB42 "UNABLE TO GET NECESSRY MEDICAL CARE-R4/2";
label variable MDUNRS42 "AC34 RSN UNABLE GET NECSRY MED CARE-R4/2";
label variable MDUNPR42 "AC35 PRB NOT GETTING NCSRY MED CARE-R4/2";
label variable MDDLAY42 "DELAYED IN GETTING NECSRY MED CARE-R4/2";
label variable MDDLRS42 "AC38 RSN DLAYD GETTING NEC MED CARE-R4/2";
label variable MDDLPR42 "AC39 PRB DLAYD GETTING NEC MED CARE-R4/2";
label variable DNUNAB42 "UNABLE TO GET NECESSARY DENTAL CARE-R4/2";
label variable DNUNRS42 "AC42 RSN UNABLE GET NCSRY DENT CARE-R4/2";
label variable DNUNPR42 "AC43 PRB UNABLE GET NCSRY DENT CARE-R4/2";
label variable DNDLAY42 "DELAYED IN GETTING NEC DENTAL CARE-R4/2";
label variable DNDLRS42 "AC46 RSN DLAYD GETTNG NEC DENT CARE-R4/2";
label variable DNDLPR42 "AC47 PRB DLAYD GETTNG NEC DENT CARE-R4/2";
label variable PMUNAB42 "UNABLE TO GET NECESSARY PRES MED-R4/2";
label variable PMUNRS42 "AC50 RSN UNABLE TO GET NEC PRES MED-R4/2";
label variable PMUNPR42 "AC51 PRB UNABLE TO GET NEC PRES MED-R4/2";
label variable PMDLAY42 "DELAYED IN GETTING NECSRY PRES MED-R4/2";
label variable PMDLRS42 "AC54 RSN DLAYD GETTING NEC PRES MED-R4/2";
label variable PMDLPR42 "AC55 PRB DLAYD GETTING NEC PRES MED-R4/2";
label variable EMPST31 "EMPLOYMENT STATUS RD 3/1";
label variable EMPST42 "EMPLOYMENT STATUS RD 4/2";
label variable EMPST53 "EMPLOYMENT STATUS RD 5/3";
label variable RNDFLG31 "DATA COLLECTION ROUND FOR RD 3/1 CMJ";
label variable MORJOB31 "HAS MORE THAN ONE JOB RD 3/1 INT DATE";
label variable MORJOB42 "HAS MORE THAN ONE JOB RD 4/2 INT DATE";
label variable MORJOB53 "HAS MORE THAN ONE JOB RD 5/3 INT DATE";
label variable EVRWRK "EVER WRKD FOR PAY IN LIFE AS OF 12/31/04";
label variable HRWG31X "HOURLY WAGE RD 3/1 CMJ (IMP)";
label variable HRWG42X "HOURLY WAGE RD 4/2 CMJ (IMP)";
label variable HRWG53X "HOURLY WAGE RD 5/3 CMJ (IMP)";
label variable HRWGIM31 "HRWG31X IMPUTATION FLAG";
label variable HRWGIM42 "HRWG42X IMPUTATION FLAG";
label variable HRWGIM53 "HRWG53X IMPUTATION FLAG";
label variable HRHOW31 "HOW HOURLY WAGE WAS CALCULATED RD 3/1";
label variable HRHOW42 "HOW HOURLY WAGE WAS CALCULATED RD 4/2";
label variable HRHOW53 "HOW HOURLY WAGE WAS CALCULATED RD 5/3";
label variable DIFFWG31 "PERSONS WAGES DIFFERENT THIS RD31 AT CMJ";
label variable DIFFWG42 "PERSONS WAGES DIFFERENT THIS RD42 AT CMJ";
label variable DIFFWG53 "PERSONS WAGES DIFFERENT THIS RD53 AT CMJ";
label variable NHRWG31 "UPDATED HRLY WAGE RD 3/1 CMJ (EDITED)";
label variable NHRWG42 "UPDATED HRLY WAGE RD 4/2 CMJ (EDITED)";
label variable NHRWG53 "UPDATED HRLY WAGE RD 5/3 CMJ (EDITED)";
label variable HOUR31 "HOURS PER WEEK AT RD 3/1 CMJ";
label variable HOUR42 "HOURS PER WEEK AT RD 4/2 CMJ";
label variable HOUR53 "HOURS PER WEEK AT RD 5/3 CMJ";
label variable TEMPJB31 "IS CMJ A TEMPORARY JOB RD 3/1";
label variable TEMPJB42 "IS CMJ A TEMPORARY JOB RD 4/2";
label variable TEMPJB53 "IS CMJ A TEMPORARY JOB RD 5/3";
label variable SSNLJB31 "IS CMJ A SEASONAL JOB RD 3/1";
label variable SSNLJB42 "IS CMJ A SEASONAL JOB RD 4/2";
label variable SSNLJB53 "IS CMJ A SEASONAL JOB RD 5/3";
label variable SELFCM31 "SELF-EMPLOYED AT RD 3/1 CMJ";
label variable SELFCM42 "SELF-EMPLOYED AT RD 4/2 CMJ";
label variable SELFCM53 "SELF-EMPLOYED AT RD 5/3 CMJ";
label variable DISVW31X "DISAVOWED HEALTH INS AT RD 3/1 CMJ (ED)";
label variable DISVW42X "DISAVOWED HEALTH INS AT RD 4/2 CMJ (ED)";
label variable DISVW53X "DISAVOWED HEALTH INS AT RD 5/3 CMJ (ED)";
label variable CHOIC31 "CHOICE OF HEALTH PLANS AT RD 3/1 CMJ";
label variable CHOIC42 "CHOICE OF HEALTH PLANS AT RD 4/2 CMJ";
label variable CHOIC53 "CHOICE OF HEALTH PLANS AT RD 5/3 CMJ";
label variable INDCAT31 "INDUSTRY GROUP RD 3/1 CMJ";
label variable INDCAT42 "INDUSTRY GROUP RD 4/2 CMJ";
label variable INDCAT53 "INDUSTRY GROUP RD 5/3 CMJ";
label variable NUMEMP31 "NUMBER OF EMPLOYEES AT RD 3/1 CMJ";
label variable NUMEMP42 "NUMBER OF EMPLOYEES AT RD 4/2 CMJ";
label variable NUMEMP53 "NUMBER OF EMPLOYEES AT RD 5/3 CMJ";
label variable MORE31 "RD 3/1 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE42 "RD 4/2 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE53 "RD 5/3 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable UNION31 "UNION STATUS AT RD 3/1 CMJ";
label variable UNION42 "UNION STATUS AT RD 4/2 CMJ";
label variable UNION53 "UNION STATUS AT RD 5/3 CMJ";
label variable NWK31 "REASON NOT WORKING DURING RD 3/1";
label variable NWK42 "REASON NOT WORKING DURING RD 4/2";
label variable NWK53 "REASON NOT WORKING DURING RD 5/3";
label variable CHGJ3142 "CHANGED JOB BETWEEN RD 3/1 AND RD 4/2";
label variable CHGJ4253 "CHANGED JOB BETWEEN RD 4/2 AND RD 5/3";
label variable YCHJ3142 "WHY CHNGD JOB BETWEEN RD 3/1 AND RD 4/2";
label variable YCHJ4253 "WHY CHNGD JOB BETWEEN RD 4/2 AND RD 5/3";
label variable STJBMM31 "MONTH STARTED RD 3/1 CMJ";
label variable STJBDD31 "DAY STARTED RD 3/1 CMJ";
label variable STJBYY31 "YEAR STARTED RD 3/1 CMJ";
label variable STJBMM42 "MONTH STARTED RD 4/2 CMJ";
label variable STJBDD42 "DAY STARTED RD 4/2 CMJ";
label variable STJBYY42 "YEAR STARTED RD 4/2 CMJ";
label variable STJBMM53 "MONTH STARTED RD 5/3 CMJ";
label variable STJBDD53 "DAY STARTED RD 5/3 CMJ";
label variable STJBYY53 "YEAR STARTED RD 5/3 CMJ";
label variable EVRETIRE "PERSON HAS EVER RETIRED";
label variable OCCCAT31 "OCCUPATION GROUP RD 3/1 CMJ";
label variable OCCCAT42 "OCCUPATION GROUP RD 4/2 CMJ";
label variable OCCCAT53 "OCCUPATION GROUP RD 5/3 CMJ";
label variable PAYVAC31 "PAID VACATION AT RD 3/1 CMJ";
label variable PAYVAC42 "PAID VACATION AT RD 4/2 CMJ";
label variable PAYVAC53 "PAID VACATION AT RD 5/3 CMJ";
label variable SICPAY31 "PAID SICK LEAVE AT RD 3/1 CMJ";
label variable SICPAY42 "PAID SICK LEAVE AT RD 4/2 CMJ";
label variable SICPAY53 "PAID SICK LEAVE AT RD 5/3 CMJ";
label variable PAYDR31 "PAID LEAVE TO VISIT DR RD 3/1 CMJ";
label variable PAYDR42 "PAID LEAVE TO VISIT DR RD 4/2 CMJ";
label variable PAYDR53 "PAID LEAVE TO VISIT DR RD 5/3 CMJ";
label variable RETPLN31 "PENSION PLAN AT RD 3/1 CMJ";
label variable RETPLN42 "PENSION PLAN AT RD 4/2 CMJ";
label variable RETPLN53 "PENSION PLAN AT RD 5/3 CMJ";
label variable BSNTY31 "SOLE PROP, PARTNER, CORP, RD 3/1 CMJ";
label variable BSNTY42 "SOLE PROP, PARTNER, CORP, RD 4/2 CMJ";
label variable BSNTY53 "SOLE PROP, PARTNER, CORP, RD 5/3 CMJ";
label variable JOBORG31 "PRIV (PROFIT,NONPROFIT) GOV RD 3/1 CMJ";
label variable JOBORG42 "PRIV (PROFIT,NONPROFIT) GOV RD 4/2 CMJ";
label variable JOBORG53 "PRIV (PROFIT,NONPROFIT) GOV RD 5/3 CMJ";
label variable HELD31X "HEALTH INSUR HELD FROM RD 3/1 CMJ (ED)";
label variable HELD42X "HEALTH INSUR HELD FROM RD 4/2 CMJ (ED)";
label variable HELD53X "HEALTH INSUR HELD FROM RD 5/3 CMJ (ED)";
label variable OFFER31X "HEALTH INSUR OFFERED BY RD 3/1 CMJ (ED)";
label variable OFFER42X "HEALTH INSUR OFFERED BY RD 4/2 CMJ (ED)";
label variable OFFER53X "HEALTH INSUR OFFERED BY RD 5/3 CMJ (ED)";
label variable OFREMP31 "EMPLOYER OFFERS HEALTH INS RD 3/1 CMJ";
label variable OFREMP42 "EMPLOYER OFFERS HEALTH INS RD 4/2 CMJ";
label variable OFREMP53 "EMPLOYER OFFERS HEALTH INS RD 5/3 CMJ";
label variable YNOINS31 "WHY NOT ELIGIBLE HEALTH INS RD 3/1 CMJ";
label variable YNOINS42 "WHY NOT ELIGIBLE HEALTH INS RD 4/2 CMJ";
label variable YNOINS53 "WHY NOT ELIGIBLE HEALTH INS RD 5/3 CMJ";
label variable TRIJA04X "COVERED BY TRICARE IN JAN04 (ED)";
label variable TRIFE04X "COVERED BY TRICARE IN FEB04 (ED)";
label variable TRIMA04X "COVERED BY TRICARE IN MAR04 (ED)";
label variable TRIAP04X "COVERED BY TRICARE IN APR04 (ED)";
label variable TRIMY04X "COVERED BY TRICARE IN MAY04 (ED)";
label variable TRIJU04X "COVERED BY TRICARE IN JUN04 (ED)";
label variable TRIJL04X "COVERED BY TRICARE IN JUL04 (ED)";
label variable TRIAU04X "COVERED BY TRICARE IN AUG04 (ED)";
label variable TRISE04X "COVERED BY TRICARE IN SEP04 (ED)";
label variable TRIOC04X "COVERED BY TRICARE IN OCT04 (ED)";
label variable TRINO04X "COVERED BY TRICARE IN NOV04 (ED)";
label variable TRIDE04X "COVERED BY TRICARE IN DEC04 (ED)";
label variable MCRJA04 "COVERED BY MEDICARE IN JAN04";
label variable MCRFE04 "COVERED BY MEDICARE IN FEB04";
label variable MCRMA04 "COVERED BY MEDICARE IN MAR04";
label variable MCRAP04 "COVERED BY MEDICARE IN APR04";
label variable MCRMY04 "COVERED BY MEDICARE IN MAY04";
label variable MCRJU04 "COVERED BY MEDICARE IN JUN04";
label variable MCRJL04 "COVERED BY MEDICARE IN JUL04";
label variable MCRAU04 "COVERED BY MEDICARE IN AUG04";
label variable MCRSE04 "COVERED BY MEDICARE IN SEP04";
label variable MCROC04 "COVERED BY MEDICARE IN OCT04";
label variable MCRNO04 "COVERED BY MEDICARE IN NOV04";
label variable MCRDE04 "COVERED BY MEDICARE IN DEC04";
label variable MCRJA04X "COVERED BY MEDICARE IN JAN04 (ED)";
label variable MCRFE04X "COVERED BY MEDICARE IN FEB04 (ED)";
label variable MCRMA04X "COVERED BY MEDICARE IN MAR04 (ED)";
label variable MCRAP04X "COVERED BY MEDICARE IN APR04 (ED)";
label variable MCRMY04X "COVERED BY MEDICARE IN MAY04 (ED)";
label variable MCRJU04X "COVERED BY MEDICARE IN JUN04 (ED)";
label variable MCRJL04X "COVERED BY MEDICARE IN JUL04 (ED)";
label variable MCRAU04X "COVERED BY MEDICARE IN AUG04 (ED)";
label variable MCRSE04X "COVERED BY MEDICARE IN SEP04 (ED)";
label variable MCROC04X "COVERED BY MEDICARE IN OCT04 (ED)";
label variable MCRNO04X "COVERED BY MEDICARE IN NOV04 (ED)";
label variable MCRDE04X "COVERED BY MEDICARE IN DEC04 (ED)";
label variable MCDJA04 "COV BY MEDICAID OR SCHIP IN JAN04";
label variable MCDFE04 "COV BY MEDICAID OR SCHIP IN FEB04";
label variable MCDMA04 "COV BY MEDICAID OR SCHIP IN MAR04";
label variable MCDAP04 "COV BY MEDICAID OR SCHIP IN APR04";
label variable MCDMY04 "COV BY MEDICAID OR SCHIP IN MAY04";
label variable MCDJU04 "COV BY MEDICAID OR SCHIP IN JUN04";
label variable MCDJL04 "COV BY MEDICAID OR SCHIP IN JUL04";
label variable MCDAU04 "COV BY MEDICAID OR SCHIP IN AUG04";
label variable MCDSE04 "COV BY MEDICAID OR SCHIP IN SEP04";
label variable MCDOC04 "COV BY MEDICAID OR SCHIP IN OCT04";
label variable MCDNO04 "COV BY MEDICAID OR SCHIP IN NOV04";
label variable MCDDE04 "COV BY MEDICAID OR SCHIP IN DEC04";
label variable MCDJA04X "COV BY MEDICAID OR SCHIP IN JAN04 (ED)";
label variable MCDFE04X "COV BY MEDICAID OR SCHIP IN FEB04 (ED)";
label variable MCDMA04X "COV BY MEDICAID OR SCHIP IN MAR04 (ED)";
label variable MCDAP04X "COV BY MEDICAID OR SCHIP IN APR04 (ED)";
label variable MCDMY04X "COV BY MEDICAID OR SCHIP IN MAY04 (ED)";
label variable MCDJU04X "COV BY MEDICAID OR SCHIP IN JUN04 (ED)";
label variable MCDJL04X "COV BY MEDICAID OR SCHIP IN JUL04 (ED)";
label variable MCDAU04X "COV BY MEDICAID OR SCHIP IN AUG04 (ED)";
label variable MCDSE04X "COV BY MEDICAID OR SCHIP IN SEP04 (ED)";
label variable MCDOC04X "COV BY MEDICAID OR SCHIP IN OCT04 (ED)";
label variable MCDNO04X "COV BY MEDICAID OR SCHIP IN NOV04 (ED)";
label variable MCDDE04X "COV BY MEDICAID OR SCHIP IN DEC04 (ED)";
label variable OPAJA04 "COV BY OTHER PUBLIC A INS IN JAN04";
label variable OPAFE04 "COV BY OTHER PUBLIC A INS IN FEB04";
label variable OPAMA04 "COV BY OTHER PUBLIC A INS IN MAR04";
label variable OPAAP04 "COV BY OTHER PUBLIC A INS IN APR04";
label variable OPAMY04 "COV BY OTHER PUBLIC A INS IN MAY04";
label variable OPAJU04 "COV BY OTHER PUBLIC A INS IN JUN04";
label variable OPAJL04 "COV BY OTHER PUBLIC A INS IN JUL04";
label variable OPAAU04 "COV BY OTHER PUBLIC A INS IN AUG04";
label variable OPASE04 "COV BY OTHER PUBLIC A INS IN SEP04";
label variable OPAOC04 "COV BY OTHER PUBLIC A INS IN OCT04";
label variable OPANO04 "COV BY OTHER PUBLIC A INS IN NOV04";
label variable OPADE04 "COV BY OTHER PUBLIC A INS IN DEC04";
label variable OPBJA04 "COV BY OTHER PUBLIC B INS IN JAN04";
label variable OPBFE04 "COV BY OTHER PUBLIC B INS IN FEB04";
label variable OPBMA04 "COV BY OTHER PUBLIC B INS IN MAR04";
label variable OPBAP04 "COV BY OTHER PUBLIC B INS IN APR04";
label variable OPBMY04 "COV BY OTHER PUBLIC B INS IN MAY04";
label variable OPBJU04 "COV BY OTHER PUBLIC B INS IN JUN04";
label variable OPBJL04 "COV BY OTHER PUBLIC B INS IN JUL04";
label variable OPBAU04 "COV BY OTHER PUBLIC B INS IN AUG04";
label variable OPBSE04 "COV BY OTHER PUBLIC B INS IN SEP04";
label variable OPBOC04 "COV BY OTHER PUBLIC B INS IN OCT04";
label variable OPBNO04 "COV BY OTHER PUBLIC B INS IN NOV04";
label variable OPBDE04 "COV BY OTHER PUBLIC B INS IN DEC04";
label variable STAJA04 "COVERED BY OTHER STATE PROG IN JAN04";
label variable STAFE04 "COVERED BY OTHER STATE PROG IN FEB04";
label variable STAMA04 "COVERED BY OTHER STATE PROG IN MAR04";
label variable STAAP04 "COVERED BY OTHER STATE PROG IN APR04";
label variable STAMY04 "COVERED BY OTHER STATE PROG IN MAY04";
label variable STAJU04 "COVERED BY OTHER STATE PROG IN JUN04";
label variable STAJL04 "COVERED BY OTHER STATE PROG IN JUL04";
label variable STAAU04 "COVERED BY OTHER STATE PROG IN AUG04";
label variable STASE04 "COVERED BY OTHER STATE PROG IN SEP04";
label variable STAOC04 "COVERED BY OTHER STATE PROG IN OCT04";
label variable STANO04 "COVERED BY OTHER STATE PROG IN NOV04";
label variable STADE04 "COVERED BY OTHER STATE PROG IN DEC04";
label variable PUBJA04X "COVR BY ANY PUBLIC INS IN JAN04 (ED)";
label variable PUBFE04X "COVR BY ANY PUBLIC INS IN FEB04 (ED)";
label variable PUBMA04X "COVR BY ANY PUBLIC INS IN MAR04 (ED)";
label variable PUBAP04X "COVR BY ANY PUBLIC INS IN APR04 (ED)";
label variable PUBMY04X "COVR BY ANY PUBLIC INS IN MAY04 (ED)";
label variable PUBJU04X "COVR BY ANY PUBLIC INS IN JUN04 (ED)";
label variable PUBJL04X "COVR BY ANY PUBLIC INS IN JUL04 (ED)";
label variable PUBAU04X "COVR BY ANY PUBLIC INS IN AUG04 (ED)";
label variable PUBSE04X "COVR BY ANY PUBLIC INS IN SEP04 (ED)";
label variable PUBOC04X "COVR BY ANY PUBLIC INS IN OCT04 (ED)";
label variable PUBNO04X "COVR BY ANY PUBLIC INS IN NOV04 (ED)";
label variable PUBDE04X "COVR BY ANY PUBLIC INS IN DEC04 (ED)";
label variable PEGJA04 "COVERED BY EMPL UNION INS IN JAN04";
label variable PEGFE04 "COVERED BY EMPL UNION INS IN FEB04";
label variable PEGMA04 "COVERED BY EMPL UNION INS IN MAR04";
label variable PEGAP04 "COVERED BY EMPL UNION INS IN APR04";
label variable PEGMY04 "COVERED BY EMPL UNION INS IN MAY04";
label variable PEGJU04 "COVERED BY EMPL UNION INS IN JUN04";
label variable PEGJL04 "COVERED BY EMPL UNION INS IN JUL04";
label variable PEGAU04 "COVERED BY EMPL UNION INS IN AUG04";
label variable PEGSE04 "COVERED BY EMPL UNION INS IN SEP04";
label variable PEGOC04 "COVERED BY EMPL UNION INS IN OCT04";
label variable PEGNO04 "COVERED BY EMPL UNION INS IN NOV04";
label variable PEGDE04 "COVERED BY EMPL UNION INS IN DEC04";
label variable PDKJA04 "COVR BY PRIV INS (SOURCE UNKNWN) JAN04";
label variable PDKFE04 "COVR BY PRIV INS (SOURCE UNKNWN) FEB04";
label variable PDKMA04 "COVR BY PRIV INS (SOURCE UNKNWN) MAR04";
label variable PDKAP04 "COVR BY PRIV INS (SOURCE UNKNWN) APR04";
label variable PDKMY04 "COVR BY PRIV INS (SOURCE UNKNWN) MAY04";
label variable PDKJU04 "COVR BY PRIV INS (SOURCE UNKNWN) JUN04";
label variable PDKJL04 "COVR BY PRIV INS (SOURCE UNKNWN) JUL04";
label variable PDKAU04 "COVR BY PRIV INS (SOURCE UNKNWN) AUG04";
label variable PDKSE04 "COVR BY PRIV INS (SOURCE UNKNWN) SEP04";
label variable PDKOC04 "COVR BY PRIV INS (SOURCE UNKNWN) OCT04";
label variable PDKNO04 "COVR BY PRIV INS (SOURCE UNKNWN) NOV04";
label variable PDKDE04 "COVR BY PRIV INS (SOURCE UNKNWN) DEC04";
label variable PNGJA04 "COVERED BY NONGROUP INS IN JAN04";
label variable PNGFE04 "COVERED BY NONGROUP INS IN FEB04";
label variable PNGMA04 "COVERED BY NONGROUP INS IN MAR04";
label variable PNGAP04 "COVERED BY NONGROUP INS IN APR04";
label variable PNGMY04 "COVERED BY NONGROUP INS IN MAY04";
label variable PNGJU04 "COVERED BY NONGROUP INS IN JUN04";
label variable PNGJL04 "COVERED BY NONGROUP INS IN JUL04";
label variable PNGAU04 "COVERED BY NONGROUP INS IN AUG04";
label variable PNGSE04 "COVERED BY NONGROUP INS IN SEP04";
label variable PNGOC04 "COVERED BY NONGROUP INS IN OCT04";
label variable PNGNO04 "COVERED BY NONGROUP INS IN NOV04";
label variable PNGDE04 "COVERED BY NONGROUP INS IN DEC04";
label variable POGJA04 "COVERED BY OTHER GROUP INS IN JAN04";
label variable POGFE04 "COVERED BY OTHER GROUP INS IN FEB04";
label variable POGMA04 "COVERED BY OTHER GROUP INS IN MAR04";
label variable POGAP04 "COVERED BY OTHER GROUP INS IN APR04";
label variable POGMY04 "COVERED BY OTHER GROUP INS IN MAY04";
label variable POGJU04 "COVERED BY OTHER GROUP INS IN JUN04";
label variable POGJL04 "COVERED BY OTHER GROUP INS IN JUL04";
label variable POGAU04 "COVERED BY OTHER GROUP INS IN AUG04";
label variable POGSE04 "COVERED BY OTHER GROUP INS IN SEP04";
label variable POGOC04 "COVERED BY OTHER GROUP INS IN OCT04";
label variable POGNO04 "COVERED BY OTHER GROUP INS IN NOV04";
label variable POGDE04 "COVERED BY OTHER GROUP INS IN DEC04";
label variable PRSJA04 "COVERED BY SELF-EMP-1 INS IN JAN04";
label variable PRSFE04 "COVERED BY SELF-EMP-1 INS IN FEB04";
label variable PRSMA04 "COVERED BY SELF-EMP-1 INS IN MAR04";
label variable PRSAP04 "COVERED BY SELF-EMP-1 INS IN APR04";
label variable PRSMY04 "COVERED BY SELF-EMP-1 INS IN MAY04";
label variable PRSJU04 "COVERED BY SELF-EMP-1 INS IN JUN04";
label variable PRSJL04 "COVERED BY SELF-EMP-1 INS IN JUL04";
label variable PRSAU04 "COVERED BY SELF-EMP-1 INS IN AUG04";
label variable PRSSE04 "COVERED BY SELF-EMP-1 INS IN SEP04";
label variable PRSOC04 "COVERED BY SELF-EMP-1 INS IN OCT04";
label variable PRSNO04 "COVERED BY SELF-EMP-1 INS IN NOV04";
label variable PRSDE04 "COVERED BY SELF-EMP-1 INS IN DEC04";
label variable POUJA04 "COVERED BY HOLDER OUTSIDE OF RU IN JAN04";
label variable POUFE04 "COVERED BY HOLDER OUTSIDE OF RU IN FEB04";
label variable POUMA04 "COVERED BY HOLDER OUTSIDE OF RU IN MAR04";
label variable POUAP04 "COVERED BY HOLDER OUTSIDE OF RU IN APR04";
label variable POUMY04 "COVERED BY HOLDER OUTSIDE OF RU IN MAY04";
label variable POUJU04 "COVERED BY HOLDER OUTSIDE OF RU IN JUN04";
label variable POUJL04 "COVERED BY HOLDER OUTSIDE OF RU IN JUL04";
label variable POUAU04 "COVERED BY HOLDER OUTSIDE OF RU IN AUG04";
label variable POUSE04 "COVERED BY HOLDER OUTSIDE OF RU IN SEP04";
label variable POUOC04 "COVERED BY HOLDER OUTSIDE OF RU IN OCT04";
label variable POUNO04 "COVERED BY HOLDER OUTSIDE OF RU IN NOV04";
label variable POUDE04 "COVERED BY HOLDER OUTSIDE OF RU IN DEC04";
label variable PRIJA04 "COVERED BY PRIVATE INS IN JAN04";
label variable PRIFE04 "COVERED BY PRIVATE INS IN FEB04";
label variable PRIMA04 "COVERED BY PRIVATE INS IN MAR04";
label variable PRIAP04 "COVERED BY PRIVATE INS IN APR04";
label variable PRIMY04 "COVERED BY PRIVATE INS IN MAY04";
label variable PRIJU04 "COVERED BY PRIVATE INS IN JUN04";
label variable PRIJL04 "COVERED BY PRIVATE INS IN JUL04";
label variable PRIAU04 "COVERED BY PRIVATE INS IN AUG04";
label variable PRISE04 "COVERED BY PRIVATE INS IN SEP04";
label variable PRIOC04 "COVERED BY PRIVATE INS IN OCT04";
label variable PRINO04 "COVERED BY PRIVATE INS IN NOV04";
label variable PRIDE04 "COVERED BY PRIVATE INS IN DEC04";
label variable HPEJA04 "HOLDER OF EMPL UNION INS IN JAN04";
label variable HPEFE04 "HOLDER OF EMPL UNION INS IN FEB04";
label variable HPEMA04 "HOLDER OF EMPL UNION INS IN MAR04";
label variable HPEAP04 "HOLDER OF EMPL UNION INS IN APR04";
label variable HPEMY04 "HOLDER OF EMPL UNION INS IN MAY04";
label variable HPEJU04 "HOLDER OF EMPL UNION INS IN JUN04";
label variable HPEJL04 "HOLDER OF EMPL UNION INS IN JUL04";
label variable HPEAU04 "HOLDER OF EMPL UNION INS IN AUG04";
label variable HPESE04 "HOLDER OF EMPL UNION INS IN SEP04";
label variable HPEOC04 "HOLDER OF EMPL UNION INS IN OCT04";
label variable HPENO04 "HOLDER OF EMPL UNION INS IN NOV04";
label variable HPEDE04 "HOLDER OF EMPL UNION INS IN DEC04";
label variable HPDJA04 "HOLDER OF PRIV INS (SOURCE UNKNWN) JAN04";
label variable HPDFE04 "HOLDER OF PRIV INS (SOURCE UNKNWN) FEB04";
label variable HPDMA04 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAR04";
label variable HPDAP04 "HOLDER OF PRIV INS (SOURCE UNKNWN) APR04";
label variable HPDMY04 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAY04";
label variable HPDJU04 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUN04";
label variable HPDJL04 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUL04";
label variable HPDAU04 "HOLDER OF PRIV INS (SOURCE UNKNWN) AUG04";
label variable HPDSE04 "HOLDER OF PRIV INS (SOURCE UNKNWN) SEP04";
label variable HPDOC04 "HOLDER OF PRIV INS (SOURCE UNKNWN) OCT04";
label variable HPDNO04 "HOLDER OF PRIV INS (SOURCE UNKNWN) NOV04";
label variable HPDDE04 "HOLDER OF PRIV INS (SOURCE UNKNWN) DEC04";
label variable HPNJA04 "HOLDER OF NONGROUP INS IN JAN04";
label variable HPNFE04 "HOLDER OF NONGROUP INS IN FEB04";
label variable HPNMA04 "HOLDER OF NONGROUP INS IN MAR04";
label variable HPNAP04 "HOLDER OF NONGROUP INS IN APR04";
label variable HPNMY04 "HOLDER OF NONGROUP INS IN MAY04";
label variable HPNJU04 "HOLDER OF NONGROUP INS IN JUN04";
label variable HPNJL04 "HOLDER OF NONGROUP INS IN JUL04";
label variable HPNAU04 "HOLDER OF NONGROUP INS IN AUG04";
label variable HPNSE04 "HOLDER OF NONGROUP INS IN SEP04";
label variable HPNOC04 "HOLDER OF NONGROUP INS IN OCT04";
label variable HPNNO04 "HOLDER OF NONGROUP INS IN NOV04";
label variable HPNDE04 "HOLDER OF NONGROUP INS IN DEC04";
label variable HPOJA04 "HOLDER OF OTHER GROUP INS IN JAN04";
label variable HPOFE04 "HOLDER OF OTHER GROUP INS IN FEB04";
label variable HPOMA04 "HOLDER OF OTHER GROUP INS IN MAR04";
label variable HPOAP04 "HOLDER OF OTHER GROUP INS IN APR04";
label variable HPOMY04 "HOLDER OF OTHER GROUP INS IN MAY04";
label variable HPOJU04 "HOLDER OF OTHER GROUP INS IN JUN04";
label variable HPOJL04 "HOLDER OF OTHER GROUP INS IN JUL04";
label variable HPOAU04 "HOLDER OF OTHER GROUP INS IN AUG04";
label variable HPOSE04 "HOLDER OF OTHER GROUP INS IN SEP04";
label variable HPOOC04 "HOLDER OF OTHER GROUP INS IN OCT04";
label variable HPONO04 "HOLDER OF OTHER GROUP INS IN NOV04";
label variable HPODE04 "HOLDER OF OTHER GROUP INS IN DEC04";
label variable HPSJA04 "HOLDER OF SELF-EMP-1 INS IN JAN04";
label variable HPSFE04 "HOLDER OF SELF-EMP-1 INS IN FEB04";
label variable HPSMA04 "HOLDER OF SELF-EMP-1 INS IN MAR04";
label variable HPSAP04 "HOLDER OF SELF-EMP-1 INS IN APR04";
label variable HPSMY04 "HOLDER OF SELF-EMP-1 INS IN MAY04";
label variable HPSJU04 "HOLDER OF SELF-EMP-1 INS IN JUN04";
label variable HPSJL04 "HOLDER OF SELF-EMP-1 INS IN JUL04";
label variable HPSAU04 "HOLDER OF SELF-EMP-1 INS IN AUG04";
label variable HPSSE04 "HOLDER OF SELF-EMP-1 INS IN SEP04";
label variable HPSOC04 "HOLDER OF SELF-EMP-1 INS IN OCT04";
label variable HPSNO04 "HOLDER OF SELF-EMP-1 INS IN NOV04";
label variable HPSDE04 "HOLDER OF SELF-EMP-1 INS IN DEC04";
label variable HPRJA04 "HOLDER OF PRIVATE INSURANCE IN JAN04";
label variable HPRFE04 "HOLDER OF PRIVATE INSURANCE IN FEB04";
label variable HPRMA04 "HOLDER OF PRIVATE INSURANCE IN MAR04";
label variable HPRAP04 "HOLDER OF PRIVATE INSURANCE IN APR04";
label variable HPRMY04 "HOLDER OF PRIVATE INSURANCE IN MAY04";
label variable HPRJU04 "HOLDER OF PRIVATE INSURANCE IN JUN04";
label variable HPRJL04 "HOLDER OF PRIVATE INSURANCE IN JUL04";
label variable HPRAU04 "HOLDER OF PRIVATE INSURANCE IN AUG04";
label variable HPRSE04 "HOLDER OF PRIVATE INSURANCE IN SEP04";
label variable HPROC04 "HOLDER OF PRIVATE INSURANCE IN OCT04";
label variable HPRNO04 "HOLDER OF PRIVATE INSURANCE IN NOV04";
label variable HPRDE04 "HOLDER OF PRIVATE INSURANCE IN DEC04";
label variable INSJA04X "COVR BY HOSP/MED INS IN JAN04 (ED)";
label variable INSFE04X "COVR BY HOSP/MED INS IN FEB04 (ED)";
label variable INSMA04X "COVR BY HOSP/MED INS IN MAR04 (ED)";
label variable INSAP04X "COVR BY HOSP/MED INS IN APR04 (ED)";
label variable INSMY04X "COVR BY HOSP/MED INS IN MAY04 (ED)";
label variable INSJU04X "COVR BY HOSP/MED INS IN JUN04 (ED)";
label variable INSJL04X "COVR BY HOSP/MED INS IN JUL04 (ED)";
label variable INSAU04X "COVR BY HOSP/MED INS IN AUG04 (ED)";
label variable INSSE04X "COVR BY HOSP/MED INS IN SEP04 (ED)";
label variable INSOC04X "COVR BY HOSP/MED INS IN OCT04 (ED)";
label variable INSNO04X "COVR BY HOSP/MED INS IN NOV04 (ED)";
label variable INSDE04X "COVR BY HOSP/MED INS IN DEC04 (ED)";
label variable PRVEV04 "EVER HAVE PRIVATE INSURANCE DURING 04";
label variable TRIEV04 "EVER HAVE TRICARE DURING 04";
label variable MCREV04 "EVER HAVE MEDICARE DURING 04 (ED)";
label variable MCDEV04 "EVER HAVE MEDICAID/SCHIP DURING 04 (ED)";
label variable OPAEV04 "EVER HAVE OTHER PUBLIC A INS DURING 04";
label variable OPBEV04 "EVER HAVE OTHER PUBLIC B INS DURING 04";
label variable UNINS04 "UNINSURED ALL OF 04";
label variable INSCOV04 "HEALTH INSURANCE COVERAGE INDICATOR 04";
label variable TRIST31X "COVERED BY TRICARE STANDARD - R3/1";
label variable TRIST42X "COVERED BY TRICARE STANDARD - R4/2";
label variable TRIST04X "COVERED BY TRICARE STANDARD - 12/31/04";
label variable TRIPR31X "COVERED BY TRICARE PRIME - R3/1";
label variable TRIPR42X "COVERED BY TRICARE PRIME - R4/2";
label variable TRIPR04X "COVERED BY TRICARE PRIME - 12/31/04";
label variable TRIEX31X "COVERED BY TRICARE EXTRA - R3/1";
label variable TRIEX42X "COVERED BY TRICARE EXTRA - R4/2";
label variable TRIEX04X "COVERED BY TRICARE EXTRA - 12/31/04";
label variable TRILI31X "COVERED BY TRICARE FOR LIFE - R3/1";
label variable TRILI42X "COVERED BY TRICARE FOR LIFE - R4/2";
label variable TRILI04X "COVERED BY TRICARE FOR LIFE - 12/31/04";
label variable MCDHMO31 "COVERED BY MEDICAID OR SCHIP HMO - R3/1";
label variable MCDHMO42 "COVERED BY MEDICAID OR SCHIP HMO - R4/2";
label variable MCDHMO04 "COVRED BY MEDICAID OR SCHIP HMO-12/31/04";
label variable MCDMC31 "COV BY MCAID/SCHIP GATEKEEPER PLAN-R3/1";
label variable MCDMC42 "COV BY MCAID/SCHIP GATEKEEPER PLAN-R4/2";
label variable MCDMC04 "COV BY MCAID/SCHIP GTKEEPR PLAN-12/31/04";
label variable PRVHMO31 "COVERED BY PRIVATE HMO - R3/1";
label variable PRVHMO42 "COVERED BY PRIVATE HMO - R4/2";
label variable PRVHMO04 "COVERED BY PRIVATE HMO - 12/31/04";
label variable PRVMNC31 "COVERED BY PRIVATE GATEKEEPER PLAN-R3/1";
label variable PRVMNC42 "COVERED BY PRIVATE GATEKEEPER PLAN-R4/2";
label variable PRVMNC04 "COVERED BY PRIV GATEKEEPER PLAN-12/31/04";
label variable PRVDRL31 "COV BY PRIV PLAN W/DOCTOR LIST - R3/1";
label variable PRVDRL42 "COV BY PRIV PLAN W/DOCTOR LIST - R4/2";
label variable PRVDRL04 "COV BY PRIV PLAN W/DOCTOR LIST-12/31/04";
label variable PHMONP31 "COV BY HMO-PAYS NON-PLAN DR VISITS-R3/1";
label variable PHMONP42 "COV BY HMO-PAYS NON-PLAN DR VISITS-R4/2";
label variable PHMONP04 "COV BY HMO-PAYS NON-PLAN DRS - 12/31/04";
label variable PMNCNP31 "COV BY GATEKPR-PAYS NON-PLAN DRS-R3/1";
label variable PMNCNP42 "COV BY GATEKPR-PAYS NON-PLAN DRS-R4/2";
label variable PMNCNP04 "COV BY GATEKP-PAYS NON-PLAN DRS-12/31/04";
label variable PRDRNP31 "COV BY DR LIST-PAYS NON-PLAN DRS-R3/1";
label variable PRDRNP42 "COV BY DR LIST-PAYS NON-PLAN DRS-R4/2";
label variable PRDRNP04 "COV BY DR LIST-PAYS NON-PLAN DR-12/31/04";
label variable PREVCOVR "PER COV BY INS IN PREV 2 YRS-PANL 9 ONLY";
label variable COVRMM "MONTH MOST RECENTLY COVERED-PANEL 9 ONLY";
label variable COVRYY "YEAR MOST RECENTLY COVERED-PANEL 9 ONLY";
label variable WASESTB "WAS PREV INS BY EMPL OR UNION-PNL 9 ONLY";
label variable WASMCARE "WAS PREV INS BY MEDICARE-PANEL 9 ONLY";
label variable WASMCAID "WAS PREV INS BY MCAID/SCHIP-PANEL 9 ONLY";
label variable WASCHAMP "WAS PREV INS TRICARE/CHAMPVA-PANL 9 ONLY";
label variable WASVA "WAS PREV INS VA/MILITAR CARE-PANL 9 ONLY";
label variable WASPRIV "WAS PREV INS GRP/ASSOC/INS CO-PNL 9 ONLY";
label variable WASOTGOV "WAS PREV INS BY OTH GOV PRG-PANEL 9 ONLY";
label variable WASAFDC "WAS PREV INS BY PUBLIC AFDC-PANEL 9 ONLY";
label variable WASSSI "WAS PREV INS BY SSI PROGRAM-PANEL 9 ONLY";
label variable WASSTAT1 "WAS PREV INS BY STAT PROG 1-PANEL 9 ONLY";
label variable WASSTAT2 "WAS PREV INS BY STAT PROG 2-PANEL 9 ONLY";
label variable WASSTAT3 "WAS PREV INS BY STAT PROG 3-PANEL 9 ONLY";
label variable WASSTAT4 "WAS PREV INS BY STAT PROG 4-PANEL 9 ONLY";
label variable WASOTHER "WAS PREV INS BY OTH SOURCE-PANEL 9 ONLY";
label variable NOINSBEF "EVR WOUT HLTH INSR PREV YR-PANEL 9 ONLY";
label variable NOINSTM "# WKS/MON WOUT HLTH INS PRV YR-PNL 9 ONL";
label variable NOINUNIT "UNIT OF TIME WOUT HLTH INS-PANEL 9 ONLY";
label variable MORECOVR "COV BY MOR COMPR PL PREV 2 YR-PNL 9 ONLY";
label variable INSENDMM "MONTH MOST RECENTLY COVD-PANEL 9 ONLY";
label variable INSENDYY "YEAR MOST RECENTLY COVD-PANEL 9 ONLY";
label variable TRICR31X "COV BY TRICARE - R3/1 INT DT (ED)";
label variable TRICR42X "COV BY TRICARE - R4/2 INT DT (ED)";
label variable TRICR53X "COV BY TRICARE 12-31/R3 INT DT (ED)";
label variable TRICR04X "COV BY TRICARE - 12/31/04 (ED)";
label variable TRIAT31X "ANY TIME COV TRICARE - R3/1";
label variable TRIAT42X "ANY TIME COV TRICARE - R4/2";
label variable TRIAT53X "ANY TIME COV TRICARE - R5/3";
label variable TRIAT04X "ANY TIME COV TRICARE - 12/31/04";
label variable MCAID31 "COV BY MEDICAID OR SCHIP - R3/1 INT DT";
label variable MCAID42 "COV BY MEDICAID OR SCHIP - R4/2 INT DT";
label variable MCAID53 "COV BY MEDICAID OR SCHIP 12-31/R3 INT DT";
label variable MCAID04 "COV BY MEDICAID OR SCHIP - 12/31/04";
label variable MCAID31X "COV BY MEDICAID/SCHIP - R3/1 INT DT (ED)";
label variable MCAID42X "COV BY MEDICAID/SCHIP - R4/2 INT DT (ED)";
label variable MCAID53X "COV MEDICAID/SCHIP 12-31/R3 INT DT(ED)";
label variable MCAID04X "COV BY MEDICAID OR SCHIP - 12/31/04 (ED)";
label variable MCARE31 "COV BY MEDICARE - R3/1 INT DT";
label variable MCARE42 "COV BY MEDICARE - R4/2 INT DT";
label variable MCARE53 "COV BY MEDICARE 12-31/R3 INT DT";
label variable MCARE04 "COV BY MEDICARE - 12/31/04";
label variable MCARE31X "COV BY MEDICARE - R3/1 INT DT (ED)";
label variable MCARE42X "COV BY MEDICARE - R4/2 INT DT (ED)";
label variable MCARE53X "COV BY MEDICARE 12-31/R3 INT DT (ED)";
label variable MCARE04X "COV BY MEDICARE - 12/31/04 (ED)";
label variable MCDAT31X "ANY TIME COV MEDICAID OR SCHIP - R3/1";
label variable MCDAT42X "ANY TIME COV MEDICAID OR SCHIP - R4/2";
label variable MCDAT53X "ANY TIME COV MEDICAID OR SCHIP - R5/3";
label variable MCDAT04X "ANY TIME COV MEDICAID OR SCHIP-12/31/04";
label variable OTPAAT31 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R3/1";
label variable OTPAAT42 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R4/2";
label variable OTPAAT53 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R5/3";
label variable OTPAAT04 "ANY COV OT GOV MCAID/SCHIP HMO-12/31/04";
label variable OTPBAT31 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R3/1";
label variable OTPBAT42 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R4/2";
label variable OTPBAT53 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R5/3";
label variable OTPBAT04 "ANY CV OT GV NT MCAID/SCHIP HMO-12/31/04";
label variable OTPUBA31 "COV/PAY OTH GOV MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBA42 "COV/PAY OTH GOV MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBA53 "COV/PAY OTH GOV MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBA04 "COV/PAY OTH GOV MCAID/SCHIP HMO-12/31/04";
label variable OTPUBB31 "COV OTH GOV NOT MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBB42 "COV OTH GOV NOT MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBB53 "COV OTH GOV NOT MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBB04 "COV OTH GOV NOT MCAID/SCHIP HMO-12/31/04";
label variable PRIDK31 "COV BY PRIV INS (DK PLAN) - R3/1 INT";
label variable PRIDK42 "COV BY PRIV INS (DK PLAN) - R4/2 INT";
label variable PRIDK53 "COV BY PRIV INS (DK PLAN) 12-31/R3 INT";
label variable PRIDK04 "COV BY PRIV INS (DK PLAN) - 12/31/04";
label variable PRIEU31 "COV BY EMPL/UNION GRP INS - R3/1 INT DT";
label variable PRIEU42 "COV BY EMPL/UNION GRP INS - R4/2 INT DT";
label variable PRIEU53 "COV BY EMPL/UNION GRP INS 12-31/R3 INT";
label variable PRIEU04 "COV BY EMPL/UNION GRP INS - 12/31/04";
label variable PRING31 "COV BY NON-GROUP INS - R3/1 INT DT";
label variable PRING42 "COV BY NON-GROUP INS - R4/2 INT DT";
label variable PRING53 "COV BY NON-GROUP INS 12-31/R3 INT DT";
label variable PRING04 "COV BY NON-GROUP INS - 12/31/04";
label variable PRIOG31 "COV BY OTHER GROUP INS - R3/1 INT DT";
label variable PRIOG42 "COV BY OTHER GROUP INS - R4/2 INT DT";
label variable PRIOG53 "COV BY OTHER GROUP INS 12-31/R3 INT DT";
label variable PRIOG04 "COV BY OTHER GROUP INS - 12/31/04";
label variable PRIS31 "COV BY SELF-EMP-1 INS - R3/1 INT DT";
label variable PRIS42 "COV BY SELF-EMP-1 INS - R4/2 INT DT";
label variable PRIS53 "COV BY SELF-EMP-1 INS 12-31/R3 INT DT";
label variable PRIS04 "COV BY SELF-EMP-1 INS - 12/31/04";
label variable PRIV31 "COV BY PRIV HLTH INS - R3/1 INT DATE";
label variable PRIV42 "COV BY PRIV HLTH INS - R4/2 INT DATE";
label variable PRIV53 "COV BY PRIV HLTH INS 12-31/R3 INT DATE";
label variable PRIV04 "COV BY PRIV HLTH INS - 12/31/04";
label variable PRIVAT31 "ANY TIME COV PRIVATE INS - R3/1";
label variable PRIVAT42 "ANY TIME COV PRIVATE INS - R4/2";
label variable PRIVAT53 "ANY TIME COV PRIVATE INS - R5/3";
label variable PRIVAT04 "ANY TIME COV PRIVATE INS - 12/31/04";
label variable PROUT31 "COV BY SOMEONE OUT OF RU - R3/1 INT";
label variable PROUT42 "COV BY SOMEONE OUT OF RU - R4/2 INT";
label variable PROUT53 "COV BY SOMEONE OUT OF RU 12-31/R3 INT DT";
label variable PROUT04 "COV BY SOMEONE OUT OF RU - 12/31/04";
label variable PUB31X "COV BY PUBLIC INS - R3/1 INT DT (ED)";
label variable PUB42X "COV BY PUBLIC INS - R4/2 INT DT (ED)";
label variable PUB53X "COV BY PUBLIC INS 12-31/R3 INT DT (ED)";
label variable PUB04X "COV BY PUBLIC INS - 12/31/04 (ED)";
label variable PUBAT31X "ANY TIME COV BY PUBLIC - R3/1";
label variable PUBAT42X "ANY TIME COV BY PUBLIC - R4/2";
label variable PUBAT53X "ANY TIME COV BY PUBLIC - R5/3";
label variable PUBAT04X "ANY TIME COV BY PUBLIC - 12/31/04";
label variable INS31X "INSURED - R3/1 INT DATE (ED)";
label variable INS42X "INSURED - R4/2 INT DATE (ED)";
label variable INS53X "INSURED 12-31/R3 INT DATE (ED)";
label variable INS04X "INSURED - 12/31/04 (ED)";
label variable INSAT31X "INSURED ANY TIME IN R3/1";
label variable INSAT42X "INSURED ANY TIME IN R4/2";
label variable INSAT53X "INSURED ANY TIME IN R5/3";
label variable INSAT04X "INSURED ANY TIME IN R3 UNTIL 12/31/04/R5";
label variable STAPR31 "COV BY STATE-SPEC PROG - R3/1 INT DT";
label variable STAPR42 "COV BY STATE-SPEC PROG - R4/2 INT DT";
label variable STAPR53 "COV BY STATE-SPEC PROG 12-31/R3 INT DT";
label variable STAPR04 "COV BY STATE-SPEC PROG - 12/31/04";
label variable STPRAT31 "ANY TIME COVERAGE BY STATE INS - R3/1";
label variable STPRAT42 "ANY TIME COVERAGE BY STATE INS - R4/2";
label variable STPRAT53 "ANY TIME COVERAGE BY STATE INS - R5/3";
label variable STPRAT04 "ANY TIME COV BY STATE INS - 12/31/04";
label variable EVRUNINS "EVER UNINSURED IN 04 USING PRIV/PUBX";
label variable EVRUNAT "EVER UNINSURED IN 04 USING PRIVAT/PUBATX";
label variable DENTIN31 "DENTAL INSURANCE - RD 3/1";
label variable DENTIN42 "DENTAL INSURANCE - RD 4/2";
label variable DENTIN53 "DENTAL INSURANCE - RD 5/3";
label variable PMEDIN31 "PRESCRIPTION DRUG INSURANCE - RD 3/1";
label variable PMEDIN42 "PRESCRIPTION DRUG INSURANCE - RD 4/2";
label variable PMEDIN53 "PRESCRIPTION DRUG INSURANCE - RD 5/3";
label variable GDCPBM42 "MCAID/O PUB: PROB GETTING PERS DOC-R4/2";
label variable APRTRM42 "MCAID/O PUB: NEED APPRVL 4 TREATMNT-R4/2";
label variable APRDLM42 "MCAID/O PUB: DELAY WAITING 4 APPRVL-R4/2";
label variable LKINFM42 "MCAID/O PUB: INFO ON HOW PLAN WORKS-R4/2";
label variable PBINFM42 "MCAID/O PUB: PROBLEM FINDING INFO-R4/2";
label variable CSTSVM42 "MCAID/O PUB: CALL CUSTOMER SERVICE-R4/2";
label variable PBSVCM42 "MCAID/O PUB: PROB GET HELP FR CSRVC-R4/2";
label variable PPRWKM42 "MCAID/O PUB:FILL OUT PAPERWRK 4 PLN-R4/2";
label variable PBPWKM42 "MCAID/O PUB: PROB W PLAN PAPERWORK-R4/2";
label variable RTPLNM42 "MCAID/O PUB: RATE EXPERIENCE W PLAN-R4/2";
label variable GDCPBT42 "TRICARE: PROB GETTING PERS DOC-R4/2";
label variable APRTRT42 "TRICARE: NEED APPRVL 4 TREATMNT-R4/2";
label variable APRDLT42 "TRICARE: DELAY WAITING 4 APPRVL-R4/2";
label variable LKINFT42 "TRICARE: INFO ON HOW PLAN WORKS-R4/2";
label variable PBINFT42 "TRICARE: PROBLEM FINDING INFO-R4/2";
label variable CSTSVT42 "TRICARE: CALL CUSTOMER SERVICE-R4/2";
label variable PBSVCT42 "TRICARE: PROB GET HELP FR CST SRVC-R4/2";
label variable PPRWKT42 "TRICARE: FILL OUT PAPERWRK 4 PLN-R4/2";
label variable PBPWKT42 "TRICARE: PROB W PLAN PAPERWORK-R4/2";
label variable RTPLNT42 "TRICARE: RATE EXPERIENCE W PLAN-R4/2";
label variable TOTTCH04 "TOTAL HEALTH CARE CHARGES 04, EXCL RX";
label variable TOTEXP04 "TOTAL HEALTH CARE EXP 04";
label variable TOTSLF04 "TOTAL AMT PAID BY SELF/FAMILY 04";
label variable TOTMCR04 "TOTAL AMT PAID BY MEDICARE 04";
label variable TOTMCD04 "TOTAL AMT PAID BY MEDICAID 04";
label variable TOTPRV04 "TOTAL AMT PAID BY PRIVATE INS 04";
label variable TOTVA04 "TOTAL AMT PAID BY VA 04";
label variable TOTTRI04 "TOTAL AMT PAID BY TRICARE 04";
label variable TOTOFD04 "TOTAL AMT PAID BY OTHER FEDERAL 04";
label variable TOTSTL04 "TOTAL AMT PAID BY OTH ST/LOCAL 04";
label variable TOTWCP04 "TOTAL AMT PAID BY WORKERS COMP 04";
label variable TOTOPR04 "TOTAL AMT PAID BY OTHER PRIVATE 04";
label variable TOTOPU04 "TOTAL AMT PAID BY OTHER PUBLIC 04";
label variable TOTOSR04 "TOTAL AMT PAID BY OTHER SOURCES 04";
label variable OBTOTV04 "# OFFICE-BASED PROVIDER VISITS 04";
label variable OBVTCH04 "OFFICE-BASED PROVIDER VISIT CHARGES 04";
label variable OBVEXP04 "TOTAL OFFICE-BASED EXP 04";
label variable OBVSLF04 "ALL OFFICE VISITS -SELF/FAMILY AMT 04";
label variable OBVMCR04 "ALL OFFICE VISITS -MEDICARE AMT 04";
label variable OBVMCD04 "ALL OFFICE VISITS -MEDICAID AMT 04";
label variable OBVPRV04 "ALL OFFICE VISITS -PRIVATE INS AMT 04";
label variable OBVVA04 "ALL OFFICE VISITS-VA AMT 04";
label variable OBVTRI04 "ALL OFFICE VISITS-TRICARE AMT 04";
label variable OBVOFD04 "ALL OFFICE VISITS-OTHER FEDERAL AMT 04";
label variable OBVSTL04 "ALL OFFICE VISITS-OTH ST/LOCAL AMT 04";
label variable OBVWCP04 "ALL OFFICE VISITS -WORKERS COMP AMT 04";
label variable OBVOPR04 "ALL OFFICE VISITS - OTH PRIVATE AMT 04";
label variable OBVOPU04 "ALL OFFICE VISITS - OTH PUBLIC AMT 04";
label variable OBVOSR04 "ALL OFF VSTS - OTH UNCLASS SRCE AMT 04";
label variable OBDRV04 "# OFFICE-BASED PHYSICIAN VISITS 04";
label variable OBDTCH04 "OFFICE-BASED PHYSICIAN VISIT CHARGES 04";
label variable OBDEXP04 "TOTAL OFF-BASED DR EXP 04";
label variable OBDSLF04 "DR OFFICE VISITS -SELF/FAMILY AMT 04";
label variable OBDMCR04 "DR OFFICE VISITS -MEDICARE AMT 04";
label variable OBDMCD04 "DR OFFICE VISITS -MEDICAID AMT 04";
label variable OBDPRV04 "DR OFFICE VISITS -PRIVATE INS AMT 04";
label variable OBDVA04 "DR OFFICE VISITS -VA AMT 04";
label variable OBDTRI04 "DR OFFICE VISITS -TRICARE AMT 04";
label variable OBDOFD04 "DR OFFICE VISITS -OTHER FEDERAL AMT 04";
label variable OBDSTL04 "DR OFFICE VISITS -OTH ST/LOCAL AMT 04";
label variable OBDWCP04 "DR OFFICE VISITS -WORKERS COMP AMT 04";
label variable OBDOPR04 "DR OFFICE VISITS - OTH PRIVATE AMT 04";
label variable OBDOPU04 "DR OFFICE VISITS - OTH PUBLIC AMT 04";
label variable OBDOSR04 "DR OFF VSTS - OTH UNCLASS SRCE AMT 04";
label variable OBOTHV04 "# OFFICE-BASED NON-PHYSICAN VISITS 04";
label variable OBOTCH04 "OFFICE-BASED NON-DR VISIT CHARGES 04";
label variable OBOEXP04 "TOTAL OFF-BASED NON-DR EXP 04";
label variable OBOSLF04 "NON-DR OFF VISTS -SELF/FAMILY AMT 04";
label variable OBOMCR04 "NON-DR OFF VISTS -MEDICARE AMT 04";
label variable OBOMCD04 "NON-DR OFF VISTS -MEDICAID AMT 04";
label variable OBOPRV04 "NON-DR OFF VISTS -PRIVATE INS AMT 04";
label variable OBOVA04 "NON-DR OFF VISTS -VA AMT 04";
label variable OBOTRI04 "NON-DR OFF VISTS -TRICARE AMT 04";
label variable OBOOFD04 "NON-DR OFF VISTS -OTHER FEDERAL AMT 04";
label variable OBOSTL04 "NON-DR OFF VISTS -OTH ST/LOCAL AMT 04";
label variable OBOWCP04 "NON-DR OFF VISTS -WORKERS COMP AMT 04";
label variable OBOOPR04 "NON-DR OFF VISTS - OTH PRIVATE AMT 04";
label variable OBOOPU04 "NON-DR OFF VISTS - OTH PUBLIC AMT 04";
label variable OBOOSR04 "NON-DR OF VSTS - OTH UNCLASS SRCE AMT 04";
label variable OBCHIR04 "# OFFICE-BASED CHIROPRACTOR VISITS 04";
label variable OBCTCH04 "OFFICE-BASED CHIRO VISIT CHARGES 04";
label variable OBCEXP04 "TOTAL OFF-BASED CHIRO EXP 04";
label variable OBCSLF04 "CHIRO OFF VISITS -SELF/FAMILY AMT 04";
label variable OBCMCR04 "CHIRO OFF VISITS -MEDICARE AMT 04";
label variable OBCMCD04 "CHIRO OFF VISITS -MEDICAID AMT 04";
label variable OBCPRV04 "CHIRO OFF VISITS -PRIVATE INS AMT 04";
label variable OBCVA04 "CHIRO OFF VISITS -VA AMT 04";
label variable OBCTRI04 "CHIRO OFF VISITS -TRICARE AMT 04";
label variable OBCOFD04 "CHIRO OFF VISITS -OTHER FEDERAL AMT 04";
label variable OBCSTL04 "CHIRO OFF VISITS -OTH ST/LOCAL AMT 04";
label variable OBCWCP04 "CHIRO OFF VISITS -WORKERS COMP AMT 04";
label variable OBCOPR04 "CHIRO OFF VISTS - OTHR PRIVATE AMT 04";
label variable OBCOPU04 "CHIRO OFF VISTS - OTHR PUBLIC AMT 04";
label variable OBCOSR04 "CHIRO OF VSTS - OTHR UNCLASS SRCE AMT 04";
label variable OBNURS04 "# OFF-BASED NURSE/PRACTITIONER VISITS 04";
label variable OBNTCH04 "OFFICE-BASED NURSE/PRAC VISIT CHARGES 04";
label variable OBNEXP04 "TOTAL OFF-BASED NURSE/PRAC 04";
label variable OBNSLF04 "NURSE/PRAC OFF VISITS-SELF/FAMILY AMT 04";
label variable OBNMCR04 "NURSE/PRAC OFF VISITS -MEDICARE AMT 04";
label variable OBNMCD04 "NURSE/PRAC OFF VSTS -MEDICAID AMT 04";
label variable OBNPRV04 "NURSE/PRAC OFF VSTS -PRIVATE INS AMT 04";
label variable OBNVA04 "NURSE/PRAC OFF VSTS -VA AMT 04";
label variable OBNTRI04 "NURSE/PRAC OFF VSTS -TRICARE AMT 04";
label variable OBNOFD04 "NURSE/PRAC OFF VSTS-OTHER FEDERAL AMT 04";
label variable OBNSTL04 "NURSE/PRAC OFF VSTS -OTH ST/LOCAL AMT 04";
label variable OBNWCP04 "NURSE/PRAC OFF VSTS -WORKERS COMP AMT 04";
label variable OBNOPR04 "NURSE/PRAC OFF VSTS - OTH PRIVATE AMT 04";
label variable OBNOPU04 "NURSE/PRAC OFF VSTS - OTH PUBLIC AMT 04";
label variable OBNOSR04 "NRS/PR OF VSTS - OTH UNCLASS SRCE AMT 04";
label variable OBOPTO04 "# OFF-BASED OPTOMETRIST VISITS 04";
label variable OBETCH04 "OFFICE-BASED OPTOMTRIST VISIT CHARGES 04";
label variable OBEEXP04 "TOTAL OFF-BASED OPOTMETRIST EXP 04";
label variable OBESLF04 "OPTOMETRIST OFF VSTS -SELF/FAMILY AMT 04";
label variable OBEMCR04 "OPTOMETRIST OFF VSTS -MEDICARE AMT 04";
label variable OBEMCD04 "OPTOMETRIST OFF VSTS -MEDICAID AMT 04";
label variable OBEPRV04 "OPTOMETRIST OFF VSTS -PRIVATE INS AMT 04";
label variable OBEVA04 "OPTOMETRIST OFF VSTS -VA AMT 04";
label variable OBETRI04 "OPTOMETRIST OFF VSTS -TRICARE AMT 04";
label variable OBEOFD04 "OPTOMETRIST OFF VSTS-OTH FEDERAL AMT 04";
label variable OBESTL04 "OPTOMETRIST OFF VSTS -OTH ST/LOCL AMT 04";
label variable OBEWCP04 "OPTOMETRIST OFF VSTS-WORKERS COMP AMT 04";
label variable OBEOPR04 "OPTOMETRIST OFF VSTS -OTH PRIVATE AMT 04";
label variable OBEOPU04 "OPTOMETRIST OFF VSTS -OTH PUBLIC AMT 04";
label variable OBEOSR04 "OPTOM OF VSTS - OTH UNCLASS SRCE AMT 04";
label variable OBASST04 "# OFF-BASED PHYSICIAN ASSIST VISITS 04";
label variable OBATCH04 "OFFICE-BASED PHYS ASST VISIT CHARGES 04";
label variable OBAEXP04 "TOTAL OFF-BASED PHYS ASS T EXP 04";
label variable OBASLF04 "PHYS ASS T OFF VSTS -SELF/FAMILY AMT 04";
label variable OBAMCR04 "PHYS ASS T OFF VSTS -MEDICARE AMT 04";
label variable OBAMCD04 "PHYS ASS T OFF VSTS -MEDICAID AMT 04";
label variable OBAPRV04 "PHYS ASS T OFF VSTS -PRIVATE INS AMT 04";
label variable OBAVA04 "PHYS ASS T OFF VSTS -VA AMT 04";
label variable OBATRI04 "PHYS ASS T OFF VSTS -TRICARE AMT 04";
label variable OBAOFD04 "PHYS ASS T OFF VSTS -OTHER FED AMT 04";
label variable OBASTL04 "PHYS ASS T OFF VSTS -OTH ST/LOCL AMT 04";
label variable OBAWCP04 "PHYS ASS T OFF VSTS-WORKERS COMP AMT 04";
label variable OBAOPR04 "PHYS ASS T OFF VSTS - OTH PRIVATE AMT 04";
label variable OBAOPU04 "PHYS ASS T OFF VSTS - OTH PUBLIC AMT 04";
label variable OBAOSR04 "P A OFF VSTS - OTH UNCLASS SRCE AMT 04";
label variable OBTHER04 "# OFF-BASED PT/OT VISITS 04";
label variable OBTTCH04 "OFFICE-BASED PT/OC VISIT CHARGES 04";
label variable OBTEXP04 "TOT OFF-BASED PT EXP 04";
label variable OBTSLF04 "PT/OT OFF VISITS -SELF/FAMILY AMT 04";
label variable OBTMCR04 "PT/OT OFF VISITS -MEDICARE AMT 04";
label variable OBTMCD04 "PT/OT OFF VISITS -MEDICAID AMT 04";
label variable OBTPRV04 "PT/OT OFF VISITS -PRIVATE INS AMT 04";
label variable OBTVA04 "PT/OT OFF VISITS -VA AMT 04";
label variable OBTTRI04 "PT/OT OFF VISITS -TRICARE AMT 04";
label variable OBTOFD04 "PT/OT OFF VISITS -OTHER FED AMT 04";
label variable OBTSTL04 "PT/OT OFF VISITS -OTH ST/LOCL AMT 04";
label variable OBTWCP04 "PT/OT OFF VISITS -WORKERS COMP AMT 04";
label variable OBTOPR04 "PT/OT OFF VISITS - OTH PRIVATE AMT 04";
label variable OBTOPU04 "PT/OT OFF VISITS - OTH PUBLIC AMT 04";
label variable OBTOSR04 "PT/OT OF VSTS-OTH UNCLASS SRCE AMT 04";
label variable OPTOTV04 "# OUTPATIENT DEPT PROVIDER VISITS 04";
label variable OPFTCH04 "OPD PROVIDER VISIT CHARGES - FAC 04";
label variable OPFEXP04 "TOTAL OUTPATIENT FACILITY EXP 04";
label variable OPFSLF04 "ALL OPD VISITS-SELF/FAMILY AMT-FAC 04";
label variable OPFMCR04 "ALL OPD VISITS-MEDICARE AMT-FAC 04";
label variable OPFMCD04 "ALL OPD VISITS-MEDICAID AMT-FAC 04";
label variable OPFPRV04 "ALL OPD VISITS-PRIV INS AMT-FAC 04";
label variable OPFVA04 "ALL OPD VISITS-VA AMT-FAC 04";
label variable OPFTRI04 "ALL OPD VISITS-TRICARE AMT-FAC 04";
label variable OPFOFD04 "ALL OPD VISITS-OTHER FED AMT-FAC 04";
label variable OPFSTL04 "ALL OPD VISITS-OTH ST/LOCAL AMT-FAC 04";
label variable OPFWCP04 "ALL OPD VISITS-WORKERS COMP AMT-FAC 04";
label variable OPFOPR04 "ALL OPD VISITS - OTH PRIVATE AMT-FAC 04";
label variable OPFOPU04 "ALL OPD VISITS - OTH PUBLIC AMT-FAC 04";
label variable OPFOSR04 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-FAC 04";
label variable OPDEXP04 "TOTAL OUTPATIENT PROVIDER EXP 04";
label variable OPDTCH04 "OPD PROVIDER VISIT CHARGES - DR 04";
label variable OPDSLF04 "ALL OPD VISITS-SELF/FAMILY AMT-DR 04";
label variable OPDMCR04 "ALL OPD VISITS-MEDICARE AMT -DR 04";
label variable OPDMCD04 "ALL OPD VISITS-MEDICAID AMT -DR 04";
label variable OPDPRV04 "ALL OPD VISITS-PRIV INS AMT-DR 04";
label variable OPDVA04 "ALL OPD VISITS-VA AMT-DR 04";
label variable OPDTRI04 "ALL OPD VISITS-TRICARE AMT-DR 04";
label variable OPDOFD04 "ALL OPD VISITS-OTHER FED AMT-DR 04";
label variable OPDSTL04 "ALL OPD VISITS-OTH ST/LOCAL AMT-DR 04";
label variable OPDWCP04 "ALL OPD VISITS-WORKERS COMP AMT-DR 04";
label variable OPDOPR04 "ALL OPD VISITS - OTH PRIVATE AMT-DR 04";
label variable OPDOPU04 "ALL OPD VISITS-OTH PUBLIC AMT-DR 04";
label variable OPDOSR04 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-DR 04";
label variable OPDRV04 "# OUTPATIENT DEPT PHYSICIAN VISITS 04";
label variable OPVTCH04 "OPD PHYSICIAN VISIT CHARGES - FAC 04";
label variable OPVEXP04 "TOTAL OUTPATIENT PHYSICIAN - FAC EXP 04";
label variable OPVSLF04 "OPD DR VISITS-SELF/FAMILY AMT-FAC 04";
label variable OPVMCR04 "OPD DR VISITS-MEDICARE AMT-FAC 04";
label variable OPVMCD04 "OPD DR VISITS-MEDICAID AMT-FAC 04";
label variable OPVPRV04 "OPD DR VISITS-PRIV INS AMT-FAC 04";
label variable OPVVA04 "OPD DR VISITS-VA AMT-FAC 04";
label variable OPVTRI04 "OPD DR VISITS-TRICARE AMT-FAC 04";
label variable OPVOFD04 "OPD DR VISITS-OTHER FED AMT-FAC 04";
label variable OPVSTL04 "OPD DR VISITS-OTH ST/LOCAL AMT-FAC 04";
label variable OPVWCP04 "OPD DR VISITS-WORKERS COMP AMT-FAC 04";
label variable OPVOPR04 "OPD DR VISITS - OTH PRIVATE AMT-FAC 04";
label variable OPVOPU04 "OPD DR VISITS-OTH PUBLIC AMT-FAC 04";
label variable OPVOSR04 "OPD DR VSTS-OTH UNCLASS SRCE AMT-FAC 04";
label variable OPSEXP04 "TOTAL OUTPATIENT PHYSICIAN - DR EXP 04";
label variable OPSTCH04 "OPD PHYSICIAN VISIT CHARGES - DR 04";
label variable OPSSLF04 "OPD DR VISITS-SELF/FAMILY AMT-DR 04";
label variable OPSMCR04 "OPD DR VISITS-MEDICARE AMT-DR 04";
label variable OPSMCD04 "OPD DR VISITS-MEDICAID AMT-DR 04";
label variable OPSPRV04 "OPD DR VISITS-PRIV INS AMT-DR 04";
label variable OPSVA04 "OPD DR VISITS-VA AMT-DR 04";
label variable OPSTRI04 "OPD DR VISITS-TRICARE AMT-DR 04";
label variable OPSOFD04 "OPD DR VISITS-OTHER FED AMT-DR 04";
label variable OPSSTL04 "OPD DR VISITS-OTH ST/LOCAL AMT-DR 04";
label variable OPSWCP04 "OPD DR VISITS-WORKERS COMP AMT-DR 04";
label variable OPSOPR04 "OPD DR VISITS - OTH PRIVATE AMT-DR 04";
label variable OPSOPU04 "OPD DR VISITS-OTH PUBLIC AMT-DR 04";
label variable OPSOSR04 "OPD DR VSTS-OTH UNCLASS SRCE AMT-DR 04";
label variable OPOTHV04 "# OUTPATIENT DEPT NON-DR VISITS 04";
label variable OPOTCH04 "OPD NON-PHYS VISIT CHARGES - FAC 04";
label variable OPOEXP04 "TOTAL OUTPATIENT NON-DR - FAC EXP 04";
label variable OPOSLF04 "OPD NON-DR VISITS-SELF/FAM AMT-FAC 04";
label variable OPOMCR04 "OPD NON-DR VISITS-MEDICARE AMT-FAC 04";
label variable OPOMCD04 "OPD NON-DR VISITS-MEDICAID AMT-FAC 04";
label variable OPOPRV04 "OPD NON-DR VISITS-PRIV INS AMT-FAC 04";
label variable OPOVA04 "OPD NON-DR VISITS-VA AMT-FAC 04";
label variable OPOTRI04 "OPD NON-DR VISITS-TRICARE AMT-FAC 04";
label variable OPOOFD04 "OPD NON-DR VISITS-OTHER FED AMT-FAC 04";
label variable OPOSTL04 "OPD NON-DR VISITS-OTH ST/LOC AMT-FAC 04";
label variable OPOWCP04 "OPD NON-DR VISITS-WRKRS COMP AMT-FAC 04";
label variable OPOOPR04 "OPD NON-DR VISITS-OTH PRIVATE AMT-FAC 04";
label variable OPOOPU04 "OPD NON-DR VISITS-OTH PUBLIC AMT-FAC 04";
label variable OPOOSR04 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-FAC 04";
label variable OPPEXP04 "TOTAL OUTPATIENT NON-DR - DR EXP 04";
label variable OPPTCH04 "OPD NON-PHYS VISIT CHARGES - DR 04";
label variable OPPSLF04 "OPD NON-DR VISITS-SELF/FAM AMT-DR 04";
label variable OPPMCR04 "OPD NON-DR VISITS-MEDICARE AMT-DR 04";
label variable OPPMCD04 "OPD NON-DR VISITS-MEDICAID AMT-DR 04";
label variable OPPPRV04 "OPD NON-DR VISITS-PRIV INS AMT-DR 04";
label variable OPPVA04 "OPD NON-DR VISITS-VA AMT-DR 04";
label variable OPPTRI04 "OPD NON-DR VISITS-TRICARE AMT-DR 04";
label variable OPPOFD04 "OPD NON-DR VISITS-OTHER FED AMT-DR 04";
label variable OPPSTL04 "OPD NON-DR VISITS-OTH ST/LOC AMT-DR 04";
label variable OPPWCP04 "OPD NON-DR VISITS-WRKRS COMP AMT-DR 04";
label variable OPPOPR04 "OPD NON-DR VISITS-OTH PRIVATE AMT-DR 04";
label variable OPPOPU04 "OPD NON-DR VISITS-OTH PUBLIC AMT-DR 04";
label variable OPPOSR04 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-DR 04";
label variable AMCHIR04 "# CHIROPRACTR VSTS (OFF+OUTPAT), 2004";
label variable AMCTCH04 "CHIRO AMBULATORY VISIT CHARGES 04";
label variable AMCEXP04 "TOTL AMBULTRY (OB+OP) CHIRO EXP 04";
label variable AMCSLF04 "CHIRO AMB VISITS -SELF/FAMILY AMT 04";
label variable AMCMCR04 "CHIRO AMB VISITS -MEDICARE AMT 04";
label variable AMCMCD04 "CHIRO AMB VISITS -MEDICAID AMT 04";
label variable AMCPRV04 "CHIRO AMB VISITS -PRIVATE INS AMT 04";
label variable AMCVA04 "CHIRO AMB VISITS -VA AMT 04";
label variable AMCTRI04 "CHIRO AMB VISITS-TRICARE AMT 04";
label variable AMCOFD04 "CHIRO AMB VISITS -OTHER FEDERAL AMT 04";
label variable AMCSTL04 "CHIRO AMB VISITS -OTH ST/LOCAL AMT 04";
label variable AMCWCP04 "CHIRO AMB VISITS-WORKERS COMP AMT 04";
label variable AMCOPR04 "CHIRO AMB VISITS - OTH PRIVATE AMT 04";
label variable AMCOPU04 "CHIRO AMB VISITS - OTH PUBLIC AMT 04";
label variable AMCOSR04 "CHIR AMB VSTS - OTH UNCLASS SRCE AMT 04";
label variable AMNURS04 "# AMB NURSE/PRCTITIONR VSTS(OB+OP) 04";
label variable AMNTCH04 "NRS/PRAC AMBULATORY VISIT CHARGES 04";
label variable AMNEXP04 "TOTL AMBULTRY (OB+OP) NURSE/PRAC EXP 04";
label variable AMNSLF04 "NRS/PRAC AMB VSTS -SELF/FAMILY AMT 04";
label variable AMNMCR04 "NRS/PRAC AMB VSTS -MEDICARE AMT 04";
label variable AMNMCD04 "NRS/PRAC AMB VSTS -MEDICAID AMT 04";
label variable AMNPRV04 "NRS/PRAC AMB VSTS -PRIV INS AMT 04";
label variable AMNVA04 "NRS/PRAC AMB VSTS-VA AMT 04";
label variable AMNTRI04 "NRS/PRAC AMB VSTS-TRICARE AMT 04";
label variable AMNOFD04 "NRS/PRAC AMB VSTS-OTHER FEDERAL AMT 04";
label variable AMNSTL04 "NRS/PRAC AMB VSTS-OTH ST/LOCAL AMT 04";
label variable AMNWCP04 "NRS/PRAC AMB VSTS-WORKERS COMP AMT 04";
label variable AMNOPR04 "NRS/PRAC AMB VSTS - OTH PRIVATE AMT 04";
label variable AMNOPU04 "NRS/PRAC AMB VSTS - OTH PUBLIC AMT 04";
label variable AMNOSR04 "NRS/PR AMB VSTS - OTH UNCLAS SRCE AMT 04";
label variable AMOPTO04 "# AMB OPTOMETRIST VSTS (OB+OP) 04";
label variable AMETCH04 "OPTOMETRIST AMBULATORY VISIT CHARGES 04";
label variable AMEEXP04 "TOTL AMBULTRY (OB+OP) OPTOMETRIST EXP 04";
label variable AMESLF04 "OPTMTRIST AMB VSTS -SELF/FAMILY AMT 04";
label variable AMEMCR04 "OPTMTRIST AMB VSTS -MEDICARE AMT 04";
label variable AMEMCD04 "OPTMTRIST AMB VSTS -MEDICAID AMT 04";
label variable AMEPRV04 "OPTMTRIST AMB VSTS -PRIVATE INS AMT 04";
label variable AMEVA04 "OPTMTRIST AMB VSTS-VA AMT 04";
label variable AMETRI04 "OPTMTRIST AMB VSTS-TRICARE AMT 04";
label variable AMEOFD04 "OPTMTRIST AMB VSTS-OTHER FED AMT 04";
label variable AMESTL04 "OPTMTRIST AMB VSTS-OTH ST/LOCAL AMT 04";
label variable AMEWCP04 "OPTMTRIST AMB VSTS-WORKERS COMP AMT 04";
label variable AMEOPR04 "OPTMTRIST AMB VSTS - OTH PRIVATE AMT 04";
label variable AMEOPU04 "OPTMTRIST AMB VSTS - OTH PUBLIC AMT 04";
label variable AMEOSR04 "OPTOM AMB VSTS - OTH UNCLAS SRCE AMT 04";
label variable AMASST04 "# PHYSICIAN ASS T VSTS (OFF+OUPAT), 2004";
label variable AMATCH04 "PHYS ASS T AMBULATORY VISIT CHARGES 04";
label variable AMAEXP04 "TOTL AMBULTRY (OB+OP) PHYS ASS T EXP 04";
label variable AMASLF04 "PHYS ASS T AMB VSTS-SELF/FAMILY AMT 04";
label variable AMAMCR04 "PHYS ASS T AMB VSTS-MEDICARE AMT 04";
label variable AMAMCD04 "PHYS ASS T AMB VSTS-MEDICAID AMT 04";
label variable AMAPRV04 "PHYS ASS T AMB VSTS-PRIVATE INS AMT 04";
label variable AMAVA04 "PHYS ASS T AMB VSTS-VA AMT 04";
label variable AMATRI04 "PHYS ASS T AMB VSTS-TRICARE AMT 04";
label variable AMAOFD04 "PHYS ASS T AMB VSTS -OTHER FED AMT 04";
label variable AMASTL04 "PHYS ASS T AMB VSTS-OTH ST/LOCL AMT 04";
label variable AMAWCP04 "PHYS ASS T AMB VSTS-WRKERS COMP AMT 04";
label variable AMAOPR04 "PHYS ASS T AMB VSTS - OTH PRIVATE AMT 04";
label variable AMAOPU04 "PHYS ASS T AMB VSTS - OTH PUBLIC AMT 04";
label variable AMAOSR04 "P A AMB VSTS- OTH UNCLASS SRCE AMT 04";
label variable AMTHER04 "# AMB PT/OT THRPY VISITS (OB+OP) 04";
label variable AMTTCH04 "PT/OC AMBULATORY VISIT CHARGES 04";
label variable AMTEXP04 "TOTL AMBULTRY (OB+OP) PT/OT EXP 04";
label variable AMTSLF04 "PT/OT AMB VISITS-SELF/FAMILY AMT 04";
label variable AMTMCR04 "PT/OT AMB VISITS-MEDICARE AMT 04";
label variable AMTMCD04 "PT/OT AMB VISITS-MEDICAID AMT 04";
label variable AMTPRV04 "PT/OT AMB VISITS-PRIVATE INS AMT 04";
label variable AMTVA04 "PT/OT AMB VISITS-VA AMT 04";
label variable AMTTRI04 "PT/OT AMB VISITS-TRICARE AMT 04";
label variable AMTOFD04 "PT/OT AMB VISITS -OTHER FED AMT 04";
label variable AMTSTL04 "PT/OT AMB VISITS-OTH ST/LOCL AMT 04";
label variable AMTWCP04 "PT/OT AMB VISITS-WORKERS COMP AMT 04";
label variable AMTOPR04 "PT/OT AMB VISITS - OTH PRIVATE AMT 04";
label variable AMTOPU04 "PT/OT AMB VISITS-OTH PUBLIC AMT 04";
label variable AMTOSR04 "PT/OT AMB VSTS-OTH UNCLAS SRCE AMT 04";
label variable AMTOTC04 "# CALLS W/OFFICE & OUPAT DEPTS, 2004";
label variable AMDRC04 "# CALLS W/OFF & OUTPAT PHYSICIANS, 2004";
label variable ERTOT04 "# EMERGENCY ROOM VISITS 04";
label variable ERFTCH04 "ER FACILITY VISIT CHARGES 04";
label variable ERFEXP04 "TOTAL ER FACILITY EXP 04";
label variable ERFSLF04 "ER-SELF/FAMILY AMT - FAC 04";
label variable ERFMCR04 "ER-MEDICARE AMT - FAC 04";
label variable ERFMCD04 "ER-MEDICAID AMT - FAC 04";
label variable ERFPRV04 "ER-PRIVATE INS AMT - FAC 04";
label variable ERFVA04 "ER-VA AMT - FAC 04";
label variable ERFTRI04 "ER-TRICARE AMT - FAC 04";
label variable ERFOFD04 "ER-OTHER FEDERAL AMT - FAC 04";
label variable ERFSTL04 "ER-OTH ST/LOCAL AMT - FAC 04";
label variable ERFWCP04 "ER-WORKERS COMP AMT - FAC 04";
label variable ERFOPR04 "ER-OTHER PRIVATE AMT - FAC 04";
label variable ERFOPU04 "ER-OTHER PUBLIC AMT - FAC 04";
label variable ERFOSR04 "ER-OTH UNCLASS SRCE AMT - FAC 04";
label variable ERDEXP04 "TOTAL EMERGENCY ROOM DR EXP 04";
label variable ERDTCH04 "ER DOCTOR VISIT CHARGES 04";
label variable ERDSLF04 "ER-SELF/FAMILY AMT - DR 04";
label variable ERDMCR04 "ER-MEDICARE AMT - DR 04";
label variable ERDMCD04 "ER-MEDICAID AMT - DR 04";
label variable ERDPRV04 "ER-PRIVATE INS AMT - DR 04";
label variable ERDVA04 "ER-VA AMT - DR 04";
label variable ERDTRI04 "ER-TRICARE AMT - DR 04";
label variable ERDOFD04 "ER-OTHER FED AMT - DR 04";
label variable ERDSTL04 "ER-OTH ST/LOCAL AMT - DR 04";
label variable ERDWCP04 "ER-WORKERS COMP AMT - DR 04";
label variable ERDOPR04 "ER - OTHER PRIVATE AMT - DR 04";
label variable ERDOPU04 "ER - OTHER PUBLIC AMT - DR 04";
label variable ERDOSR04 "ER-OTH UNCLASS SRCE AMT - DR 04";
label variable IPZERO04 "# ZERO-NIGHT HOSPITAL STAYS 04";
label variable ZIFTCH04 "ZERO-NITE IP STAY CHARGES - FAC 04";
label variable ZIFEXP04 "TOTAL ZERO-NITE STAYS FAC EXP 04";
label variable ZIFSLF04 "ZERO-NITE IP STAZ -SELF/FAM AMT-FAC 04";
label variable ZIFMCR04 "ZERO-NITE IP STAZ-MEDICARE AMT-FAC 04";
label variable ZIFMCD04 "ZERO-NITE IP STAZ-MEDICAID AMT-FAC 04";
label variable ZIFPRV04 "ZERO-NITE IP STAZ-PRIV INS AMT-FAC 04";
label variable ZIFVA04 "ZERO-NITE IP STAZ-VA AMT-FAC 04";
label variable ZIFTRI04 "ZERO-NITE IP STAZ-TRICARE AMT-FAC 04";
label variable ZIFOFD04 "ZERO-NITE IP STAZ-OTHER FED AMT-FAC 04";
label variable ZIFSTL04 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-FAC 04";
label variable ZIFWCP04 "ZERO-NITE IP STAZ-WRKERS COMP AMT-FAC 04";
label variable ZIFOPR04 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-FAC 04";
label variable ZIFOPU04 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-FAC 04";
label variable ZIFOSR04 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-FAC 04";
label variable ZIDEXP04 "TOTAL ZERO-NITE STAZ DR 04";
label variable ZIDTCH04 "ZERO-NITE IP STAY CHARGES - DR 04";
label variable ZIDSLF04 "ZERO-NITE IP STAZ-SELF/FAM AMT-DR 04";
label variable ZIDMCR04 "ZERO-NITE IP STAZ-MEDICARE AMT-DR 04";
label variable ZIDMCD04 "ZERO-NITE IP STAZ-MEDICAID AMT-DR 04";
label variable ZIDPRV04 "ZERO-NITE IP STAZ-PRIV INS AMT-DR 04";
label variable ZIDVA04 "ZERO-NITE IP STAZ-VA AMT-DR 04";
label variable ZIDTRI04 "ZERO-NITE IP STAZ-TRICARE AMT-DR 04";
label variable ZIDOFD04 "ZERO-NITE IP STAZ-OTHER FED AMT-DR 04";
label variable ZIDSTL04 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-DR 04";
label variable ZIDWCP04 "ZERO-NITE IP STAZ-WRKERS COMP AMT-DR 04";
label variable ZIDOPR04 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-DR 04";
label variable ZIDOPU04 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-DR 04";
label variable ZIDOSR04 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-DR 04";
label variable IPDIS04 "# HOSPITAL DISCHARGES, 2004";
label variable IPFEXP04 "TOT HOSP IP FACILITY EXP-INC 0 NITES 04";
label variable IPFTCH04 "IP HOSP STAY CHARGES - FAC 04";
label variable IPFSLF04 "IP HOSP STAZ-SELF/FAMILY AMT-FAC 04";
label variable IPFMCR04 "IP HOSP STAZ-MEDICARE AMT-FAC 04";
label variable IPFMCD04 "IP HOSP STAZ-MEDICAID AMT-FAC 04";
label variable IPFPRV04 "IP HOSP STAZ-PRIV INS AMT-FAC 04";
label variable IPFVA04 "IP HOSP STAZ-VA AMT-FAC 04";
label variable IPFTRI04 "IP HOSP STAZ-TRICARE AMT-FAC 04";
label variable IPFOFD04 "IP HOSP STAZ-OTHER FED AMT-FAC 04";
label variable IPFSTL04 "IP HOSP STAZ-OTH ST/LOCAL AMT-FAC 04";
label variable IPFWCP04 "IP HOSP STAZ-WORKERS COMP AMT-FAC 04";
label variable IPFOPR04 "IP HOSP STAZ - OTH PRIVATE AMT-FAC 04";
label variable IPFOPU04 "IP HOSP STAZ - OTH PUBLIC AMT-FAC 04";
label variable IPFOSR04 "IP HOSP STAZ-OT UNCLASS SRCE AMT-FAC 04";
label variable IPDEXP04 "TOTL HOSP STAZ DR EXP 04";
label variable IPDTCH04 "IP HOSP STAY CHARGES - DR 04";
label variable IPDSLF04 "IP HOSP STAZ-SELF/FAMILY AMT-DR 04";
label variable IPDMCR04 "IP HOSP STAZ-MEDICARE AMT- DR 04";
label variable IPDMCD04 "IP HOSP STAZ-MEDICAID AMT-DR 04";
label variable IPDPRV04 "IP HOSP STAZ-PRIV INS AMT- DR 04";
label variable IPDVA04 "IP HOSP STAZ-VA AMT-DR 04";
label variable IPDTRI04 "IP HOSP STAZ-TRICARE AMT-DR 04";
label variable IPDOFD04 "IP HOSP STAZ-OTHER FED AMT-DR 04";
label variable IPDSTL04 "IP HOSP STAZ-OTH ST/LOCAL AMT-DR 04";
label variable IPDWCP04 "IP HOSP STAZ-WORKERS COMP AMT-DR 04";
label variable IPDOPR04 "IP HOSP STAZ - OTH PRIVATE AMT-DR 04";
label variable IPDOPU04 "IP HOSP STAZ - OTH PUBLIC AMT-DR 04";
label variable IPDOSR04 "IP HOSP STAZ-OT UNCLASS SORCE AMT-DR 04";
label variable IPNGTD04 "# NIGHTS IN HOSP FOR DISCHARGES, 2004";
label variable DVTOT04 "# DENTAL CARE VISITS 04";
label variable DVTTCH04 "TOTAL DENTAL CARE VISIT CHARGES 04";
label variable DVTEXP04 "TOTAL DENTAL CARE EXP 04";
label variable DVTSLF04 "ALL DENTAL CARE -SELF/FAMILY AMT 04";
label variable DVTMCR04 "ALL DENTAL CARE -MEDICARE AMT 04";
label variable DVTMCD04 "ALL DENTAL CARE -MEDICAID AMT 04";
label variable DVTPRV04 "ALL DENTAL CARE -PRIVATE INS AMT 04";
label variable DVTVA04 "ALL DENTAL CARE -VA AMT 04";
label variable DVTTRI04 "ALL DENTAL CARE -TRICARE AMT 04";
label variable DVTOFD04 "ALL DENTAL CARE -OTHER FEDRL AMT 04";
label variable DVTSTL04 "ALL DENTAL CARE -OTH ST/LOCAL AMT 04";
label variable DVTWCP04 "ALL DENTAL CARE -WORKERS COMP AMT 04";
label variable DVTOPR04 "ALL DENTAL CARE - OTH PRIVATE AMT 04";
label variable DVTOPU04 "ALL DENTAL CARE - OTH PUBLIC AMT 04";
label variable DVTOSR04 "ALL DENT CARE-OT UNCLASS SRCE AMT 04";
label variable DVGEN04 "# GENERAL DENTIST VISITS 04";
label variable DVGTCH04 "GENERAL DENTAL CARE VISIT CHARGES 04";
label variable DVGEXP04 "TOTAL GENERAL DENTIST EXP 04";
label variable DVGSLF04 "GNRL DENTAL VISITS -SELF/FAM AMT 04";
label variable DVGMCR04 "GNRL DENTAL VISITS -MEDICARE AMT 04";
label variable DVGMCD04 "GNRL DENTAL VISITS -MEDICAID AMT 04";
label variable DVGPRV04 "GNRL DENTAL VISITS -PRIVATE INS AMT 04";
label variable DVGVA04 "GNRL DENTAL VISITS -VA AMT 04";
label variable DVGTRI04 "GNRL DENTAL VISITS-TRICARE AMT 04";
label variable DVGOFD04 "GNRL DENTAL VISITS- OTHER FED AMT 04";
label variable DVGSTL04 "GNRL DENTAL VISITS - OTH ST/LOCAL AMT 04";
label variable DVGWCP04 "GNRL DENTAL VISITS - WORKERS COMP AMT 04";
label variable DVGOPR04 "GNRL DENTAL VISITS - OTH PRIVATE AMT 04";
label variable DVGOPU04 "GNRL DENTAL VISITS - OTH PUBLIC AMT 04";
label variable DVGOSR04 "GNRL DENT VSTS - OT UNCLASS SRCE AMT 04";
label variable DVORTH04 "# ORTHODONTIST VISITS 04";
label variable DVOTCH04 "ORTHODONTIST VISIT CHARGES 04";
label variable DVOEXP04 "TOTAL ORTHODONTIST EXP 04";
label variable DVOSLF04 "ORTHODONTIST VISITS -SELF/FAMILY AMT 04";
label variable DVOMCR04 "ORTHODONTIST VISITS -MEDICARE AMT 04";
label variable DVOMCD04 "ORTHODONTIST VISITS -MEDICAID AMT 04";
label variable DVOPRV04 "ORTHODONTIST VISITS -PRIVATE INS AMT 04";
label variable DVOVA04 "ORTHODONTIST VISITS-VA AMT 04";
label variable DVOTRI04 "ORTHODONTIST VISITS-TRICARE AMT 04";
label variable DVOOFD04 "ORTHODONTIST VISITS-OTHR FED AMT 04";
label variable DVOSTL04 "ORTHODONTIST VISITS-OTHR ST/LOCAL AMT 04";
label variable DVOWCP04 "ORTHODONTIST VISITS-WORKERS COMP AMT 04";
label variable DVOOPR04 "ORTHODONTIST VISITS-OTHR PRIVATE AMT 04";
label variable DVOOPU04 "ORTHODONTIST VISITS-OTHR PUBLIC AMT 04";
label variable DVOOSR04 "ORTHODONT VSTS - OT UNCLASS SRCE AMT 04";
label variable HHTOTD04 "# HOME HEALTH PROVIDER DAYS, 2004";
label variable HHAGD04 "# AGENCY HOME HEALTH PROVIDER DAYS 04";
label variable HHATCH04 "HOME HEALTH AGENCY VISIT CHARGES 04";
label variable HHAEXP04 "TOTAL HOME HEALTH AGENCY EXP 04";
label variable HHASLF04 "HOME HLTH AGENCY -SELF/FAMILY AMT 04";
label variable HHAMCR04 "HOME HLTH AGENCY -MEDICARE AMT 04";
label variable HHAMCD04 "HOME HLTH AGENCY -MEDICAID AMT 04";
label variable HHAPRV04 "HOME HLTH AGENCY -PRIVATE INS AMT 04";
label variable HHAVA04 "HOME HLTH AGENCY-VA AMT 04";
label variable HHATRI04 "HOME HLTH AGENCY-TRICARE AMT 04";
label variable HHAOFD04 "HOME HLTH AGENCY-OTHER FED AMT 04";
label variable HHASTL04 "HOME HLTH AGENCY-OTHR ST/LOCAL AMT 04";
label variable HHAWCP04 "HOME HLTH AGENCY- WORKERS COMP AMT 04";
label variable HHAOPR04 "HOME HLTH AGENCY - OTH PRIVATE AMT 04";
label variable HHAOPU04 "HOME HLTH AGENCY - OTH PUBLIC AMT 04";
label variable HHAOSR04 "H HLTH AGENCY - OT UNCLASS SRCE AMT 04";
label variable HHINDD04 "# NON-AGENCY HOME HEALTH PROVIDR DAYS 04";
label variable HHNTCH04 "HOME HEALTH NON-AGENCY VISIT CHARGES 04";
label variable HHNEXP04 "TOTAL HOME HEALTH NON-AGNCY EXP 04";
label variable HHNSLF04 "HOME HLTH NON-AGNCY -SELF/FAM AMT 04";
label variable HHNMCR04 "HOME HLTH NON-AGNCY -MEDICARE AMT 04";
label variable HHNMCD04 "HOME HLTH NON-AGNCY -MEDICAID AMT 04";
label variable HHNPRV04 "HOME HLTH NON-AGNCY -PRIV INS AMT 04";
label variable HHNVA04 "HOME HLTH NON-AGNCY-VA AMT 04";
label variable HHNTRI04 "HOME HLTH NON-AGNCY-TRICARE AMT 04";
label variable HHNOFD04 "HOME HLTH NON-AGNCY-OTHR FED AMT 04";
label variable HHNSTL04 "HOME HLTH NON-AGNCY-OTHR ST/LOCL AMT 04";
label variable HHNWCP04 "HOME HLTH NON-AGNCY-WORKERS COMP AMT 04";
label variable HHNOPR04 "HOME HLTH NON-AGNCY-OTH PRIVATE AMT 04";
label variable HHNOPU04 "HOME HLTH NON-AGNCY-OTH PUBLIC AMT 04";
label variable HHNOSR04 "H HLTH NON-AGNCY-OT UNCLASS SRCE AMT 04";
label variable HHINFD04 "# INFORMAL HOME HEALTH PROVIDER DAYS 04";
label variable VISEXP04 "TOTAL GLASSES/CONTACT LENS EXP 04";
label variable VISTCH04 "GLASSES/CONTACT LENSES CHARGES 04";
label variable VISSLF04 "GLASSES/CNTCT LENSES -SELF/FAM AMT 04";
label variable VISMCR04 "GLASSES/CNTCT LENSES-MEDICARE AMT 04";
label variable VISMCD04 "GLASSES/CNTCT LENSES-MEDICAID AMT 04";
label variable VISPRV04 "GLASSES/CNTCT LENSES-PRIV INS AMT 04";
label variable VISVA04 "GLASSES/CNTCT LENSES-VA AMT 04";
label variable VISTRI04 "GLASSES/LENSES-TRICARE AMT 04";
label variable VISOFD04 "GLASSES/CNTCT LENSES-OTHR FED AMT 04";
label variable VISSTL04 "GLASSES/CNTCT LENSES-OTH ST/LOCL AMT 04";
label variable VISWCP04 "GLASSES/CNTCT LENSES-WORKERS COMP AMT 04";
label variable VISOPR04 "GLASSES/CNTCT LENSES-OTH PRIVATE AMT 04";
label variable VISOPU04 "GLASSES/CNTCT LENSES-OTH PUBLIC AMT 04";
label variable VISOSR04 "GLASES/CNTCT LENSE-OT UNCLAS SRCE AMT 04";
label variable OTHTCH04 "OTHER EQUP/SUPPLIES CHARGES 04";
label variable OTHEXP04 "TOT OTHER EQUIP/SPLY (EXCL DIAB) EXP 04";
label variable OTHSLF04 "OTHER EQUP/SUPPLIES -SELF/FAM AMT 04";
label variable OTHMCR04 "OTHER EQUP/SUPPLIES-MEDICARE AMT 04";
label variable OTHMCD04 "OTHER EQUP/SUPPLIES-MEDICAID AMT 04";
label variable OTHPRV04 "OTHER EQUP/SUPPLIES-PRIV INS AMT 04";
label variable OTHVA04 "OTHER EQUP/SUPPLY-VA AMT 04";
label variable OTHTRI04 "OTHER EQUP/SUPPLY-TRICARE AMT 04";
label variable OTHOFD04 "OTHER EQUP/SUPPLIES-OTHR FEDRL AMT 04";
label variable OTHSTL04 "OTHER EQUP/SUPPLY-OTHR ST/LOCAL AMT 04";
label variable OTHWCP04 "OTHER EQUP/SUPPLY -WORKERS COMP AMT 04";
label variable OTHOPR04 "OTHER EQUP/SUPPLY-OTH PRIVATE AMT 04";
label variable OTHOPU04 "OTHER EQUP/SUPPLY -OTH PUBLIC AMT 04";
label variable OTHOSR04 "OTH EQUP/SUPLY -OT UNCLASS SRCE AMT 04";
label variable RXTOT04 "# PRESC MEDS INCL REFILLS 04";
label variable RXEXP04 "TOTAL RX-EXP 04";
label variable RXSLF04 "TOTAL RX-SELF/FAMILY AMT 04";
label variable RXMCR04 "TOTAL RX--MEDICARE AMT 04";
label variable RXMCD04 "TOTAL RX-MEDICAID AMT 04";
label variable RXPRV04 "TOTAL RX-PRIVATE INS AMT 04";
label variable RXVA04 "TOTAL RX-VA AMT 04";
label variable RXTRI04 "TOTAL RX-TRICARE AMT 04";
label variable RXOFD04 "TOTAL RX-OTHER FED AMT 04";
label variable RXSTL04 "TOTAL RX-OTHER ST/LOCAL AMT 04";
label variable RXWCP04 "TOTAL RX-WORKERS COMP AMT 04";
label variable RXOPR04 "TOTAL RX - OTH PRIVATE AMT 04";
label variable RXOPU04 "TOTAL RX - OTH PUBLIC AMT 04";
label variable RXOSR04 "TOT RX-OTH UNCLASS SRCE AMT 04";
label variable PERWT04F "FINAL PERSON WEIGHT, 2004";
label variable FAMWT04F "FINAL FAMILY WEIGHT, 2004";
label variable FAMWT04C "POV ADJ FAMILY WGT-CPS FAM ON 12/31/04";
label variable SAQWT04F "SAQWT04F   FINAL SAQ-PAQ PERSON WEIGHT, 2004";
label variable DIABW04F "FINAL DIABETES CARE SUPPLEMENT WEIGHT";
label variable VARSTR "VARIANCE ESTIMATION STRATUM - 2004";
label variable VARPSU "VARIANCE ESTIMATION PSU - 2004";


*DEFINE VALUE LABELS FOR REPORTS;
label define H890001X
         -1 "-1 INAPPLICABLE"
         1 "1 YES" ;

label define H890002X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H890003X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H890004X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H890005X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890006X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890007X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H890008X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H890009X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H890010X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H890011X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H890012X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H890013X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H890014X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H890015X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H890016X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890017X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H890018X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H890019X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H890020X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H890021X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H890022X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890023X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H890024X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H890025X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H890026X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H890027X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890028X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890029X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890030X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH VERSION SAQ WAS ADMINISTERED"
         2 "2 SPANISH VERSION SAQ WAS ADMINISTERED" ;

label define H890031X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890032X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890033X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890034X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H890035X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H890036X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H890037X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890038X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 BIG PROBLEM"
         2 "2 SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H890039X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H890040X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H890041X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 HAD NO VISITS IN THE LAST 12 MONTHS" ;

label define H890042X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H890043X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT AT ALL"
         2 "2 A LITTLE BIT"
         3 "3 MODERATELY"
         4 "4 QUITE A BIT"
         5 "5 EXTREMELY" ;

label define H890044X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H890045X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 BIG PROBLEM"
         2 "2 SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H890046X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H890047X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF-ADMINISTERED"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         100 "100 INTERVIEWER ADMINISTERED"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP - /HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 PARTNER'S DAUGHTER"
         33 "33 PARTNER'S SON"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP - /HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 PARENT"
         48 "48 GRANDPARENT"
         49 "49 NOT PERSON ON SAQ LABEL,RELATIONSHIP UNK"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H890048X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H890049X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H890050X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H890051X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H890052X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890053X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H890054X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H890055X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890056X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H890057X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890058X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H890059X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H890060X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AFDC"
         2 "2 NOT AFDC" ;

label define H890061X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H890062X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890063X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890064X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H890065X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890066X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890067X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890068X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890069X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890070X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890071X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890072X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890073X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890074X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890075X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890076X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890077X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890078X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890079X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890080X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890081X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890082X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890083X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890084X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890085X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890086X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890087X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890088X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890089X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890090X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890091X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         176 "$176" ;

label define H890092X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890093X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890094X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890095X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890096X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890097X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890098X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890099X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890100X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890101X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890102X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890103X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890104X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890105X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890106X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890107X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890108X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890109X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890110X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890111X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890112X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890113X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890114X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890115X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890116X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890117X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890118X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890119X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890120X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890121X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890122X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890123X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890124X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890125X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890126X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890127X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890128X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890129X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890130X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890131X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890132X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890133X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890134X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890135X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890136X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890137X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890138X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890139X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890140X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890141X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890142X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890143X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890144X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890145X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 NO VISITS IN LAST 12 MONTHS" ;

label define H890146X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 NO VISITS IN LAST 12 MONTHS" ;

label define H890147X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890148X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890149X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890150X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT APPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890151X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890152X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890153X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890154X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890155X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890156X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890157X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890158X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890159X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890160X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890161X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890162X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN LAST 7 DAYS"
         2 "2 MORE THAN 7, BUT WITHIN LAST 30 DAYS"
         3 "3 MORE THAN 30 DAYS AGO" ;

label define H890163X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H890164X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H890165X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H890166X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H890167X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H890168X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H890169X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2003 "2003 YEAR"
         2004 "2004 YEAR" ;

label define H890170X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2004 "2004 YEAR" ;

label define H890171X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2004 "2004 YEAR"
         2005 "2005 YEAR" ;

label define H890172X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H890173X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H890174X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890175X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890176X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H890177X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890178X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890179X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H890180X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890181X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H890182X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H890183X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H890184X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H890185X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H890186X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H890187X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890188X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890189X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H890190X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H890191X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890192X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890193X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H890194X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890195X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H890196X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H890197X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H890198X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H890199X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890200X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H890201X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890202X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890203X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890204X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890205X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H890206X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H890207X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890208X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 BIG PROBLEM"
         2 "2 SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H890209X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890210X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890211X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890212X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H890213X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890214X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890215X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890216X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H890217X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H890218X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H890219X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890220X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H890221X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890222X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890223X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890224X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890225X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890226X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890227X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890228X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890229X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890230X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H890231X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H890232X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H890233X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H890234X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H890235X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNKNOWN" ;

label define H890236X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H890237X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890238X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890239X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H890240X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890241X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890242X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890243X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890244X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890245X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890246X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890247X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890248X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890249X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890250X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H890251X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ITEMIZED DEDUCTIONS"
         2 "2 STANDARD DEDUCTIONS" ;

label define H890252X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890253X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 TWICE A YEAR OR MORE"
         2 "2 ONCE A YEAR"
         3 "3 LESS THAN ONCE A YEAR"
         4 "4 NEVER GO TO DENTIST" ;

label define H890254X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890255X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890256X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890257X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES" ;

label define H890258X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H890259X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890260X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H890261X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890262X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES [WAGE AMOUNT CHANGED]"
         2 "2 NO [WAGE AMOUNT DID NOT CHANGE]" ;

label define H890263X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES [WAGE AMOUNT CHANGED]"
         2 "2 NO [WAGE AMOUNT DID NOT CHANGE]" ;

label define H890264X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES [WAGE AMOUNT CHANGED]"
         2 "2 NO [WAGE AMOUNT DID NOT CHANGE]" ;

label define H890265X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H890266X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H890267X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H890268X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890269X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H890270X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890271X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890272X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H890273X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H890274X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890275X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H890276X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H890277X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H890278X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H890279X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEPS IN RU"
         2 "2 DEPS IN AND OUT OF RU"
         3 "3 DEPS OUT OF RU" ;

label define H890280X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO DEPENDENTS OUTSIDE RU"
         1 "1 ONE DEPENDENT OUTSIDE RU"
         2 "2 TWO DEPENDENTS OUTSIDE RU"
         3 "3 THREE DEPENDENTS OUTSIDE RU" ;

label define H890281X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890282X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NUMBER OF TIMES"
         95 "95 95 TIMES OR MORE" ;

label define H890283X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NUMBER OF TIMES"
         95 "95 95 TIMES OR MORE" ;

label define H890284X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890285X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890286X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890287X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890288X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890289X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890290X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890291X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890292X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890293X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890294X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890295X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890296X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890297X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890298X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890299X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890300X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890301X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890302X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890303X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890304X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890305X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890306X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890307X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890308X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890309X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890310X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890311X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890312X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890313X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890314X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890315X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890316X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890317X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890318X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890319X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890320X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890321X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890322X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890323X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         140 "$140" ;

label define H890324X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890325X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1000 "$1000" ;

label define H890326X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890327X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890328X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890329X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890330X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890331X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890332X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890333X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890334X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890335X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890336X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890337X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890338X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890339X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890340X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890341X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890342X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO SCHOOL/KINDERGARTEN ONLY"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H890343X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H890344X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H890345X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H890346X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H890347X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H890348X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890349X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         3 "3 JOB DURING RD 3/1 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 3/1" ;

label define H890350X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 4/2 INT DATE"
         3 "3 JOB DURING RD 4/2 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 4/2" ;

label define H890351X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         3 "3 JOB DURING RD 5/3 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 5/3" ;

label define H890352X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H890353X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H890354X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H890355X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H890356X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H890357X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H890358X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H890359X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H890360X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2004 "2004 YEAR" ;

label define H890361X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2003 "2003 YEAR"
         2004 "2004 YEAR" ;

label define H890362X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2004 "2004 YEAR" ;

label define H890363X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2004 "2004 YEAR"
         2005 "2005 YEAR" ;

label define H890364X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890365X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890366X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890367X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890368X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890369X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890370X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890371X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890372X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890373X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890374X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890375X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890376X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890377X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890378X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890379X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890380X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890381X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890382X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890383X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890384X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890385X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890386X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890387X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890388X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890389X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890390X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890391X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890392X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890393X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890394X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890395X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890396X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890397X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890398X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890399X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890400X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890401X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890402X
         -1 "-1 INAPPLICABLE"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H890403X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H890404X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H890405X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H890406X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H890407X
         -1 "-1 INAPP, NOT MEM OF 12/31 FAMILY"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H890408X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890409X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIMARY FILER"
         2 "2 SECONDARY FILER" ;

label define H890410X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SINGLE"
         2 "2 MARRIED FILING JOINT RETURN"
         3 "3 MARRIED FILING SEPARATELY"
         4 "4 HEAD OF HOUSEHOLD W/ QUALIFYING PERSON"
         5 "5 QUALIFYING WIDOWER W/ DEPENDENT" ;

label define H890411X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H890412X
         -1 "-1 INAPPLICABLE"
         0 "0 NONRESPONDING 12/31 FAMILY"
         1 "1 RESPONDING 12/31 FAMILY" ;

label define H890413X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H890414X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H890415X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890416X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890417X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890418X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890419X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H890420X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H890421X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H890422X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H890423X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 DO NOT HAVE PERSONAL DOCTOR OR NURSE" ;

label define H890424X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 DO NOT HAVE PERSONAL DOCTOR OR NURSE" ;

label define H890425X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H890426X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DRIVE"
         2 "2 IS DRIVEN"
         3 "3 TAXI, BUS, TRAIN, OTHER PUBLIC TRANSPO"
         4 "4 WALKS" ;

label define H890427X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890428X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H890429X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890430X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890431X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890432X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SLIGHT IMPAIRMENT"
         3 "3 MODERATE IMPAIRMENT"
         4 "4 MAJOR IMPAIRMENT"
         5 "5 DEAF" ;

label define H890433X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890434X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890435X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890436X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890437X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890438X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890439X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890440X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890441X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890442X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890443X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890444X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890445X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890446X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890447X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890448X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890449X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890450X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         285 "$285" ;

label define H890451X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890452X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890453X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890454X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890455X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890456X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890457X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         800 "$800" ;

label define H890458X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890459X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890460X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890461X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         3500 "$3500" ;

label define H890462X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890463X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890464X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890465X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890466X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890467X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         40 "$40" ;

label define H890468X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890469X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890470X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890471X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16-INAPPLICABLE" ;

label define H890472X
         1 "1 HISPANIC"
         2 "2 NOT HISPANIC" ;

label define H890473X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PUERTO RICAN"
         2 "2 CUBAN/CUBAN AMERICAN"
         3 "3 DOMINICAN"
         4 "4 MEXICAN/MEXICAN AMERICAN"
         5 "5 CENTRAL OR SOUTH AMERICAN"
         6 "6 NON-HISPANIC"
         91 "91 OTHER LATIN AMERICAN"
         92 "92 OTHER HISPANIC/LATINO" ;

label define H890474X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H890475X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H890476X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H890477X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H890478X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H890479X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890480X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890481X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890482X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890483X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890484X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890485X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890486X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890487X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890488X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890489X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890490X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890491X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890492X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890493X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890494X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890495X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890496X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890497X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890498X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890499X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890500X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890501X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890502X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890503X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890504X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890505X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890506X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890507X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890508X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890509X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890510X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890511X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890512X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890513X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890514X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890515X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890516X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890517X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890518X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890519X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890520X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890521X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890522X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890523X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890524X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890525X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890526X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890527X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890528X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890529X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890530X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890531X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890532X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890533X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890534X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890535X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890536X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890537X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890538X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890539X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890540X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890541X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890542X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890543X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890544X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890545X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890546X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890547X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890548X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890549X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890550X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890551X
         -1 "-1 INAPPLICABLE"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H890552X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H890553X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H890554X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $65.63"
         -9 "-9 NOT ASCERTAINED" ;

label define H890555X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $65.63"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H890556X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $65.63"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H890557X
         0 "0 NO"
         1 "1 YES" ;

label define H890558X
         0 "0 NO"
         1 "1 YES" ;

label define H890559X
         0 "0 NO"
         1 "1 YES" ;

label define H890560X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890561X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890562X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890563X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890564X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890565X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890566X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890567X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890568X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890569X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890570X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H890571X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H890572X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H890573X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890574X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890575X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890576X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890577X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890578X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890579X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890580X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890581X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890582X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890583X
         0 "0 NOT IN-SCOPE - NOT RESP/NOT IN AN RU"
         1 "1 IN-SCOPE ON 12/31/2004"
         2 "2 NOT IN-SCOPE ON 12/31/2004" ;

label define H890584X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/04"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H890585X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/04"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H890586X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/04"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H890587X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/04"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H890588X
         0 "0 NOT RECORDED AS BEING INSCOPE"
         1 "1 INSCOPE AT SOME TIME DURING 2004"
         2 "2 OUT-OF-SCOPE FOR ALL OF 2004" ;

label define H890589X
         1 "1 ANY PRIVATE"
         2 "2 PUBLIC ONLY"
         3 "3 UNINSURED" ;

label define H890590X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890591X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H890592X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H890593X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890594X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890595X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890596X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890597X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890598X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890599X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890600X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890601X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890602X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890603X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H890604X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890605X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ENGLISH & SPANISH"
         91 "91 OTHER" ;

label define H890606X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890607X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890608X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890609X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890610X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         250 "$250" ;

label define H890611X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890612X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890613X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890614X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890615X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890616X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890617X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890618X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890619X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890620X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890621X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890622X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890623X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890624X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890625X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890626X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890627X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890628X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890629X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890630X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890631X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890632X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890633X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890634X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890635X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890636X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890637X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H890638X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890639X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890640X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H890641X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H890642X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H890643X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890644X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890645X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H890646X
         -1 "-1 INAPPLICABLE"
         1 "1 KEY"
         2 "2 NOT KEY" ;

label define H890647X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H890648X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890649X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ANOTHER LANGUAGE" ;

label define H890650X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890651X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890652X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H890653X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H890654X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890655X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890656X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 OFFICE"
         2 "2 HOSPITAL, NOT ER"
         3 "3 HOSPITAL, ER" ;

label define H890657X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H890658X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890659X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H890660X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE" ;

label define H890661X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H890662X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H890663X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H890664X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890665X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890666X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890667X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890668X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890669X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890670X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890671X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890672X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890673X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890674X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890675X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890676X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890677X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890678X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890679X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890680X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890681X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890682X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890683X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890684X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890685X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890686X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890687X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890688X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890689X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890690X
         1 "1 YES"
         2 "2 NO" ;

label define H890691X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890692X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890693X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H890694X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H890695X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H890696X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890697X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890698X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890699X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890700X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890701X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890702X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890703X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890704X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H890705X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H890706X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H890707X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890708X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890709X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890710X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890711X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890712X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890713X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890714X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890715X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890716X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890717X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890718X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890719X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890720X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890721X
         1 "1 YES"
         2 "2 NO" ;

label define H890722X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890723X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890724X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890725X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890726X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890727X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890728X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890729X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890730X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890731X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890732X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890733X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890734X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890735X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890736X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890737X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890738X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890739X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890740X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890741X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H890742X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H890743X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890744X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H890745X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H890746X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H890747X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890748X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H890749X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890750X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890751X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H890752X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H890753X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890754X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H890755X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H890756X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H890757X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H890758X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890759X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890760X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890761X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890762X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H890763X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H890764X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H890765X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H890766X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H890767X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H890768X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H890769X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890770X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890771X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H890772X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H890773X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890774X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$65.63"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H890775X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$65.63"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H890776X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$65.63"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H890777X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890778X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890779X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890780X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890781X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WEEKS"
         2 "2 MONTHS" ;

label define H890782X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890783X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890784X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H890785X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H890786X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H890787X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H890788X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H890789X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H890790X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890791X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890792X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890793X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890794X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890795X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890796X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890797X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890798X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890799X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890800X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890801X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890802X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890803X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890804X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890805X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890806X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890807X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890808X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890809X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         321 "$321" ;

label define H890810X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890811X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890812X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890813X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890814X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890815X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         176 "$176" ;

label define H890816X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890817X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890818X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890819X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890820X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890821X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890822X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890823X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890824X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890825X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890826X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890827X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890828X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890829X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890830X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890831X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890832X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890833X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890834X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890835X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890836X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890837X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890838X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890839X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890840X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890841X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890842X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890843X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890844X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890845X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890846X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890847X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890848X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890849X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890850X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890851X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890852X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890853X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890854X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890855X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890856X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890857X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890858X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890859X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890860X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890861X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890862X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890863X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890864X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890865X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890866X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890867X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890868X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890869X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890870X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890871X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890872X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890873X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890874X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890875X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890876X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890877X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890878X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890879X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890880X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890881X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890882X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890883X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890884X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890885X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890886X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         461 "$461" ;

label define H890887X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890888X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890889X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890890X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890891X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1979 "$1979" ;

label define H890892X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890893X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890894X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890895X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890896X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890897X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890898X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890899X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890900X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890901X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890902X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890903X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890904X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890905X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890906X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890907X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890908X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890909X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890910X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NO WORK EXPERIENCE SINCE 1996"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H890911X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NO WORK EXPERIENCE SINCE 1996"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H890912X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NO WORK EXPERIENCE SINCE 1996"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H890913X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890914X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890915X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890916X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890917X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890918X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890919X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890920X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890921X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H890922X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890923X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890924X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890925X
         1 "1 YES"
         2 "2 NO" ;

label define H890926X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890927X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890928X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890929X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890930X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890931X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890932X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890933X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890934X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890935X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890936X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890937X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890938X
         1 "1 YES"
         2 "2 NO" ;

label define H890939X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890940X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890941X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890942X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890943X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890944X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890945X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890946X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890947X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H890948X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890949X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890950X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890951X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890952X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890953X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890954X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890955X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890956X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890957X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890958X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890959X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890960X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890961X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890962X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890963X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890964X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890965X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890966X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890967X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890968X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890969X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890970X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890971X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890972X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890973X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890974X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890975X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890976X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890977X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890978X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890979X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890980X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890981X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890982X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890983X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890984X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890985X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890986X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890987X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890988X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890989X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890990X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890991X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890992X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890993X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890994X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890995X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890996X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890997X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H890998X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         35 "$35" ;

label define H890999X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891000X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891001X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         37 "$37" ;

label define H891002X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891003X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891004X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         140 "$140" ;

label define H891005X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891006X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891007X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891008X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891009X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1960 "$1960" ;

label define H891010X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891011X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891012X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891013X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891014X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891015X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891016X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891017X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891018X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891019X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891020X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891021X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891022X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891023X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891024X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891025X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891026X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891027X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891028X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891029X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891030X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891031X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891032X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891033X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891034X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891035X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891036X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891037X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891038X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891039X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H891040X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891041X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891042X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891043X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891044X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891045X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891046X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         100 "$100" ;

label define H891047X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891048X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891049X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891050X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891051X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891052X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891053X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891054X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891055X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891056X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891057X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891058X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891059X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891060X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891061X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891062X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891063X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891064X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891065X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891066X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891067X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891068X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891069X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891070X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891071X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891072X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891073X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891074X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891075X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891076X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891077X
         8 "8 PANEL 8"
         9 "9 PANEL 9" ;

label define H891078X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H891079X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891080X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891081X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891082X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891083X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891084X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891085X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H891086X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H891087X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H891088X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H891089X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H891090X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H891091X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891092X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891093X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891094X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891095X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891096X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891097X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891098X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891099X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891100X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891101X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891102X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891103X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891104X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891105X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891106X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891107X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891108X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891109X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891110X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891111X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891112X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891113X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891114X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891115X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H891116X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891117X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891118X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H891119X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H891120X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H891121X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H891122X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H891123X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT APPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891124X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891125X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOSPITAL CLINIC/OUTPATIENT DEPT"
         2 "2 HOSPITAL EMERGENCY ROOM"
         3 "3 NON-HOSPITAL PLACE" ;

label define H891126X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891127X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H891128X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H891129X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891130X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891131X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891132X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H891133X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H891134X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H891135X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891136X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H891137X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H891138X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891139X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891140X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891141X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891142X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891143X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891144X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891145X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891146X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891147X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891148X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891149X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891150X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891151X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891152X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891153X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891154X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891155X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891156X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891157X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891158X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891159X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891160X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891161X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891162X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891163X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891164X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891165X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891166X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891167X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891168X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891169X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891170X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891171X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891172X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891173X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891174X
         1 "1 POOR/NEGATIVE"
         2 "2 NEAR POOR"
         3 "3 LOW INCOME"
         4 "4 MIDDLE INCOME"
         5 "5 HIGH INCOME" ;

label define H891175X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891176X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891177X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST-NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H891178X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST - NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H891179X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST - NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H891180X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891181X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891182X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891183X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891184X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891185X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891186X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891187X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891188X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891189X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891190X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891191X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891192X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891193X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891194X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891195X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891196X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891197X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891198X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891199X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891200X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891201X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891202X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891203X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891204X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891205X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891206X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891207X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891208X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891209X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891210X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891211X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891212X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891213X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891214X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891215X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891216X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891217X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891218X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891219X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891220X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891221X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891222X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891223X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891224X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891225X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891226X
         -1 "-1 INAPPLICABLE"
         1 "1 FACILITY"
         2 "2 PERSON"
         3 "3 PERSON IN FACILITY PROVIDER" ;

label define H891227X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H891228X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H891229X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H891230X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H891231X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891232X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891233X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891234X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891235X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891236X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891237X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891238X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891239X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891240X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891241X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891242X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891243X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H891244X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H891245X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H891246X
         1 "1 YES"
         2 "2 NO" ;

label define H891247X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H891248X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H891249X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H891250X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H891251X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H891252X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H891253X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H891254X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R1 ONLY"
         62 "62 INSTITUT PRIOR TO REF PER-R1 ONLY"
         63 "63 LEFT U.S. PRIOR TO REF PER-R1 ONLY"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H891255X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R1 ONLY"
         62 "62 INSTITUT PRIOR TO REF PER-R1 ONLY"
         63 "63 LEFT U.S. PRIOR TO REF PER-R1 ONLY"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H891256X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R1 ONLY"
         62 "62 INSTITUT PRIOR TO REF PER-R1 ONLY"
         63 "63 LEFT U.S. PRIOR TO REF PER-R1 ONLY"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H891257X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891258X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891259X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891260X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891261X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891262X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891263X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891264X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891265X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891266X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891267X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891268X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891269X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H891270X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891271X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891272X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891273X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891274X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891275X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891276X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891277X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891278X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891279X
         -1 "-1 INAPPLICABLE"
         1 "1 ASIAN - NO OTHER RACE REPORTED"
         2 "2 ASIAN - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H891280X
         -1 "-1 INAPPLICABLE"
         1 "1 BLACK - NO OTHER RACE REPORTED"
         2 "2 BLACK - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H891281X
         1 "1 PERSON IS HISPANIC"
         2 "2 PERSON IS BLACK-NO OTH RACE/NOT HISPANIC"
         3 "3 PERSON IS ASIAN-NO OTH RACE/NOT HISPANIC"
         4 "4 OTHER RACE/NOT HISPANIC" ;

label define H891282X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 WHITE - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H891283X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 BLACK - NO OTHER RACE REPORTED"
         3 "3 AMER INDIAN/ALASKA NATIVE - NO OTH RAC"
         4 "4 ASIAN - NO OTHER RACE REPORTED"
         5 "5 NATIVE HAWAIIAN/PACIFIC ISLANDER-NO OTHR"
         6 "6 MULTIPLE RACES REPORTED" ;

label define H891284X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H891285X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H891286X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891287X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891288X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891289X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891290X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H891291X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H891292X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H891293X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H891294X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H891295X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H891296X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H891297X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H891298X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H891299X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H891300X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891301X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891302X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891303X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H891304X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H891305X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H891306X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H891307X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ROUND 1"
         2 "2 ROUND 2"
         3 "3 ROUND 3" ;

label define H891308X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H891309X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H891310X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H891311X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H891312X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H891313X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H891314X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H891315X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H891316X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H891317X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H891318X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H891319X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H891320X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H891321X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891322X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891323X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891324X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891325X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891326X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891327X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891328X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891329X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891330X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891331X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891332X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891333X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891334X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891335X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891336X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891337X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H891338X
         0 "0 NOT ELIGIBLE"
         1 "1 ELIGIBLE FOR SAQ - HAS SAQ DATA"
         2 "2 ELIGIBLE FOR SAQ - NO SAQ DATA" ;

label define H891339X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H891340X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891341X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891342X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H891343X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891344X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891345X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891346X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALWAYS"
         2 "2 NEARLY ALWAYS"
         3 "3 SOMETIMES"
         4 "4 SELDOM"
         5 "5 NEVER"
         6 "6 NEVER DRIVES/RIDES IN A CAR" ;

label define H891347X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891348X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891349X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891350X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891351X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891352X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H891353X
         -1 "-1 INAPPLICABLE"
         0 "0 NO"
         1 "1 YES" ;

label define H891354X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H891355X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H891356X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891357X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891358X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891359X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891360X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891361X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H891362X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H891363X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H891364X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H891365X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H891366X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H891367X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H891368X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H891369X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H891370X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891371X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H891372X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891373X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISABILITY"
         2 "2 SOME OTHER REASON" ;

label define H891374X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H891375X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891376X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H891377X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H891378X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H891379X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891380X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891381X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891382X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891383X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891384X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891385X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891386X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891387X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891388X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891389X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891390X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891391X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891392X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891393X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891394X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891395X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H891396X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H891397X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H891398X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H891399X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H891400X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H891401X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H891402X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H891403X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H891404X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H891405X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H891406X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891407X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891408X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H891409X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H891410X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891411X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891412X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891413X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891414X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891415X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LONG TERM 1040"
         2 "2 SHORT FORM 1040A"
         3 "3 SHORT FORM 1040EZ"
         91 "91 OTHER" ;

label define H891416X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H891417X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H891418X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H891419X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891420X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891421X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891422X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891423X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891424X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SORE THROAT"
         2 "2 OTHER SYMPTOMS" ;

label define H891425X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891426X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 15 MINUTES"
         2 "2 15 TO 30 MINUTES"
         3 "3 31 TO 60 MINUTES (1 HOUR)"
         4 "4 61 TO 90 MINUTES"
         5 "5 91 MINUTES TO 120 MINUTES (2 HOURS)"
         6 "6 MORE THAN 120 MINUTES (2 HOURS)" ;

label define H891427X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891428X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891429X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891430X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891431X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891432X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891433X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891434X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891435X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891436X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891437X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891438X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891439X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891440X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891441X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891442X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891443X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H891444X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891445X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891446X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891447X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891448X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891449X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891450X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891451X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891452X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891453X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891454X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891455X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891456X
         1 "1 YES"
         2 "2 NO" ;

label define H891457X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICARE-TRI EXTRA NOT ASCERTAINED"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICARE - NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE" ;

label define H891458X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICARE-TRI EXTRA NOT ASCERTAINED"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICARE - NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE" ;

label define H891459X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICARE-TRI EXTRA NOT ASCERTAINED"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICARE - NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE" ;

label define H891460X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891461X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891462X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891463X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891464X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV TRICARE-TRI FOR LIFE NOT ASCERTAINED"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICARE - NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE" ;

label define H891465X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV TRICARE-TRI FOR LIFE NOT ASCERTAINED"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICARE - NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE" ;

label define H891466X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV TRICARE-TRI FOR LIFE NOT ASCERTAINED"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICARE - NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE" ;

label define H891467X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891468X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891469X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891470X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891471X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICARE-TRI PRIME NOT ASCERTAINED"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICARE - NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE" ;

label define H891472X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICARE-TRI PRIME NOT ASCERTAINED"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICARE - NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE" ;

label define H891473X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICARE-TRI PRIME NOT ASCERTAINED"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICARE - NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE" ;

label define H891474X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H891475X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV TRICARE-TRI STANDARD NOT ASCERTAINED"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICARE - NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE" ;

label define H891476X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV TRICARE-TRI STANDARD NOT ASCERTAINED"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICARE - NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE" ;

label define H891477X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV TRICARE-TRI STANDARD NOT ASCERTAINED"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICARE - NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE" ;

label define H891478X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891479X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H891480X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891481X
         -1 "-1 INAPPLICABLE"
         1 "1 MD - GENERAL/FAMILY PRACTICE"
         10 "10 PHYSICIAN'S ASSISTANT"
         11 "11 OTHER NON-MD PROVIDER"
         12 "12 UNKNOWN"
         13 "13 MD - CARDIOLOGIST"
         14 "14 DOCTOR OF OSTEOPATHY"
         15 "15 MD - ENDOCRINOLOGIST"
         16 "16 MD - GASTROENTEROLOGIST"
         17 "17 MD - GERIATRICIAN"
         18 "18 MD - NEPHROLOGIST"
         19 "19 MD - ONCOLOGIST"
         2 "2 MD - INTERNAL MEDICINE"
         20 "20 MD - PULMONOLOGIST"
         21 "21 MD- RHEUMATOLOGIST"
         22 "22 PSYCHIATRIST/PSYCHOLOGIST"
         3 "3 MD - PEDIATRICS"
         4 "4 MD - OB/GYN"
         5 "5 MD - SURGERY"
         6 "6 MD - OTHER"
         7 "7 CHIROPRACTOR"
         8 "8 NURSE"
         9 "9 NURSE PRACTITIONER" ;

label define H891482X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891483X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891484X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H891485X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891486X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H891487X
         1 "1 YES"
         2 "2 NO" ;

label define H891488X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891489X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891490X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891491X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891492X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H891493X
         1 "1 ORIGINAL RESPONSE USED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H891494X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H891495X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H891496X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891497X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H891498X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H891499X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891500X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 IMPAIRED NEAR, BUT NOT FAR"
         4 "4 IMPAIRED BOTH NEAR AND FAR"
         5 "5 BLIND" ;

label define H891501X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891502X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891503X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891504X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891505X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891506X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891507X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891508X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891509X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891510X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891511X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891512X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891513X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891514X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891515X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H891516X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891517X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891518X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891519X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891520X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891521X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891522X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891523X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891524X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891525X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891526X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891527X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891528X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891529X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891530X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891531X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H891532X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS" ;

label define H891533X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891534X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H891535X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H891536X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS" ;

label define H891537X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H891538X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H891539X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H891540X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H891541X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H891542X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H891543X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H891544X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H891545X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H891546X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891547X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891548X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891549X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891550X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891551X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891552X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H891553X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H891554X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891555X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891556X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891557X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H891558X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891559X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H891560X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE ANOTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H891561X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE OTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H891562X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEM"
         91 "91 SOME OTHER REASON" ;

label define H891563X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEM"
         91 "91 SOME OTHER REASON" ;

label define H891564X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEMS"
         91 "91 SOME OTHER REASON" ;

label define H891565X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELDOM OR NEVER SICK"
         10 "10 INSURANCE-RELATED REASONS"
         11 "11 JOB-RELATED REASONS"
         12 "12 LOOKING FOR A NEW DOCTOR/NO DOCTOR YET"
         14 "14 DON'T LIKE/DON'T TRUST DOCTORS"
         17 "17 SELF/RELATIVE/FRIEND/COWORKER IS DR"
         2 "2 RECENTLY MOVED TO AREA"
         20 "20 WILL NOT GO TO THE DOCTOR"
         21 "21 PROBLEMS WITH TIME AND TRANSPORTATION"
         3 "3 DON'T KNOW WHERE TO GO"
         4 "4 USC IN AREA NOT AVAILABLE"
         5 "5 CAN'T FIND PROVIDER WHO SPEAKS LANGUAGE"
         6 "6 GOES DIFFERENT PLACES FOR DIFF NEEDS"
         7 "7 JUST CHANGED INSURANCE PLANS"
         8 "8 DON'T USE DOCS/TREAT SELF"
         9 "9 COST OF MEDICAL CARE"
         91 "91 OTHER REASON" ;

label define H891566X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891567X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891568X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891569X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891570X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891571X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891572X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891573X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891574X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891575X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891576X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891577X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891578X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891579X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891580X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891581X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891582X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891583X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891584X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891585X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891586X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         355 "$355" ;

label define H891587X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891588X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891589X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891590X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891591X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H891592X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         825 "$825" ;

label define H891593X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         4763 "$4763" ;

* ASSOCIATE VARIABLES WITH VALUE LABEL DEFINITIONS;
label value ACCELI42 H890001X;
label value ACTDTY31 H890002X;
label value ACTDTY42 H890003X;
label value ACTDTY53 H890004X;
label value ACTLIM31 H890005X;
label value ACTLIM53 H890006X;
label value ADAPPT42 H890007X;
label value ADCAPE42 H890008X;
label value ADCLIM42 H890009X;
label value ADCMPD42 H890010X;
label value ADCMPM42 H890011X;
label value ADCMPY42 H890012X;
label value ADDAYA42 H890013X;
label value ADDOWN42 H890014X;
label value ADDPRS42 H890015X;
label value ADDRBP42 H890016X;
label value ADEFRT42 H890017X;
label value ADEXPL42 H890018X;
label value ADGENH42 H890019X;
label value ADHECR42 H890020X;
label value ADHOPE42 H890021X;
label value ADILCR42 H890022X;
label value ADILWW42 H890023X;
label value ADINSA42 H890024X;
label value ADINSB42 H890025X;
label value ADINTR42 H890026X;
label value ADL3MO31 H890027X;
label value ADL3MO42 H890028X;
label value ADL3MO53 H890029X;
label value ADLANG42 H890030X;
label value ADLHLP31 H890031X;
label value ADLHLP42 H890032X;
label value ADLHLP53 H890033X;
label value ADLIST42 H890034X;
label value ADMALS42 H890035X;
label value ADMWLM42 H890036X;
label value ADNDCR42 H890037X;
label value ADNECP42 H890038X;
label value ADNERV42 H890039X;
label value ADNRGY42 H890040X;
label value ADNSMK42 H890041X;
label value ADOVER42 H890042X;
label value ADPAIN42 H890043X;
label value ADPALS42 H890044X;
label value ADPRRE42 H890045X;
label value ADPRTM42 H890046X;
label value ADPRX42 H890047X;
label value ADPWLM42 H890048X;
label value ADRESP42 H890049X;
label value ADREST42 H890050X;
label value ADRISK42 H890051X;
label value ADRTCR42 H890052X;
label value ADRTWW42 H890053X;
label value ADSAD42 H890054X;
label value ADSMOK42 H890055X;
label value ADSOCA42 H890056X;
label value ADSPEC42 H890057X;
label value ADUPRO42 H890058X;
label value ADWRTH42 H890059X;
label value AFDC04 H890060X;
label value AFTHOU42 H890061X;
label value AIDHLP31 H890062X;
label value AIDHLP53 H890063X;
label value ALIIMP04 H890064X;
label value ALIMP04X H890065X;
label value AMAEXP04 H890066X;
label value AMAMCD04 H890067X;
label value AMAMCR04 H890068X;
label value AMAOFD04 H890069X;
label value AMAOPR04 H890070X;
label value AMAOPU04 H890071X;
label value AMAOSR04 H890072X;
label value AMAPRV04 H890073X;
label value AMASLF04 H890074X;
label value AMASST04 H890075X;
label value AMASTL04 H890076X;
label value AMATCH04 H890077X;
label value AMATRI04 H890078X;
label value AMAVA04 H890079X;
label value AMAWCP04 H890080X;
label value AMCEXP04 H890081X;
label value AMCHIR04 H890082X;
label value AMCMCD04 H890083X;
label value AMCMCR04 H890084X;
label value AMCOFD04 H890085X;
label value AMCOPR04 H890086X;
label value AMCOPU04 H890087X;
label value AMCOSR04 H890088X;
label value AMCPRV04 H890089X;
label value AMCSLF04 H890090X;
label value AMCSTL04 H890091X;
label value AMCTCH04 H890092X;
label value AMCTRI04 H890093X;
label value AMCVA04 H890094X;
label value AMCWCP04 H890095X;
label value AMDRC04 H890096X;
label value AMEEXP04 H890097X;
label value AMEMCD04 H890098X;
label value AMEMCR04 H890099X;
label value AMEOFD04 H890100X;
label value AMEOPR04 H890101X;
label value AMEOPU04 H890102X;
label value AMEOSR04 H890103X;
label value AMEPRV04 H890104X;
label value AMESLF04 H890105X;
label value AMESTL04 H890106X;
label value AMETCH04 H890107X;
label value AMETRI04 H890108X;
label value AMEVA04 H890109X;
label value AMEWCP04 H890110X;
label value AMNEXP04 H890111X;
label value AMNMCD04 H890112X;
label value AMNMCR04 H890113X;
label value AMNOFD04 H890114X;
label value AMNOPR04 H890115X;
label value AMNOPU04 H890116X;
label value AMNOSR04 H890117X;
label value AMNPRV04 H890118X;
label value AMNSLF04 H890119X;
label value AMNSTL04 H890120X;
label value AMNTCH04 H890121X;
label value AMNTRI04 H890122X;
label value AMNURS04 H890123X;
label value AMNVA04 H890124X;
label value AMNWCP04 H890125X;
label value AMOPTO04 H890126X;
label value AMTEXP04 H890127X;
label value AMTHER04 H890128X;
label value AMTMCD04 H890129X;
label value AMTMCR04 H890130X;
label value AMTOFD04 H890131X;
label value AMTOPR04 H890132X;
label value AMTOPU04 H890133X;
label value AMTOSR04 H890134X;
label value AMTOTC04 H890135X;
label value AMTPRV04 H890136X;
label value AMTSLF04 H890137X;
label value AMTSTL04 H890138X;
label value AMTTCH04 H890139X;
label value AMTTRI04 H890140X;
label value AMTVA04 H890141X;
label value AMTWCP04 H890142X;
label value ANGIDX53 H890143X;
label value ANYLIM04 H890144X;
label value APRDLM42 H890145X;
label value APRDLT42 H890146X;
label value APRTRM42 H890147X;
label value APRTRT42 H890148X;
label value ARTHDX53 H890149X;
label value ARTHTX53 H890150X;
label value ASACUT53 H890151X;
label value ASATAK53 H890152X;
label value ASDALY53 H890153X;
label value ASEVFL53 H890154X;
label value ASIANP42 H890155X;
label value ASMRCN53 H890156X;
label value ASPKFL53 H890157X;
label value ASPREV53 H890158X;
label value ASPRIN53 H890159X;
label value ASSTIL53 H890160X;
label value ASTHDX53 H890161X;
label value ASWNFL53 H890162X;
label value BEGRFD31 H890163X;
label value BEGRFD42 H890164X;
label value BEGRFD53 H890165X;
label value BEGRFM31 H890166X;
label value BEGRFM42 H890167X;
label value BEGRFM53 H890168X;
label value BEGRFY31 H890169X;
label value BEGRFY42 H890170X;
label value BEGRFY53 H890171X;
label value BENDIF31 H890172X;
label value BENDIF53 H890173X;
label value BLCKPR42 H890174X;
label value BLIND42 H890175X;
label value BMINDX53 H890176X;
label value BOOST42 H890177X;
label value BOWEL53 H890178X;
label value BPCHEK53 H890179X;
label value BPMLDX53 H890180X;
label value BPMONT53 H890181X;
label value BRSTEX53 H890182X;
label value BSNTY31 H890183X;
label value BSNTY42 H890184X;
label value BSNTY53 H890185X;
label value BUSIMP04 H890186X;
label value CARECO42 H890187X;
label value CASHP04X H890188X;
label value CHAPPT42 H890189X;
label value CHBMIX42 H890190X;
label value CHCOUN42 H890191X;
label value CHDDX53 H890192X;
label value CHECK53 H890193X;
label value CHEMPB42 H890194X;
label value CHEXPL42 H890195X;
label value CHGJ3142 H890196X;
label value CHGJ4253 H890197X;
label value CHHECR42 H890198X;
label value CHILCR42 H890199X;
label value CHILWW42 H890200X;
label value CHLDP04X H890201X;
label value CHLICO42 H890202X;
label value CHLIHB42 H890203X;
label value CHLIMI42 H890204X;
label value CHLIMP04 H890205X;
label value CHLIST42 H890206X;
label value CHNDCR42 H890207X;
label value CHNECP42 H890208X;
label value CHOIC31 H890209X;
label value CHOIC42 H890210X;
label value CHOIC53 H890211X;
label value CHOLCK53 H890212X;
label value CHPMCN42 H890213X;
label value CHPMED42 H890214X;
label value CHPMHB42 H890215X;
label value CHPRRE42 H890216X;
label value CHPRTM42 H890217X;
label value CHRESP42 H890218X;
label value CHRTCR42 H890219X;
label value CHRTWW42 H890220X;
label value CHSERV42 H890221X;
label value CHSPEC42 H890222X;
label value CHSRCN42 H890223X;
label value CHSRHB42 H890224X;
label value CHTHCO42 H890225X;
label value CHTHER42 H890226X;
label value CHTHHB42 H890227X;
label value CLINIC42 H890228X;
label value CLMDEP04 H890229X;
label value CLMHIP04 H890230X;
label value COGLIM31 H890231X;
label value COGLIM53 H890232X;
label value COVRMM H890233X;
label value COVRYY H890234X;
label value CSHCN42 H890235X;
label value CSHIMP04 H890236X;
label value CSTSVM42 H890237X;
label value CSTSVT42 H890238X;
label value DADPRO42 H890239X;
label value DDBDYS31 H890240X;
label value DDBDYS42 H890241X;
label value DDBDYS53 H890242X;
label value DDNSCL31 H890243X;
label value DDNSCL42 H890244X;
label value DDNSCL53 H890245X;
label value DDNWRK31 H890246X;
label value DDNWRK42 H890247X;
label value DDNWRK53 H890248X;
label value DEAF42 H890249X;
label value DECIDE42 H890250X;
label value DEDUCT04 H890251X;
label value DENTAL42 H890252X;
label value DENTCK53 H890253X;
label value DENTIN31 H890254X;
label value DENTIN42 H890255X;
label value DENTIN53 H890256X;
label value DEPDNT04 H890257X;
label value DFTOUS42 H890258X;
label value DIABDX53 H890259X;
label value DIDSERVE H890260X;
label value DIFFPL42 H890261X;
label value DIFFWG31 H890262X;
label value DIFFWG42 H890263X;
label value DIFFWG53 H890264X;
label value DISVW31X H890265X;
label value DISVW42X H890266X;
label value DISVW53X H890267X;
label value DIVDP04X H890268X;
label value DIVIMP04 H890269X;
label value DKWHRU42 H890270X;
label value DNDLAY42 H890271X;
label value DNDLPR42 H890272X;
label value DNDLRS42 H890273X;
label value DNUNAB42 H890274X;
label value DNUNPR42 H890275X;
label value DNUNRS42 H890276X;
label value DOBMM H890277X;
label value DOBYY H890278X;
label value DPINRU04 H890279X;
label value DPOTSD04 H890280X;
label value DRTHRT53 H890281X;
label value DSA1C53 H890282X;
label value DSCKFT53 H890283X;
label value DSDIA53 H890284X;
label value DSDIET53 H890285X;
label value DSEB0353 H890286X;
label value DSEY0353 H890287X;
label value DSEY0453 H890288X;
label value DSEY0553 H890289X;
label value DSEYNV53 H890290X;
label value DSEYPR53 H890291X;
label value DSINSU53 H890292X;
label value DSKIDN53 H890293X;
label value DSMED53 H890294X;
label value DSPRX53 H890295X;
label value DVGEN04 H890296X;
label value DVGEXP04 H890297X;
label value DVGMCD04 H890298X;
label value DVGMCR04 H890299X;
label value DVGOFD04 H890300X;
label value DVGOPR04 H890301X;
label value DVGOPU04 H890302X;
label value DVGOSR04 H890303X;
label value DVGPRV04 H890304X;
label value DVGSLF04 H890305X;
label value DVGSTL04 H890306X;
label value DVGTCH04 H890307X;
label value DVGTRI04 H890308X;
label value DVGVA04 H890309X;
label value DVGWCP04 H890310X;
label value DVOEXP04 H890311X;
label value DVOMCD04 H890312X;
label value DVOMCR04 H890313X;
label value DVOOFD04 H890314X;
label value DVOOPR04 H890315X;
label value DVOOPU04 H890316X;
label value DVOOSR04 H890317X;
label value DVOPRV04 H890318X;
label value DVORTH04 H890319X;
label value DVOSLF04 H890320X;
label value DVOSTL04 H890321X;
label value DVOTCH04 H890322X;
label value DVOTRI04 H890323X;
label value DVOVA04 H890324X;
label value DVOWCP04 H890325X;
label value DVTEXP04 H890326X;
label value DVTMCD04 H890327X;
label value DVTMCR04 H890328X;
label value DVTOFD04 H890329X;
label value DVTOPR04 H890330X;
label value DVTOPU04 H890331X;
label value DVTOSR04 H890332X;
label value DVTOT04 H890333X;
label value DVTPRV04 H890334X;
label value DVTSLF04 H890335X;
label value DVTSTL04 H890336X;
label value DVTTCH04 H890337X;
label value DVTTRI04 H890338X;
label value DVTVA04 H890339X;
label value DVTWCP04 H890340X;
label value EATHLT42 H890341X;
label value EDUCYEAR H890342X;
label value EICRDT04 H890343X;
label value ELGRND04 H890344X;
label value ELGRND31 H890345X;
label value ELGRND42 H890346X;
label value ELGRND53 H890347X;
label value EMPHDX53 H890348X;
label value EMPST31 H890349X;
label value EMPST42 H890350X;
label value EMPST53 H890351X;
label value ENDRFD04 H890352X;
label value ENDRFD31 H890353X;
label value ENDRFD42 H890354X;
label value ENDRFD53 H890355X;
label value ENDRFM04 H890356X;
label value ENDRFM31 H890357X;
label value ENDRFM42 H890358X;
label value ENDRFM53 H890359X;
label value ENDRFY04 H890360X;
label value ENDRFY31 H890361X;
label value ENDRFY42 H890362X;
label value ENDRFY53 H890363X;
label value ENGHME42 H890364X;
label value ENGSPK42 H890365X;
label value ERDEXP04 H890366X;
label value ERDMCD04 H890367X;
label value ERDMCR04 H890368X;
label value ERDOFD04 H890369X;
label value ERDOPR04 H890370X;
label value ERDOPU04 H890371X;
label value ERDOSR04 H890372X;
label value ERDPRV04 H890373X;
label value ERDSLF04 H890374X;
label value ERDSTL04 H890375X;
label value ERDTCH04 H890376X;
label value ERDTRI04 H890377X;
label value ERDVA04 H890378X;
label value ERDWCP04 H890379X;
label value ERFEXP04 H890380X;
label value ERFMCD04 H890381X;
label value ERFMCR04 H890382X;
label value ERFOFD04 H890383X;
label value ERFOPR04 H890384X;
label value ERFOPU04 H890385X;
label value ERFOSR04 H890386X;
label value ERFPRV04 H890387X;
label value ERFSLF04 H890388X;
label value ERFSTL04 H890389X;
label value ERFTCH04 H890390X;
label value ERFTRI04 H890391X;
label value ERFVA04 H890392X;
label value ERFWCP04 H890393X;
label value ERTOT04 H890394X;
label value EVRETIRE H890395X;
label value EVRUNAT H890396X;
label value EVRUNINS H890397X;
label value EVRWRK H890398X;
label value EXPLOP42 H890399X;
label value EXRCIS53 H890400X;
label value FACLPR42 H890401X;
label value FAMRFPYR H890402X;
label value FAMSZE04 H890403X;
label value FAMSZE31 H890404X;
label value FAMSZE42 H890405X;
label value FAMSZE53 H890406X;
label value FCRP1231 H890407X;
label value FILEDR04 H890408X;
label value FILER04 H890409X;
label value FLSTAT04 H890410X;
label value FLUSHT53 H890411X;
label value FMRS1231 H890412X;
label value FNGRDF31 H890413X;
label value FNGRDF53 H890414X;
label value FOODCT04 H890415X;
label value FOODMN04 H890416X;
label value FOODST04 H890417X;
label value FOODVL04 H890418X;
label value FTSTU04X H890419X;
label value FTSTU31X H890420X;
label value FTSTU42X H890421X;
label value FTSTU53X H890422X;
label value GDCPBM42 H890423X;
label value GDCPBT42 H890424X;
label value GENDRP42 H890425X;
label value GOTOUS42 H890426X;
label value HAVEUS42 H890427X;
label value HAVFUN42 H890428X;
label value HEARAD42 H890429X;
label value HEARDI42 H890430X;
label value HEARMO42 H890431X;
label value HEARNG42 H890432X;
label value HEARSM42 H890433X;
label value HELD31X H890434X;
label value HELD42X H890435X;
label value HELD53X H890436X;
label value HELMET42 H890437X;
label value HHAEXP04 H890438X;
label value HHAGD04 H890439X;
label value HHAMCD04 H890440X;
label value HHAMCR04 H890441X;
label value HHAOFD04 H890442X;
label value HHAOPR04 H890443X;
label value HHAOPU04 H890444X;
label value HHAOSR04 H890445X;
label value HHAPRV04 H890446X;
label value HHASLF04 H890447X;
label value HHASTL04 H890448X;
label value HHATCH04 H890449X;
label value HHATRI04 H890450X;
label value HHAVA04 H890451X;
label value HHAWCP04 H890452X;
label value HHINDD04 H890453X;
label value HHINFD04 H890454X;
label value HHNEXP04 H890455X;
label value HHNMCD04 H890456X;
label value HHNMCR04 H890457X;
label value HHNOFD04 H890458X;
label value HHNOPR04 H890459X;
label value HHNOPU04 H890460X;
label value HHNOSR04 H890461X;
label value HHNPRV04 H890462X;
label value HHNSLF04 H890463X;
label value HHNSTL04 H890464X;
label value HHNTCH04 H890465X;
label value HHNTRI04 H890466X;
label value HHNVA04 H890467X;
label value HHNWCP04 H890468X;
label value HHTOTD04 H890469X;
label value HIBPDX53 H890470X;
label value HIDEGYR H890471X;
label value HISPANX H890472X;
label value HISPCAT H890473X;
label value HLTHLF42 H890474X;
label value HOMEBH42 H890475X;
label value HOUR31 H890476X;
label value HOUR42 H890477X;
label value HOUR53 H890478X;
label value HPDAP04 H890479X;
label value HPDAU04 H890480X;
label value HPDDE04 H890481X;
label value HPDFE04 H890482X;
label value HPDJA04 H890483X;
label value HPDJL04 H890484X;
label value HPDJU04 H890485X;
label value HPDMA04 H890486X;
label value HPDMY04 H890487X;
label value HPDNO04 H890488X;
label value HPDOC04 H890489X;
label value HPDSE04 H890490X;
label value HPEAP04 H890491X;
label value HPEAU04 H890492X;
label value HPEDE04 H890493X;
label value HPEFE04 H890494X;
label value HPEJA04 H890495X;
label value HPEJL04 H890496X;
label value HPEJU04 H890497X;
label value HPEMA04 H890498X;
label value HPEMY04 H890499X;
label value HPENO04 H890500X;
label value HPEOC04 H890501X;
label value HPESE04 H890502X;
label value HPNAP04 H890503X;
label value HPNAU04 H890504X;
label value HPNDE04 H890505X;
label value HPNFE04 H890506X;
label value HPNJA04 H890507X;
label value HPNJL04 H890508X;
label value HPNJU04 H890509X;
label value HPNMA04 H890510X;
label value HPNMY04 H890511X;
label value HPNNO04 H890512X;
label value HPNOC04 H890513X;
label value HPNSE04 H890514X;
label value HPOAP04 H890515X;
label value HPOAU04 H890516X;
label value HPODE04 H890517X;
label value HPOFE04 H890518X;
label value HPOJA04 H890519X;
label value HPOJL04 H890520X;
label value HPOJU04 H890521X;
label value HPOMA04 H890522X;
label value HPOMY04 H890523X;
label value HPONO04 H890524X;
label value HPOOC04 H890525X;
label value HPOSE04 H890526X;
label value HPRAP04 H890527X;
label value HPRAU04 H890528X;
label value HPRDE04 H890529X;
label value HPRFE04 H890530X;
label value HPRJA04 H890531X;
label value HPRJL04 H890532X;
label value HPRJU04 H890533X;
label value HPRMA04 H890534X;
label value HPRMY04 H890535X;
label value HPRNO04 H890536X;
label value HPROC04 H890537X;
label value HPRSE04 H890538X;
label value HPSAP04 H890539X;
label value HPSAU04 H890540X;
label value HPSDE04 H890541X;
label value HPSFE04 H890542X;
label value HPSJA04 H890543X;
label value HPSJL04 H890544X;
label value HPSJU04 H890545X;
label value HPSMA04 H890546X;
label value HPSMY04 H890547X;
label value HPSNO04 H890548X;
label value HPSOC04 H890549X;
label value HPSSE04 H890550X;
label value HRHOW31 H890551X;
label value HRHOW42 H890552X;
label value HRHOW53 H890553X;
label value HRWG31X H890554X;
label value HRWG42X H890555X;
label value HRWG53X H890556X;
label value HRWGIM31 H890557X;
label value HRWGIM42 H890558X;
label value HRWGIM53 H890559X;
label value HSELIM31 H890560X;
label value HSELIM53 H890561X;
label value HSPLAP42 H890562X;
label value HYSTER53 H890563X;
label value IADL3M31 H890564X;
label value IADL3M42 H890565X;
label value IADL3M53 H890566X;
label value IADLHP31 H890567X;
label value IADLHP42 H890568X;
label value IADLHP53 H890569X;
label value INDCAT31 H890570X;
label value INDCAT42 H890571X;
label value INDCAT53 H890572X;
label value INS04X H890573X;
label value INS31X H890574X;
label value INS42X H890575X;
label value INS53X H890576X;
label value INSAP04X H890577X;
label value INSAT04X H890578X;
label value INSAT31X H890579X;
label value INSAT42X H890580X;
label value INSAT53X H890581X;
label value INSAU04X H890582X;
label value INSC1231 H890583X;
label value INSCOP04 H890584X;
label value INSCOP31 H890585X;
label value INSCOP42 H890586X;
label value INSCOP53 H890587X;
label value INSCOPE H890588X;
label value INSCOV04 H890589X;
label value INSDE04X H890590X;
label value INSENDMM H890591X;
label value INSENDYY H890592X;
label value INSFE04X H890593X;
label value INSJA04X H890594X;
label value INSJL04X H890595X;
label value INSJU04X H890596X;
label value INSMA04X H890597X;
label value INSMY04X H890598X;
label value INSNO04X H890599X;
label value INSOC04X H890600X;
label value INSRPL42 H890601X;
label value INSSE04X H890602X;
label value INTIMP04 H890603X;
label value INTRP04X H890604X;
label value INTVLANG H890605X;
label value IPDEXP04 H890606X;
label value IPDIS04 H890607X;
label value IPDMCD04 H890608X;
label value IPDMCR04 H890609X;
label value IPDOFD04 H890610X;
label value IPDOPR04 H890611X;
label value IPDOPU04 H890612X;
label value IPDOSR04 H890613X;
label value IPDPRV04 H890614X;
label value IPDSLF04 H890615X;
label value IPDSTL04 H890616X;
label value IPDTCH04 H890617X;
label value IPDTRI04 H890618X;
label value IPDVA04 H890619X;
label value IPDWCP04 H890620X;
label value IPFEXP04 H890621X;
label value IPFMCD04 H890622X;
label value IPFMCR04 H890623X;
label value IPFOFD04 H890624X;
label value IPFOPR04 H890625X;
label value IPFOPU04 H890626X;
label value IPFOSR04 H890627X;
label value IPFPRV04 H890628X;
label value IPFSLF04 H890629X;
label value IPFSTL04 H890630X;
label value IPFTCH04 H890631X;
label value IPFTRI04 H890632X;
label value IPFVA04 H890633X;
label value IPFWCP04 H890634X;
label value IPNGTD04 H890635X;
label value IPZERO04 H890636X;
label value IRAIMP04 H890637X;
label value IRASP04X H890638X;
label value JNTPID04 H890639X;
label value JOBORG31 H890640X;
label value JOBORG42 H890641X;
label value JOBORG53 H890642X;
label value JTINRU04 H890643X;
label value JTPAIN53 H890644X;
label value K6SUM42 H890645X;
label value KEYNESS H890646X;
label value KIDPRO42 H890647X;
label value KNOWDR42 H890648X;
label value LANGHM42 H890649X;
label value LANGPR42 H890650X;
label value LAPBLT42 H890651X;
label value LFTDIF31 H890652X;
label value LFTDIF53 H890653X;
label value LKINFM42 H890654X;
label value LKINFT42 H890655X;
label value LOCATN42 H890656X;
label value LSHLTH42 H890657X;
label value LSTETH53 H890658X;
label value MAMOGR53 H890659X;
label value MARRY04X H890660X;
label value MARRY31X H890661X;
label value MARRY42X H890662X;
label value MARRY53X H890663X;
label value MCAID04 H890664X;
label value MCAID04X H890665X;
label value MCAID31 H890666X;
label value MCAID31X H890667X;
label value MCAID42 H890668X;
label value MCAID42X H890669X;
label value MCAID53 H890670X;
label value MCAID53X H890671X;
label value MCARE04 H890672X;
label value MCARE04X H890673X;
label value MCARE31 H890674X;
label value MCARE31X H890675X;
label value MCARE42 H890676X;
label value MCARE42X H890677X;
label value MCARE53 H890678X;
label value MCARE53X H890679X;
label value MCDAP04 H890680X;
label value MCDAP04X H890681X;
label value MCDAT04X H890682X;
label value MCDAT31X H890683X;
label value MCDAT42X H890684X;
label value MCDAT53X H890685X;
label value MCDAU04 H890686X;
label value MCDAU04X H890687X;
label value MCDDE04 H890688X;
label value MCDDE04X H890689X;
label value MCDEV04 H890690X;
label value MCDFE04 H890691X;
label value MCDFE04X H890692X;
label value MCDHMO04 H890693X;
label value MCDHMO31 H890694X;
label value MCDHMO42 H890695X;
label value MCDJA04 H890696X;
label value MCDJA04X H890697X;
label value MCDJL04 H890698X;
label value MCDJL04X H890699X;
label value MCDJU04 H890700X;
label value MCDJU04X H890701X;
label value MCDMA04 H890702X;
label value MCDMA04X H890703X;
label value MCDMC04 H890704X;
label value MCDMC31 H890705X;
label value MCDMC42 H890706X;
label value MCDMY04 H890707X;
label value MCDMY04X H890708X;
label value MCDNO04 H890709X;
label value MCDNO04X H890710X;
label value MCDOC04 H890711X;
label value MCDOC04X H890712X;
label value MCDSE04 H890713X;
label value MCDSE04X H890714X;
label value MCRAP04 H890715X;
label value MCRAP04X H890716X;
label value MCRAU04 H890717X;
label value MCRAU04X H890718X;
label value MCRDE04 H890719X;
label value MCRDE04X H890720X;
label value MCREV04 H890721X;
label value MCRFE04 H890722X;
label value MCRFE04X H890723X;
label value MCRJA04 H890724X;
label value MCRJA04X H890725X;
label value MCRJL04 H890726X;
label value MCRJL04X H890727X;
label value MCRJU04 H890728X;
label value MCRJU04X H890729X;
label value MCRMA04 H890730X;
label value MCRMA04X H890731X;
label value MCRMY04 H890732X;
label value MCRMY04X H890733X;
label value MCRNO04 H890734X;
label value MCRNO04X H890735X;
label value MCROC04 H890736X;
label value MCROC04X H890737X;
label value MCRSE04 H890738X;
label value MCRSE04X H890739X;
label value MDDLAY42 H890740X;
label value MDDLPR42 H890741X;
label value MDDLRS42 H890742X;
label value MDUNAB42 H890743X;
label value MDUNPR42 H890744X;
label value MDUNRS42 H890745X;
label value MESBPR42 H890746X;
label value MESHGT42 H890747X;
label value MESVIS42 H890748X;
label value MESWGT42 H890749X;
label value MIDX53 H890750X;
label value MILDIF31 H890751X;
label value MILDIF53 H890752X;
label value MINORP42 H890753X;
label value MNHLTH31 H890754X;
label value MNHLTH42 H890755X;
label value MNHLTH53 H890756X;
label value MOMPRO42 H890757X;
label value MORE31 H890758X;
label value MORE42 H890759X;
label value MORE53 H890760X;
label value MORECOVR H890761X;
label value MORJOB31 H890762X;
label value MORJOB42 H890763X;
label value MORJOB53 H890764X;
label value MSA04 H890765X;
label value MSA31 H890766X;
label value MSA42 H890767X;
label value MSA53 H890768X;
label value MYSELF42 H890769X;
label value NATAMP42 H890770X;
label value NERVAF42 H890771X;
label value NEVILL42 H890772X;
label value NEWARE42 H890773X;
label value NHRWG31 H890774X;
label value NHRWG42 H890775X;
label value NHRWG53 H890776X;
label value NOASPR53 H890777X;
label value NOFAT53 H890778X;
label value NOINSBEF H890779X;
label value NOINSTM H890780X;
label value NOINUNIT H890781X;
label value NOREAS42 H890782X;
label value NOSMOK42 H890783X;
label value NUMEMP31 H890784X;
label value NUMEMP42 H890785X;
label value NUMEMP53 H890786X;
label value NWK31 H890787X;
label value NWK42 H890788X;
label value NWK53 H890789X;
label value OBAEXP04 H890790X;
label value OBAMCD04 H890791X;
label value OBAMCR04 H890792X;
label value OBAOFD04 H890793X;
label value OBAOPR04 H890794X;
label value OBAOPU04 H890795X;
label value OBAOSR04 H890796X;
label value OBAPRV04 H890797X;
label value OBASLF04 H890798X;
label value OBASST04 H890799X;
label value OBASTL04 H890800X;
label value OBATCH04 H890801X;
label value OBATRI04 H890802X;
label value OBAVA04 H890803X;
label value OBAWCP04 H890804X;
label value OBCEXP04 H890805X;
label value OBCHIR04 H890806X;
label value OBCMCD04 H890807X;
label value OBCMCR04 H890808X;
label value OBCOFD04 H890809X;
label value OBCOPR04 H890810X;
label value OBCOPU04 H890811X;
label value OBCOSR04 H890812X;
label value OBCPRV04 H890813X;
label value OBCSLF04 H890814X;
label value OBCSTL04 H890815X;
label value OBCTCH04 H890816X;
label value OBCTRI04 H890817X;
label value OBCVA04 H890818X;
label value OBCWCP04 H890819X;
label value OBDEXP04 H890820X;
label value OBDMCD04 H890821X;
label value OBDMCR04 H890822X;
label value OBDOFD04 H890823X;
label value OBDOPR04 H890824X;
label value OBDOPU04 H890825X;
label value OBDOSR04 H890826X;
label value OBDPRV04 H890827X;
label value OBDRV04 H890828X;
label value OBDSLF04 H890829X;
label value OBDSTL04 H890830X;
label value OBDTCH04 H890831X;
label value OBDTRI04 H890832X;
label value OBDVA04 H890833X;
label value OBDWCP04 H890834X;
label value OBEEXP04 H890835X;
label value OBEMCD04 H890836X;
label value OBEMCR04 H890837X;
label value OBEOFD04 H890838X;
label value OBEOPR04 H890839X;
label value OBEOPU04 H890840X;
label value OBEOSR04 H890841X;
label value OBEPRV04 H890842X;
label value OBESLF04 H890843X;
label value OBESTL04 H890844X;
label value OBETCH04 H890845X;
label value OBETRI04 H890846X;
label value OBEVA04 H890847X;
label value OBEWCP04 H890848X;
label value OBNEXP04 H890849X;
label value OBNMCD04 H890850X;
label value OBNMCR04 H890851X;
label value OBNOFD04 H890852X;
label value OBNOPR04 H890853X;
label value OBNOPU04 H890854X;
label value OBNOSR04 H890855X;
label value OBNPRV04 H890856X;
label value OBNSLF04 H890857X;
label value OBNSTL04 H890858X;
label value OBNTCH04 H890859X;
label value OBNTRI04 H890860X;
label value OBNURS04 H890861X;
label value OBNVA04 H890862X;
label value OBNWCP04 H890863X;
label value OBOEXP04 H890864X;
label value OBOMCD04 H890865X;
label value OBOMCR04 H890866X;
label value OBOOFD04 H890867X;
label value OBOOPR04 H890868X;
label value OBOOPU04 H890869X;
label value OBOOSR04 H890870X;
label value OBOPRV04 H890871X;
label value OBOPTO04 H890872X;
label value OBOSLF04 H890873X;
label value OBOSTL04 H890874X;
label value OBOTCH04 H890875X;
label value OBOTHV04 H890876X;
label value OBOTRI04 H890877X;
label value OBOVA04 H890878X;
label value OBOWCP04 H890879X;
label value OBTEXP04 H890880X;
label value OBTHER04 H890881X;
label value OBTMCD04 H890882X;
label value OBTMCR04 H890883X;
label value OBTOFD04 H890884X;
label value OBTOPR04 H890885X;
label value OBTOPU04 H890886X;
label value OBTOSR04 H890887X;
label value OBTOTV04 H890888X;
label value OBTPRV04 H890889X;
label value OBTSLF04 H890890X;
label value OBTSTL04 H890891X;
label value OBTTCH04 H890892X;
label value OBTTRI04 H890893X;
label value OBTVA04 H890894X;
label value OBTWCP04 H890895X;
label value OBVEXP04 H890896X;
label value OBVMCD04 H890897X;
label value OBVMCR04 H890898X;
label value OBVOFD04 H890899X;
label value OBVOPR04 H890900X;
label value OBVOPU04 H890901X;
label value OBVOSR04 H890902X;
label value OBVPRV04 H890903X;
label value OBVSLF04 H890904X;
label value OBVSTL04 H890905X;
label value OBVTCH04 H890906X;
label value OBVTRI04 H890907X;
label value OBVVA04 H890908X;
label value OBVWCP04 H890909X;
label value OCCCAT31 H890910X;
label value OCCCAT42 H890911X;
label value OCCCAT53 H890912X;
label value OFFER31X H890913X;
label value OFFER42X H890914X;
label value OFFER53X H890915X;
label value OFFHOU42 H890916X;
label value OFREMP31 H890917X;
label value OFREMP42 H890918X;
label value OFREMP53 H890919X;
label value OHRTDX53 H890920X;
label value ONGONG42 H890921X;
label value OPAAP04 H890922X;
label value OPAAU04 H890923X;
label value OPADE04 H890924X;
label value OPAEV04 H890925X;
label value OPAFE04 H890926X;
label value OPAJA04 H890927X;
label value OPAJL04 H890928X;
label value OPAJU04 H890929X;
label value OPAMA04 H890930X;
label value OPAMY04 H890931X;
label value OPANO04 H890932X;
label value OPAOC04 H890933X;
label value OPASE04 H890934X;
label value OPBAP04 H890935X;
label value OPBAU04 H890936X;
label value OPBDE04 H890937X;
label value OPBEV04 H890938X;
label value OPBFE04 H890939X;
label value OPBJA04 H890940X;
label value OPBJL04 H890941X;
label value OPBJU04 H890942X;
label value OPBMA04 H890943X;
label value OPBMY04 H890944X;
label value OPBNO04 H890945X;
label value OPBOC04 H890946X;
label value OPBSE04 H890947X;
label value OPDEXP04 H890948X;
label value OPDMCD04 H890949X;
label value OPDMCR04 H890950X;
label value OPDOFD04 H890951X;
label value OPDOPR04 H890952X;
label value OPDOPU04 H890953X;
label value OPDOSR04 H890954X;
label value OPDPRV04 H890955X;
label value OPDRV04 H890956X;
label value OPDSLF04 H890957X;
label value OPDSTL04 H890958X;
label value OPDTCH04 H890959X;
label value OPDTRI04 H890960X;
label value OPDVA04 H890961X;
label value OPDWCP04 H890962X;
label value OPFEXP04 H890963X;
label value OPFMCD04 H890964X;
label value OPFMCR04 H890965X;
label value OPFOFD04 H890966X;
label value OPFOPR04 H890967X;
label value OPFOPU04 H890968X;
label value OPFOSR04 H890969X;
label value OPFPRV04 H890970X;
label value OPFSLF04 H890971X;
label value OPFSTL04 H890972X;
label value OPFTCH04 H890973X;
label value OPFTRI04 H890974X;
label value OPFVA04 H890975X;
label value OPFWCP04 H890976X;
label value OPOEXP04 H890977X;
label value OPOMCD04 H890978X;
label value OPOMCR04 H890979X;
label value OPOOFD04 H890980X;
label value OPOOPR04 H890981X;
label value OPOOPU04 H890982X;
label value OPOOSR04 H890983X;
label value OPOPRV04 H890984X;
label value OPOSLF04 H890985X;
label value OPOSTL04 H890986X;
label value OPOTCH04 H890987X;
label value OPOTHV04 H890988X;
label value OPOTRI04 H890989X;
label value OPOVA04 H890990X;
label value OPOWCP04 H890991X;
label value OPPEXP04 H890992X;
label value OPPMCD04 H890993X;
label value OPPMCR04 H890994X;
label value OPPOFD04 H890995X;
label value OPPOPR04 H890996X;
label value OPPOPU04 H890997X;
label value OPPOSR04 H890998X;
label value OPPPRV04 H890999X;
label value OPPSLF04 H891000X;
label value OPPSTL04 H891001X;
label value OPPTCH04 H891002X;
label value OPPTRI04 H891003X;
label value OPPVA04 H891004X;
label value OPPWCP04 H891005X;
label value OPSEXP04 H891006X;
label value OPSMCD04 H891007X;
label value OPSMCR04 H891008X;
label value OPSOFD04 H891009X;
label value OPSOPR04 H891010X;
label value OPSOPU04 H891011X;
label value OPSOSR04 H891012X;
label value OPSPRV04 H891013X;
label value OPSSLF04 H891014X;
label value OPSSTL04 H891015X;
label value OPSTCH04 H891016X;
label value OPSTRI04 H891017X;
label value OPSVA04 H891018X;
label value OPSWCP04 H891019X;
label value OPTOTV04 H891020X;
label value OPVEXP04 H891021X;
label value OPVMCD04 H891022X;
label value OPVMCR04 H891023X;
label value OPVOFD04 H891024X;
label value OPVOPR04 H891025X;
label value OPVOPU04 H891026X;
label value OPVOSR04 H891027X;
label value OPVPRV04 H891028X;
label value OPVSLF04 H891029X;
label value OPVSTL04 H891030X;
label value OPVTCH04 H891031X;
label value OPVTRI04 H891032X;
label value OPVVA04 H891033X;
label value OPVWCP04 H891034X;
label value OTHDYS31 H891035X;
label value OTHDYS42 H891036X;
label value OTHDYS53 H891037X;
label value OTHEXP04 H891038X;
label value OTHIMP04 H891039X;
label value OTHINS42 H891040X;
label value OTHMCD04 H891041X;
label value OTHMCR04 H891042X;
label value OTHNDD31 H891043X;
label value OTHNDD42 H891044X;
label value OTHNDD53 H891045X;
label value OTHOFD04 H891046X;
label value OTHOPR04 H891047X;
label value OTHOPU04 H891048X;
label value OTHOSR04 H891049X;
label value OTHPRV04 H891050X;
label value OTHRCP42 H891051X;
label value OTHREA42 H891052X;
label value OTHRP04X H891053X;
label value OTHSLF04 H891054X;
label value OTHSTL04 H891055X;
label value OTHTCH04 H891056X;
label value OTHTRI04 H891057X;
label value OTHVA04 H891058X;
label value OTHWCP04 H891059X;
label value OTPAAT04 H891060X;
label value OTPAAT31 H891061X;
label value OTPAAT42 H891062X;
label value OTPAAT53 H891063X;
label value OTPBAT04 H891064X;
label value OTPBAT31 H891065X;
label value OTPBAT42 H891066X;
label value OTPBAT53 H891067X;
label value OTPUBA04 H891068X;
label value OTPUBA31 H891069X;
label value OTPUBA42 H891070X;
label value OTPUBA53 H891071X;
label value OTPUBB04 H891072X;
label value OTPUBB31 H891073X;
label value OTPUBB42 H891074X;
label value OTPUBB53 H891075X;
label value PACISP42 H891076X;
label value PANEL04 H891077X;
label value PAPSMR53 H891078X;
label value PAYDR31 H891079X;
label value PAYDR42 H891080X;
label value PAYDR53 H891081X;
label value PAYVAC31 H891082X;
label value PAYVAC42 H891083X;
label value PAYVAC53 H891084X;
label value PBINFM42 H891085X;
label value PBINFT42 H891086X;
label value PBPWKM42 H891087X;
label value PBPWKT42 H891088X;
label value PBSVCM42 H891089X;
label value PBSVCT42 H891090X;
label value PDKAP04 H891091X;
label value PDKAU04 H891092X;
label value PDKDE04 H891093X;
label value PDKFE04 H891094X;
label value PDKJA04 H891095X;
label value PDKJL04 H891096X;
label value PDKJU04 H891097X;
label value PDKMA04 H891098X;
label value PDKMY04 H891099X;
label value PDKNO04 H891100X;
label value PDKOC04 H891101X;
label value PDKSE04 H891102X;
label value PEGAP04 H891103X;
label value PEGAU04 H891104X;
label value PEGDE04 H891105X;
label value PEGFE04 H891106X;
label value PEGJA04 H891107X;
label value PEGJL04 H891108X;
label value PEGJU04 H891109X;
label value PEGMA04 H891110X;
label value PEGMY04 H891111X;
label value PEGNO04 H891112X;
label value PEGOC04 H891113X;
label value PEGSE04 H891114X;
label value PENIMP04 H891115X;
label value PENSP04X H891116X;
label value PERSLA42 H891117X;
label value PHMONP04 H891118X;
label value PHMONP31 H891119X;
label value PHMONP42 H891120X;
label value PHNREG42 H891121X;
label value PHQ242 H891122X;
label value PHYACT53 H891123X;
label value PHYSCL42 H891124X;
label value PLCTYP42 H891125X;
label value PMDLAY42 H891126X;
label value PMDLPR42 H891127X;
label value PMDLRS42 H891128X;
label value PMEDIN31 H891129X;
label value PMEDIN42 H891130X;
label value PMEDIN53 H891131X;
label value PMNCNP04 H891132X;
label value PMNCNP31 H891133X;
label value PMNCNP42 H891134X;
label value PMUNAB42 H891135X;
label value PMUNPR42 H891136X;
label value PMUNRS42 H891137X;
label value PNGAP04 H891138X;
label value PNGAU04 H891139X;
label value PNGDE04 H891140X;
label value PNGFE04 H891141X;
label value PNGJA04 H891142X;
label value PNGJL04 H891143X;
label value PNGJU04 H891144X;
label value PNGMA04 H891145X;
label value PNGMY04 H891146X;
label value PNGNO04 H891147X;
label value PNGOC04 H891148X;
label value PNGSE04 H891149X;
label value POGAP04 H891150X;
label value POGAU04 H891151X;
label value POGDE04 H891152X;
label value POGFE04 H891153X;
label value POGJA04 H891154X;
label value POGJL04 H891155X;
label value POGJU04 H891156X;
label value POGMA04 H891157X;
label value POGMY04 H891158X;
label value POGNO04 H891159X;
label value POGOC04 H891160X;
label value POGSE04 H891161X;
label value POUAP04 H891162X;
label value POUAU04 H891163X;
label value POUDE04 H891164X;
label value POUFE04 H891165X;
label value POUJA04 H891166X;
label value POUJL04 H891167X;
label value POUJU04 H891168X;
label value POUMA04 H891169X;
label value POUMY04 H891170X;
label value POUNO04 H891171X;
label value POUOC04 H891172X;
label value POUSE04 H891173X;
label value POVCAT04 H891174X;
label value PPRWKM42 H891175X;
label value PPRWKT42 H891176X;
label value PRDRNP04 H891177X;
label value PRDRNP31 H891178X;
label value PRDRNP42 H891179X;
label value PREVCOVR H891180X;
label value PREVEN42 H891181X;
label value PRIAP04 H891182X;
label value PRIAU04 H891183X;
label value PRIDE04 H891184X;
label value PRIDK04 H891185X;
label value PRIDK31 H891186X;
label value PRIDK42 H891187X;
label value PRIDK53 H891188X;
label value PRIEU04 H891189X;
label value PRIEU31 H891190X;
label value PRIEU42 H891191X;
label value PRIEU53 H891192X;
label value PRIFE04 H891193X;
label value PRIJA04 H891194X;
label value PRIJL04 H891195X;
label value PRIJU04 H891196X;
label value PRIMA04 H891197X;
label value PRIMY04 H891198X;
label value PRING04 H891199X;
label value PRING31 H891200X;
label value PRING42 H891201X;
label value PRING53 H891202X;
label value PRINO04 H891203X;
label value PRIOC04 H891204X;
label value PRIOG04 H891205X;
label value PRIOG31 H891206X;
label value PRIOG42 H891207X;
label value PRIOG53 H891208X;
label value PRIS04 H891209X;
label value PRIS31 H891210X;
label value PRIS42 H891211X;
label value PRIS53 H891212X;
label value PRISE04 H891213X;
label value PRIV04 H891214X;
label value PRIV31 H891215X;
label value PRIV42 H891216X;
label value PRIV53 H891217X;
label value PRIVAT04 H891218X;
label value PRIVAT31 H891219X;
label value PRIVAT42 H891220X;
label value PRIVAT53 H891221X;
label value PROUT04 H891222X;
label value PROUT31 H891223X;
label value PROUT42 H891224X;
label value PROUT53 H891225X;
label value PROVTY42 H891226X;
label value PROXY04 H891227X;
label value PROXY31 H891228X;
label value PROXY42 H891229X;
label value PROXY53 H891230X;
label value PRSAP04 H891231X;
label value PRSAU04 H891232X;
label value PRSDE04 H891233X;
label value PRSFE04 H891234X;
label value PRSJA04 H891235X;
label value PRSJL04 H891236X;
label value PRSJU04 H891237X;
label value PRSMA04 H891238X;
label value PRSMY04 H891239X;
label value PRSNO04 H891240X;
label value PRSOC04 H891241X;
label value PRSSE04 H891242X;
label value PRVDRL04 H891243X;
label value PRVDRL31 H891244X;
label value PRVDRL42 H891245X;
label value PRVEV04 H891246X;
label value PRVHMO04 H891247X;
label value PRVHMO31 H891248X;
label value PRVHMO42 H891249X;
label value PRVMNC04 H891250X;
label value PRVMNC31 H891251X;
label value PRVMNC42 H891252X;
label value PSA53 H891253X;
label value PSTATS31 H891254X;
label value PSTATS42 H891255X;
label value PSTATS53 H891256X;
label value PUB04X H891257X;
label value PUB31X H891258X;
label value PUB42X H891259X;
label value PUB53X H891260X;
label value PUBAP04X H891261X;
label value PUBAT04X H891262X;
label value PUBAT31X H891263X;
label value PUBAT42X H891264X;
label value PUBAT53X H891265X;
label value PUBAU04X H891266X;
label value PUBDE04X H891267X;
label value PUBFE04X H891268X;
label value PUBIMP04 H891269X;
label value PUBJA04X H891270X;
label value PUBJL04X H891271X;
label value PUBJU04X H891272X;
label value PUBMA04X H891273X;
label value PUBMY04X H891274X;
label value PUBNO04X H891275X;
label value PUBOC04X H891276X;
label value PUBP04X H891277X;
label value PUBSE04X H891278X;
label value RACEAX H891279X;
label value RACEBX H891280X;
label value RACETHNX H891281X;
label value RACEWX H891282X;
label value RACEX H891283X;
label value RCHDIF31 H891284X;
label value RCHDIF53 H891285X;
label value READNW42 H891286X;
label value RECPEP42 H891287X;
label value REFDP04X H891288X;
label value REFFRL42 H891289X;
label value REFIMP04 H891290X;
label value REGION04 H891291X;
label value REGION31 H891292X;
label value REGION42 H891293X;
label value REGION53 H891294X;
label value RESP04 H891295X;
label value RESP31 H891296X;
label value RESP42 H891297X;
label value RESP53 H891298X;
label value RESPCT42 H891299X;
label value RETPLN31 H891300X;
label value RETPLN42 H891301X;
label value RETPLN53 H891302X;
label value RFREL04X H891303X;
label value RFREL31X H891304X;
label value RFREL42X H891305X;
label value RFREL53X H891306X;
label value RNDFLG31 H891307X;
label value RTHLTH31 H891308X;
label value RTHLTH42 H891309X;
label value RTHLTH53 H891310X;
label value RTPLNM42 H891311X;
label value RTPLNT42 H891312X;
label value RUCLAS04 H891313X;
label value RUCLAS31 H891314X;
label value RUCLAS42 H891315X;
label value RUCLAS53 H891316X;
label value RUSIZE04 H891317X;
label value RUSIZE31 H891318X;
label value RUSIZE42 H891319X;
label value RUSIZE53 H891320X;
label value RXEXP04 H891321X;
label value RXMCD04 H891322X;
label value RXMCR04 H891323X;
label value RXOFD04 H891324X;
label value RXOPR04 H891325X;
label value RXOPU04 H891326X;
label value RXOSR04 H891327X;
label value RXPRV04 H891328X;
label value RXSLF04 H891329X;
label value RXSTL04 H891330X;
label value RXTOT04 H891331X;
label value RXTRI04 H891332X;
label value RXVA04 H891333X;
label value RXWCP04 H891334X;
label value SAFEST42 H891335X;
label value SALEP04X H891336X;
label value SALIMP04 H891337X;
label value SAQELIG H891338X;
label value SCHLBH42 H891339X;
label value SCHLIM31 H891340X;
label value SCHLIM53 H891341X;
label value SCHPRO42 H891342X;
label value SCLNBD31 H891343X;
label value SCLNBD42 H891344X;
label value SCLNBD53 H891345X;
label value SEATBE53 H891346X;
label value SEEDIF42 H891347X;
label value SELDSI42 H891348X;
label value SELFCM31 H891349X;
label value SELFCM42 H891350X;
label value SELFCM53 H891351X;
label value SEX H891352X;
label value SFFLAG42 H891353X;
label value SIBPRO42 H891354X;
label value SICEAS42 H891355X;
label value SICPAY31 H891356X;
label value SICPAY42 H891357X;
label value SICPAY53 H891358X;
label value SOCLIM31 H891359X;
label value SOCLIM53 H891360X;
label value SPOUID04 H891361X;
label value SPOUID31 H891362X;
label value SPOUID42 H891363X;
label value SPOUID53 H891364X;
label value SPOUIN04 H891365X;
label value SPOUIN31 H891366X;
label value SPOUIN42 H891367X;
label value SPOUIN53 H891368X;
label value SPRPRO42 H891369X;
label value SRTHRT53 H891370X;
label value SSCIMP04 H891371X;
label value SSECP04X H891372X;
label value SSIDIS04 H891373X;
label value SSIIMP04 H891374X;
label value SSIP04X H891375X;
label value SSNLJB31 H891376X;
label value SSNLJB42 H891377X;
label value SSNLJB53 H891378X;
label value STAAP04 H891379X;
label value STAAU04 H891380X;
label value STADE04 H891381X;
label value STAFE04 H891382X;
label value STAJA04 H891383X;
label value STAJL04 H891384X;
label value STAJU04 H891385X;
label value STAMA04 H891386X;
label value STAMY04 H891387X;
label value STANO04 H891388X;
label value STAOC04 H891389X;
label value STAPR04 H891390X;
label value STAPR31 H891391X;
label value STAPR42 H891392X;
label value STAPR53 H891393X;
label value STASE04 H891394X;
label value STJBDD31 H891395X;
label value STJBDD42 H891396X;
label value STJBDD53 H891397X;
label value STJBMM31 H891398X;
label value STJBMM42 H891399X;
label value STJBMM53 H891400X;
label value STJBYY31 H891401X;
label value STJBYY42 H891402X;
label value STJBYY53 H891403X;
label value STNDIF31 H891404X;
label value STNDIF53 H891405X;
label value STOMCH53 H891406X;
label value STOOL53 H891407X;
label value STPDIF31 H891408X;
label value STPDIF53 H891409X;
label value STPRAT04 H891410X;
label value STPRAT31 H891411X;
label value STPRAT42 H891412X;
label value STPRAT53 H891413X;
label value STRKDX53 H891414X;
label value TAXFRM04 H891415X;
label value TEMPJB31 H891416X;
label value TEMPJB42 H891417X;
label value TEMPJB53 H891418X;
label value THANTB53 H891419X;
label value THANTF53 H891420X;
label value THSWAB53 H891421X;
label value THSWBF53 H891422X;
label value THSYMF53 H891423X;
label value THSYMP53 H891424X;
label value TIMALN42 H891425X;
label value TMTKUS42 H891426X;
label value TOTDED04 H891427X;
label value TOTEXP04 H891428X;
label value TOTMCD04 H891429X;
label value TOTMCR04 H891430X;
label value TOTOFD04 H891431X;
label value TOTOPR04 H891432X;
label value TOTOPU04 H891433X;
label value TOTOSR04 H891434X;
label value TOTPRV04 H891435X;
label value TOTSLF04 H891436X;
label value TOTSTL04 H891437X;
label value TOTTCH04 H891438X;
label value TOTTRI04 H891439X;
label value TOTVA04 H891440X;
label value TOTWCP04 H891441X;
label value TRANS42 H891442X;
label value TRBLE42 H891443X;
label value TREATM42 H891444X;
label value TRIAP04X H891445X;
label value TRIAT04X H891446X;
label value TRIAT31X H891447X;
label value TRIAT42X H891448X;
label value TRIAT53X H891449X;
label value TRIAU04X H891450X;
label value TRICR04X H891451X;
label value TRICR31X H891452X;
label value TRICR42X H891453X;
label value TRICR53X H891454X;
label value TRIDE04X H891455X;
label value TRIEV04 H891456X;
label value TRIEX04X H891457X;
label value TRIEX31X H891458X;
label value TRIEX42X H891459X;
label value TRIFE04X H891460X;
label value TRIJA04X H891461X;
label value TRIJL04X H891462X;
label value TRIJU04X H891463X;
label value TRILI04X H891464X;
label value TRILI31X H891465X;
label value TRILI42X H891466X;
label value TRIMA04X H891467X;
label value TRIMY04X H891468X;
label value TRINO04X H891469X;
label value TRIOC04X H891470X;
label value TRIPR04X H891471X;
label value TRIPR31X H891472X;
label value TRIPR42X H891473X;
label value TRISE04X H891474X;
label value TRIST04X H891475X;
label value TRIST31X H891476X;
label value TRIST42X H891477X;
label value TRSTP04X H891478X;
label value TRTIMP04 H891479X;
label value TTLP04X H891480X;
label value TYPEPE42 H891481X;
label value UNABLE31 H891482X;
label value UNABLE53 H891483X;
label value UNEIMP04 H891484X;
label value UNEMP04X H891485X;
label value UNHAP42 H891486X;
label value UNINS04 H891487X;
label value UNION31 H891488X;
label value UNION42 H891489X;
label value UNION53 H891490X;
label value USCNOT42 H891491X;
label value VETGULF H891492X;
label value VETIMP04 H891493X;
label value VETKOR H891494X;
label value VETOTH H891495X;
label value VETSP04X H891496X;
label value VETVIET H891497X;
label value VETWW H891498X;
label value VISEXP04 H891499X;
label value VISION42 H891500X;
label value VISMCD04 H891501X;
label value VISMCR04 H891502X;
label value VISOFD04 H891503X;
label value VISOPR04 H891504X;
label value VISOPU04 H891505X;
label value VISOSR04 H891506X;
label value VISPRV04 H891507X;
label value VISSLF04 H891508X;
label value VISSTL04 H891509X;
label value VISTCH04 H891510X;
label value VISTRI04 H891511X;
label value VISVA04 H891512X;
label value VISWCP04 H891513X;
label value WAGEP04X H891514X;
label value WAGIMP04 H891515X;
label value WASAFDC H891516X;
label value WASCHAMP H891517X;
label value WASESTB H891518X;
label value WASMCAID H891519X;
label value WASMCARE H891520X;
label value WASOTGOV H891521X;
label value WASOTHER H891522X;
label value WASPRIV H891523X;
label value WASSSI H891524X;
label value WASSTAT1 H891525X;
label value WASSTAT2 H891526X;
label value WASSTAT3 H891527X;
label value WASSTAT4 H891528X;
label value WASVA H891529X;
label value WCMPP04X H891530X;
label value WCPIMP04 H891531X;
label value WHENST53 H891532X;
label value WHITPR42 H891533X;
label value WHNBPR42 H891534X;
label value WHNBST42 H891535X;
label value WHNBWL53 H891536X;
label value WHNDEN42 H891537X;
label value WHNEAT42 H891538X;
label value WHNHEL42 H891539X;
label value WHNHGT42 H891540X;
label value WHNLAP42 H891541X;
label value WHNPHY42 H891542X;
label value WHNSAF42 H891543X;
label value WHNSMK42 H891544X;
label value WHNWGT42 H891545X;
label value WILFIL04 H891546X;
label value WKINBD31 H891547X;
label value WKINBD42 H891548X;
label value WKINBD53 H891549X;
label value WLK3MO31 H891550X;
label value WLK3MO53 H891551X;
label value WLKDIF31 H891552X;
label value WLKDIF53 H891553X;
label value WLKLIM31 H891554X;
label value WLKLIM53 H891555X;
label value WRGLAS42 H891556X;
label value WRHLTH42 H891557X;
label value WRKLIM31 H891558X;
label value WRKLIM53 H891559X;
label value YCHJ3142 H891560X;
label value YCHJ4253 H891561X;
label value YNOINS31 H891562X;
label value YNOINS42 H891563X;
label value YNOINS53 H891564X;
label value YNOUSC42 H891565X;
label value ZIDEXP04 H891566X;
label value ZIDMCD04 H891567X;
label value ZIDMCR04 H891568X;
label value ZIDOFD04 H891569X;
label value ZIDOPR04 H891570X;
label value ZIDOPU04 H891571X;
label value ZIDOSR04 H891572X;
label value ZIDPRV04 H891573X;
label value ZIDSLF04 H891574X;
label value ZIDSTL04 H891575X;
label value ZIDTCH04 H891576X;
label value ZIDTRI04 H891577X;
label value ZIDVA04 H891578X;
label value ZIDWCP04 H891579X;
label value ZIFEXP04 H891580X;
label value ZIFMCD04 H891581X;
label value ZIFMCR04 H891582X;
label value ZIFOFD04 H891583X;
label value ZIFOPR04 H891584X;
label value ZIFOPU04 H891585X;
label value ZIFOSR04 H891586X;
label value ZIFPRV04 H891587X;
label value ZIFSLF04 H891588X;
label value ZIFSTL04 H891589X;
label value ZIFTCH04 H891590X;
label value ZIFTRI04 H891591X;
label value ZIFVA04 H891592X;
label value ZIFWCP04 H891593X;

*DISPLAY A DESCRIPTION OF STATA FILE;
describe;

*LIST FIRST 20 OBSERVATIONS IN THE FILE;
list in 1/20;


#delimit cr



/************************************************************************************************
 NOTES:                                                                                          
                                                                                                 
 1. This program has been tested on Stata Version 10 (for Windows).                              
                                                                                                 
 2. This program will create a permanent Stata dataset.  All additional analyses                 
    can be run using this dataset.  In addition to the dataset, this program creates             
    a log file named H89.LOG and a data file named H89.DTA.  If these files (H89.DTA and H89.LOG)
    already exist in the working directory, they will be replaced when this program is executed. 
                                                                                                 
 3. If the program ends prematurely, the log file will remain open.  Before running this         
    program again, the user should enter the following Stata command: log close                  
                                                                                                 
 4. The cd command assigns C:\MEPS\DATA as the working directory and location of the input       
    ASCII and output .DTA and .LOG files and can be modified by the user as necessary.           
                                                                                                 
 5. Stata commands end with a carriage return by default. The command                            
    #delimit ;                                                                                   
    temporarily changes the command ending delimiter from a carriage return to a semicolon.      
                                                                                                 
 6. The infix command assumes that the input variables are numeric unless the variable name      
    is prefaced by str.  For example, DUPERSID is the a string (or character) variable.          
                                                                                                 
************************************************************************************************/

